/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopDocsCollector;
import org.apache.lucene.util.PriorityQueue;

public abstract class DiversifiedTopDocsCollector
extends TopDocsCollector<ScoreDocKey> {
    ScoreDocKey spare;
    private ScoreDocKeyQueue globalQueue;
    private int numHits;
    private Map<Long, ScoreDocKeyQueue> perKeyQueues;
    protected int maxNumPerKey;
    private Stack<ScoreDocKeyQueue> sparePerKeyQueues = new Stack();

    public DiversifiedTopDocsCollector(int numHits, int maxHitsPerKey) {
        super(new ScoreDocKeyQueue(numHits));
        this.globalQueue = (ScoreDocKeyQueue)this.pq;
        this.perKeyQueues = new HashMap<Long, ScoreDocKeyQueue>();
        this.numHits = numHits;
        this.maxNumPerKey = maxHitsPerKey;
    }

    protected abstract NumericDocValues getKeys(LeafReaderContext var1);

    @Override
    public boolean needsScores() {
        return true;
    }

    @Override
    protected TopDocs newTopDocs(ScoreDoc[] results, int start) {
        if (results == null) {
            return EMPTY_TOPDOCS;
        }
        float maxScore = Float.NaN;
        if (start == 0) {
            maxScore = results[0].score;
        } else {
            for (int i = this.globalQueue.size(); i > 1; --i) {
                this.globalQueue.pop();
            }
            maxScore = ((ScoreDocKey)this.globalQueue.pop()).score;
        }
        return new TopDocs(this.totalHits, results, maxScore);
    }

    protected ScoreDocKey insert(ScoreDocKey addition, int docBase, NumericDocValues keys2) {
        ScoreDocKey perKeyOverflow;
        if (this.globalQueue.size() >= this.numHits && this.globalQueue.lessThan(addition, (ScoreDocKey)this.globalQueue.top())) {
            return addition;
        }
        addition.key = keys2.get(addition.doc - docBase);
        ScoreDocKeyQueue thisKeyQ = this.perKeyQueues.get(addition.key);
        if (thisKeyQ == null) {
            thisKeyQ = this.sparePerKeyQueues.size() == 0 ? new ScoreDocKeyQueue(this.maxNumPerKey) : this.sparePerKeyQueues.pop();
            this.perKeyQueues.put(addition.key, thisKeyQ);
        }
        if ((perKeyOverflow = thisKeyQ.insertWithOverflow(addition)) == addition) {
            return addition;
        }
        if (perKeyOverflow == null) {
            ScoreDocKey globalOverflow = this.globalQueue.insertWithOverflow(addition);
            this.perKeyGroupRemove(globalOverflow);
            return globalOverflow;
        }
        this.globalQueue.remove(perKeyOverflow);
        this.globalQueue.add(addition);
        return perKeyOverflow;
    }

    private void perKeyGroupRemove(ScoreDocKey globalOverflow) {
        if (globalOverflow == null) {
            return;
        }
        ScoreDocKeyQueue q = this.perKeyQueues.get(globalOverflow.key);
        ScoreDocKey perKeyLowest = (ScoreDocKey)q.pop();
        assert (globalOverflow == perKeyLowest);
        if (q.size() == 0) {
            this.perKeyQueues.remove(globalOverflow.key);
            this.sparePerKeyQueues.push(q);
        }
    }

    @Override
    public LeafCollector getLeafCollector(LeafReaderContext context) throws IOException {
        final int base = context.docBase;
        final NumericDocValues keySource = this.getKeys(context);
        return new LeafCollector(){
            Scorer scorer;

            @Override
            public void setScorer(Scorer scorer) throws IOException {
                this.scorer = scorer;
            }

            @Override
            public void collect(int doc2) throws IOException {
                float score = this.scorer.score();
                assert (!Float.isNaN(score));
                ++DiversifiedTopDocsCollector.this.totalHits;
                doc2 += base;
                if (DiversifiedTopDocsCollector.this.spare == null) {
                    DiversifiedTopDocsCollector.this.spare = new ScoreDocKey(doc2, score);
                } else {
                    DiversifiedTopDocsCollector.this.spare.doc = doc2;
                    DiversifiedTopDocsCollector.this.spare.score = score;
                }
                DiversifiedTopDocsCollector.this.spare = DiversifiedTopDocsCollector.this.insert(DiversifiedTopDocsCollector.this.spare, base, keySource);
            }
        };
    }

    public static class ScoreDocKey
    extends ScoreDoc {
        Long key;

        protected ScoreDocKey(int doc2, float score) {
            super(doc2, score);
        }

        public Long getKey() {
            return this.key;
        }

        @Override
        public String toString() {
            return "key:" + this.key + " doc=" + this.doc + " s=" + this.score;
        }
    }

    static class ScoreDocKeyQueue
    extends PriorityQueue<ScoreDocKey> {
        ScoreDocKeyQueue(int size) {
            super(size);
        }

        @Override
        protected final boolean lessThan(ScoreDocKey hitA, ScoreDocKey hitB) {
            if (hitA.score == hitB.score) {
                return hitA.doc > hitB.doc;
            }
            return hitA.score < hitB.score;
        }
    }
}

