/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.function.valuesource;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.docvalues.DocTermsIndexDocValues;
import org.apache.lucene.queries.function.valuesource.FieldCacheSource;
import org.apache.lucene.search.SortedSetSelector;

public class SortedSetFieldSource
extends FieldCacheSource {
    protected final SortedSetSelector.Type selector;

    public SortedSetFieldSource(String field) {
        this(field, SortedSetSelector.Type.MIN);
    }

    public SortedSetFieldSource(String field, SortedSetSelector.Type selector) {
        super(field);
        this.selector = selector;
    }

    @Override
    public FunctionValues getValues(Map context, LeafReaderContext readerContext) throws IOException {
        SortedSetDocValues sortedSet = DocValues.getSortedSet(readerContext.reader(), this.field);
        SortedDocValues view = SortedSetSelector.wrap(sortedSet, this.selector);
        return new DocTermsIndexDocValues(this, view){

            @Override
            protected String toTerm(String readableValue) {
                return readableValue;
            }

            @Override
            public Object objectVal(int doc2) {
                return this.strVal(doc2);
            }
        };
    }

    @Override
    public String description() {
        return "sortedset(" + this.field + ",selector=" + (Object)((Object)this.selector) + ')';
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.selector == null ? 0 : this.selector.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SortedSetFieldSource other = (SortedSetFieldSource)obj;
        return this.selector == other.selector;
    }
}

