/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.misc;

import java.io.IOException;
import java.nio.file.Paths;
import java.util.Comparator;
import java.util.Locale;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.misc.TermStats;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.PriorityQueue;
import org.apache.lucene.util.SuppressForbidden;

public class HighFreqTerms {
    public static final int DEFAULT_NUMTERMS = 100;

    @SuppressForbidden(reason="System.out required: command line tool")
    public static void main(String[] args) throws Exception {
        String field = null;
        int numTerms = 100;
        if (args.length == 0 || args.length > 4) {
            HighFreqTerms.usage();
            System.exit(1);
        }
        FSDirectory dir2 = FSDirectory.open(Paths.get(args[0], new String[0]));
        Comparator<TermStats> comparator2 = new DocFreqComparator();
        for (int i = 1; i < args.length; ++i) {
            if (args[i].equals("-t")) {
                comparator2 = new TotalTermFreqComparator();
                continue;
            }
            try {
                numTerms = Integer.parseInt(args[i]);
                continue;
            }
            catch (NumberFormatException e2) {
                field = args[i];
            }
        }
        DirectoryReader reader2 = DirectoryReader.open(dir2);
        TermStats[] terms = HighFreqTerms.getHighFreqTerms(reader2, numTerms, field, comparator2);
        for (int i = 0; i < terms.length; ++i) {
            System.out.printf(Locale.ROOT, "%s:%s \t totalTF = %,d \t docFreq = %,d \n", terms[i].field, terms[i].termtext.utf8ToString(), terms[i].totalTermFreq, terms[i].docFreq);
        }
        reader2.close();
    }

    @SuppressForbidden(reason="System.out required: command line tool")
    private static void usage() {
        System.out.println("\n\njava org.apache.lucene.misc.HighFreqTerms <index dir> [-t] [number_terms] [field]\n\t -t: order by totalTermFreq\n\n");
    }

    public static TermStats[] getHighFreqTerms(IndexReader reader2, int numTerms, String field, Comparator<TermStats> comparator2) throws Exception {
        TermStatsQueue tiq = null;
        if (field != null) {
            Terms terms = MultiFields.getTerms(reader2, field);
            if (terms == null) {
                throw new RuntimeException("field " + field + " not found");
            }
            TermsEnum termsEnum = terms.iterator();
            tiq = new TermStatsQueue(numTerms, comparator2);
            tiq.fill(field, termsEnum);
        } else {
            Fields fields = MultiFields.getFields(reader2);
            if (fields.size() == 0) {
                throw new RuntimeException("no fields found for this index");
            }
            tiq = new TermStatsQueue(numTerms, comparator2);
            for (String fieldName : fields) {
                Terms terms = fields.terms(fieldName);
                if (terms == null) continue;
                tiq.fill(fieldName, terms.iterator());
            }
        }
        TermStats[] result = new TermStats[tiq.size()];
        int count2 = tiq.size() - 1;
        while (tiq.size() != 0) {
            result[count2] = (TermStats)tiq.pop();
            --count2;
        }
        return result;
    }

    static final class TermStatsQueue
    extends PriorityQueue<TermStats> {
        final Comparator<TermStats> comparator;

        TermStatsQueue(int size, Comparator<TermStats> comparator2) {
            super(size);
            this.comparator = comparator2;
        }

        @Override
        protected boolean lessThan(TermStats termInfoA, TermStats termInfoB) {
            return this.comparator.compare(termInfoA, termInfoB) < 0;
        }

        protected void fill(String field, TermsEnum termsEnum) throws IOException {
            BytesRef term = null;
            while ((term = termsEnum.next()) != null) {
                this.insertWithOverflow(new TermStats(field, term, termsEnum.docFreq(), termsEnum.totalTermFreq()));
            }
        }
    }

    public static final class TotalTermFreqComparator
    implements Comparator<TermStats> {
        @Override
        public int compare(TermStats a, TermStats b) {
            int res = Long.compare(a.totalTermFreq, b.totalTermFreq);
            if (res == 0 && (res = a.field.compareTo(b.field)) == 0) {
                res = a.termtext.compareTo(b.termtext);
            }
            return res;
        }
    }

    public static final class DocFreqComparator
    implements Comparator<TermStats> {
        @Override
        public int compare(TermStats a, TermStats b) {
            int res = Long.compare(a.docFreq, b.docFreq);
            if (res == 0 && (res = a.field.compareTo(b.field)) == 0) {
                res = a.termtext.compareTo(b.termtext);
            }
            return res;
        }
    }
}

