/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.compound.hyphenation;

public class ByteVector {
    private static final int DEFAULT_BLOCK_SIZE = 2048;
    private int blockSize;
    private byte[] array;
    private int n;

    public ByteVector() {
        this(2048);
    }

    public ByteVector(int capacity) {
        this.blockSize = capacity > 0 ? capacity : 2048;
        this.array = new byte[this.blockSize];
        this.n = 0;
    }

    public ByteVector(byte[] a) {
        this.blockSize = 2048;
        this.array = a;
        this.n = 0;
    }

    public ByteVector(byte[] a, int capacity) {
        this.blockSize = capacity > 0 ? capacity : 2048;
        this.array = a;
        this.n = 0;
    }

    public byte[] getArray() {
        return this.array;
    }

    public int length() {
        return this.n;
    }

    public int capacity() {
        return this.array.length;
    }

    public void put(int index2, byte val2) {
        this.array[index2] = val2;
    }

    public byte get(int index2) {
        return this.array[index2];
    }

    public int alloc(int size) {
        int index2 = this.n;
        int len = this.array.length;
        if (this.n + size >= len) {
            byte[] aux = new byte[len + this.blockSize];
            System.arraycopy(this.array, 0, aux, 0, len);
            this.array = aux;
        }
        this.n += size;
        return index2;
    }

    public void trimToSize() {
        if (this.n < this.array.length) {
            byte[] aux = new byte[this.n];
            System.arraycopy(this.array, 0, aux, 0, this.n);
            this.array = aux;
        }
    }
}

