/*
 * Decompiled with CFR 0.152.
 */
package com.opencsv;

import com.opencsv.CSVParser;
import com.opencsv.CSVReader;
import java.io.Reader;

public class CSVReaderBuilder {
    private final Reader reader;
    private int skipLines = 0;
    private CSVParser csvParser = null;

    CSVReaderBuilder(Reader reader2) {
        if (reader2 == null) {
            throw new IllegalArgumentException("Reader may not be null");
        }
        this.reader = reader2;
    }

    protected Reader getReader() {
        return this.reader;
    }

    protected int getSkipLines() {
        return this.skipLines;
    }

    protected CSVParser getCsvParser() {
        return this.csvParser;
    }

    CSVReaderBuilder withSkipLines(int skipLines) {
        this.skipLines = skipLines <= 0 ? 0 : skipLines;
        return this;
    }

    CSVReaderBuilder withCSVParser(CSVParser csvParser) {
        this.csvParser = csvParser;
        return this;
    }

    CSVReader build() {
        CSVParser parser = this.csvParser != null ? this.csvParser : new CSVParser();
        return new CSVReader(this.reader, this.skipLines, parser);
    }
}

