/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.spin;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.vocabulary.SPIN;

final class SpinWellKnownVars {
    private static final ValueFactory valueFactory = SimpleValueFactory.getInstance();
    static final SpinWellKnownVars INSTANCE = new SpinWellKnownVars();
    private final BiMap<String, IRI> stringToUri = HashBiMap.create();
    private final BiMap<IRI, String> uriToString = this.stringToUri.inverse();

    public SpinWellKnownVars() {
        this.stringToUri.put("this", SPIN.THIS_CONTEXT_INSTANCE);
        this.stringToUri.put("arg1", SPIN.ARG1_INSTANCE);
        this.stringToUri.put("arg2", SPIN.ARG2_INSTANCE);
        this.stringToUri.put("arg3", SPIN.ARG3_INSTANCE);
        this.stringToUri.put("arg4", SPIN.ARG4_INSTANCE);
        this.stringToUri.put("arg5", SPIN.ARG5_INSTANCE);
    }

    public IRI getURI(String name2) {
        IRI IRI2 = (IRI)this.stringToUri.get(name2);
        if (IRI2 == null && name2.startsWith("arg")) {
            try {
                Integer.parseInt(name2.substring("arg".length()));
                IRI2 = valueFactory.createIRI("http://spinrdf.org/spin#", "_" + name2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return IRI2;
    }

    public String getName(IRI IRI2) {
        String name2 = (String)this.uriToString.get(IRI2);
        if (name2 == null && "http://spinrdf.org/spin#".equals(IRI2.getNamespace()) && IRI2.getLocalName().startsWith("_arg")) {
            String lname = IRI2.getLocalName();
            try {
                Integer.parseInt(lname.substring("_arg".length()));
                name2 = lname.substring(1);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return name2;
    }
}

