/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.spin;

import com.google.common.base.Function;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.BooleanLiteral;
import org.eclipse.rdf4j.model.impl.ValueFactoryImpl;
import org.eclipse.rdf4j.model.vocabulary.AFN;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.SP;
import org.eclipse.rdf4j.model.vocabulary.XMLSchema;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.algebra.And;
import org.eclipse.rdf4j.query.algebra.Avg;
import org.eclipse.rdf4j.query.algebra.BNodeGenerator;
import org.eclipse.rdf4j.query.algebra.BindingSetAssignment;
import org.eclipse.rdf4j.query.algebra.Bound;
import org.eclipse.rdf4j.query.algebra.Clear;
import org.eclipse.rdf4j.query.algebra.Coalesce;
import org.eclipse.rdf4j.query.algebra.Compare;
import org.eclipse.rdf4j.query.algebra.Count;
import org.eclipse.rdf4j.query.algebra.Create;
import org.eclipse.rdf4j.query.algebra.Datatype;
import org.eclipse.rdf4j.query.algebra.DeleteData;
import org.eclipse.rdf4j.query.algebra.Difference;
import org.eclipse.rdf4j.query.algebra.Distinct;
import org.eclipse.rdf4j.query.algebra.Exists;
import org.eclipse.rdf4j.query.algebra.Extension;
import org.eclipse.rdf4j.query.algebra.ExtensionElem;
import org.eclipse.rdf4j.query.algebra.Filter;
import org.eclipse.rdf4j.query.algebra.FunctionCall;
import org.eclipse.rdf4j.query.algebra.Group;
import org.eclipse.rdf4j.query.algebra.GroupConcat;
import org.eclipse.rdf4j.query.algebra.IRIFunction;
import org.eclipse.rdf4j.query.algebra.If;
import org.eclipse.rdf4j.query.algebra.InsertData;
import org.eclipse.rdf4j.query.algebra.IsBNode;
import org.eclipse.rdf4j.query.algebra.IsLiteral;
import org.eclipse.rdf4j.query.algebra.IsNumeric;
import org.eclipse.rdf4j.query.algebra.IsURI;
import org.eclipse.rdf4j.query.algebra.Join;
import org.eclipse.rdf4j.query.algebra.Lang;
import org.eclipse.rdf4j.query.algebra.LeftJoin;
import org.eclipse.rdf4j.query.algebra.Load;
import org.eclipse.rdf4j.query.algebra.LocalName;
import org.eclipse.rdf4j.query.algebra.MathExpr;
import org.eclipse.rdf4j.query.algebra.Max;
import org.eclipse.rdf4j.query.algebra.Min;
import org.eclipse.rdf4j.query.algebra.Modify;
import org.eclipse.rdf4j.query.algebra.MultiProjection;
import org.eclipse.rdf4j.query.algebra.Not;
import org.eclipse.rdf4j.query.algebra.Or;
import org.eclipse.rdf4j.query.algebra.Order;
import org.eclipse.rdf4j.query.algebra.OrderElem;
import org.eclipse.rdf4j.query.algebra.Projection;
import org.eclipse.rdf4j.query.algebra.ProjectionElem;
import org.eclipse.rdf4j.query.algebra.ProjectionElemList;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.Reduced;
import org.eclipse.rdf4j.query.algebra.Regex;
import org.eclipse.rdf4j.query.algebra.Sample;
import org.eclipse.rdf4j.query.algebra.Service;
import org.eclipse.rdf4j.query.algebra.Slice;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.Str;
import org.eclipse.rdf4j.query.algebra.Sum;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.Union;
import org.eclipse.rdf4j.query.algebra.UpdateExpr;
import org.eclipse.rdf4j.query.algebra.ValueConstant;
import org.eclipse.rdf4j.query.algebra.ValueExpr;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.algebra.helpers.QueryModelVisitorBase;
import org.eclipse.rdf4j.query.parser.ParsedBooleanQuery;
import org.eclipse.rdf4j.query.parser.ParsedDescribeQuery;
import org.eclipse.rdf4j.query.parser.ParsedGraphQuery;
import org.eclipse.rdf4j.query.parser.ParsedOperation;
import org.eclipse.rdf4j.query.parser.ParsedQuery;
import org.eclipse.rdf4j.query.parser.ParsedTupleQuery;
import org.eclipse.rdf4j.query.parser.ParsedUpdate;
import org.eclipse.rdf4j.repository.sail.helpers.SPARQLUpdateDataBlockParser;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.helpers.RDFHandlerBase;
import org.eclipse.rdf4j.spin.SpinWellKnownFunctions;
import org.eclipse.rdf4j.spin.SpinWellKnownVars;

public class SpinRenderer {
    private final ValueFactory valueFactory;
    private final Output output;
    private final Function<String, IRI> wellKnownVars;
    private final Function<String, IRI> wellKnownFunctions;

    public SpinRenderer() {
        this(Output.TEXT_AND_RDF);
    }

    public SpinRenderer(Output output) {
        this(output, new Function<String, IRI>(){

            @Override
            public IRI apply(String name2) {
                return SpinWellKnownVars.INSTANCE.getURI(name2);
            }
        }, new Function<String, IRI>(){

            @Override
            public IRI apply(String name2) {
                return SpinWellKnownFunctions.INSTANCE.getURI(name2);
            }
        }, ValueFactoryImpl.getInstance());
    }

    public SpinRenderer(Output output, Function<String, IRI> wellKnownVarMapper, Function<String, IRI> wellKnownFuncMapper, ValueFactory vf) {
        this.output = output;
        this.wellKnownVars = wellKnownVarMapper;
        this.wellKnownFunctions = wellKnownFuncMapper;
        this.valueFactory = vf;
    }

    public void render(ParsedOperation operation, RDFHandler handler) throws RDFHandlerException {
        if (operation instanceof ParsedQuery) {
            this.render((ParsedQuery)operation, handler);
        } else if (operation instanceof ParsedUpdate) {
            this.render((ParsedUpdate)operation, handler);
        } else {
            throw new AssertionError((Object)("Unrecognised ParsedOperation: " + operation.getClass()));
        }
    }

    public void render(ParsedQuery query, RDFHandler handler) throws RDFHandlerException {
        if (query instanceof ParsedBooleanQuery) {
            this.render((ParsedBooleanQuery)query, handler);
        } else if (query instanceof ParsedTupleQuery) {
            this.render((ParsedTupleQuery)query, handler);
        } else if (query instanceof ParsedDescribeQuery) {
            this.render((ParsedDescribeQuery)query, handler);
        } else if (query instanceof ParsedGraphQuery) {
            this.render((ParsedGraphQuery)query, handler);
        } else {
            throw new AssertionError((Object)("Unrecognised ParsedQuery: " + query.getClass()));
        }
    }

    public void render(ParsedBooleanQuery query, RDFHandler handler) throws RDFHandlerException {
        handler.startRDF();
        BNode querySubj = this.valueFactory.createBNode();
        handler.handleStatement(this.valueFactory.createStatement((Resource)querySubj, RDF.TYPE, (Value)SP.ASK_CLASS));
        if (this.output.text) {
            handler.handleStatement(this.valueFactory.createStatement((Resource)querySubj, SP.TEXT_PROPERTY, (Value)this.valueFactory.createLiteral(query.getSourceString())));
        }
        if (this.output.rdf) {
            BNode whereBNode = this.valueFactory.createBNode();
            handler.handleStatement(this.valueFactory.createStatement((Resource)querySubj, SP.WHERE_PROPERTY, (Value)whereBNode));
            TupleExpr expr = query.getTupleExpr();
            AskVisitor visitor = new AskVisitor(handler, whereBNode, query.getDataset());
            expr.visit(visitor);
            visitor.end();
        }
        handler.endRDF();
    }

    public void render(ParsedTupleQuery query, RDFHandler handler) throws RDFHandlerException {
        handler.startRDF();
        BNode querySubj = this.valueFactory.createBNode();
        handler.handleStatement(this.valueFactory.createStatement((Resource)querySubj, RDF.TYPE, (Value)SP.SELECT_CLASS));
        if (this.output.text) {
            handler.handleStatement(this.valueFactory.createStatement((Resource)querySubj, SP.TEXT_PROPERTY, (Value)this.valueFactory.createLiteral(query.getSourceString())));
        }
        if (this.output.rdf) {
            TupleExpr expr = query.getTupleExpr();
            SpinVisitor visitor = new SpinVisitor(handler, null, querySubj, query.getDataset());
            expr.visit(visitor);
            visitor.end();
        }
        handler.endRDF();
    }

    public void render(ParsedDescribeQuery query, RDFHandler handler) throws RDFHandlerException {
        handler.startRDF();
        BNode querySubj = this.valueFactory.createBNode();
        handler.handleStatement(this.valueFactory.createStatement((Resource)querySubj, RDF.TYPE, (Value)SP.DESCRIBE_CLASS));
        if (this.output.text) {
            handler.handleStatement(this.valueFactory.createStatement((Resource)querySubj, SP.TEXT_PROPERTY, (Value)this.valueFactory.createLiteral(query.getSourceString())));
        }
        if (this.output.rdf) {
            TupleExpr expr = query.getTupleExpr();
            DescribeVisitor visitor = new DescribeVisitor(handler, querySubj, query.getDataset());
            expr.visit(visitor);
            visitor.end();
        }
        handler.endRDF();
    }

    public void render(ParsedGraphQuery query, RDFHandler handler) throws RDFHandlerException {
        handler.startRDF();
        BNode querySubj = this.valueFactory.createBNode();
        handler.handleStatement(this.valueFactory.createStatement((Resource)querySubj, RDF.TYPE, (Value)SP.CONSTRUCT_CLASS));
        if (this.output.text) {
            handler.handleStatement(this.valueFactory.createStatement((Resource)querySubj, SP.TEXT_PROPERTY, (Value)this.valueFactory.createLiteral(query.getSourceString())));
        }
        if (this.output.rdf) {
            TupleExpr expr = query.getTupleExpr();
            ConstructVisitor visitor = new ConstructVisitor(handler, querySubj, query.getDataset());
            expr.visit(visitor);
            visitor.end();
        }
        handler.endRDF();
    }

    public void render(ParsedUpdate update2, RDFHandler handler) throws RDFHandlerException {
        handler.startRDF();
        for (Map.Entry<String, String> entry : update2.getNamespaces().entrySet()) {
            handler.handleNamespace(entry.getKey(), entry.getValue());
        }
        String[] sourceStrings = update2.getSourceString().split("\\s*;\\s*");
        List<UpdateExpr> updateExprs = update2.getUpdateExprs();
        Map<UpdateExpr, Dataset> datasets = update2.getDatasetMapping();
        for (int i = 0; i < updateExprs.size(); ++i) {
            IRI updateClass;
            UpdateExpr updateExpr = updateExprs.get(i);
            BNode updateSubj = this.valueFactory.createBNode();
            Dataset dataset = datasets.get(updateExpr);
            if (updateExpr instanceof Modify) {
                Modify modify = (Modify)updateExpr;
                updateClass = modify.getInsertExpr() == null && modify.getWhereExpr().equals(modify.getDeleteExpr()) ? SP.DELETE_WHERE_CLASS : SP.MODIFY_CLASS;
            } else if (updateExpr instanceof InsertData) {
                updateClass = SP.INSERT_DATA_CLASS;
            } else if (updateExpr instanceof DeleteData) {
                updateClass = SP.DELETE_DATA_CLASS;
            } else if (updateExpr instanceof Load) {
                updateClass = SP.LOAD_CLASS;
            } else if (updateExpr instanceof Clear) {
                updateClass = SP.CLEAR_CLASS;
            } else if (updateExpr instanceof Create) {
                updateClass = SP.CREATE_CLASS;
            } else {
                throw new RDFHandlerException("Unrecognised UpdateExpr: " + updateExpr.getClass());
            }
            handler.handleStatement(this.valueFactory.createStatement((Resource)updateSubj, RDF.TYPE, (Value)updateClass));
            if (this.output.text) {
                handler.handleStatement(this.valueFactory.createStatement((Resource)updateSubj, SP.TEXT_PROPERTY, (Value)this.valueFactory.createLiteral(sourceStrings[i])));
            }
            if (!this.output.rdf) continue;
            SpinVisitor visitor = new SpinVisitor(handler, null, updateSubj, dataset);
            updateExpr.visit(visitor);
            visitor.end();
        }
        handler.endRDF();
    }

    private static final class ListContext {
        Resource list;
        Resource subject;

        ListContext(Resource list, Resource subject) {
            this.list = list;
            this.subject = subject;
        }
    }

    private static final class ExtensionContext
    extends QueryModelVisitorBase<RuntimeException> {
        Extension extension;
        Map<String, ValueExpr> extensionExprs;

        private ExtensionContext() {
        }

        public ValueExpr getValueExpr(String name2) {
            return this.extensionExprs.get(name2);
        }

        @Override
        public void meet(Order node2) {
            node2.getArg().visit(this);
        }

        @Override
        public void meet(Extension node2) {
            this.extension = node2;
            List<ExtensionElem> elements = node2.getElements();
            this.extensionExprs = new LinkedHashMap<String, ValueExpr>(elements.size());
            for (ExtensionElem elem : elements) {
                this.extensionExprs.put(elem.getName(), elem.getExpr());
            }
        }

        @Override
        protected void meetNode(QueryModelNode node2) {
        }
    }

    private class SpinVisitor
    extends QueryModelVisitorBase<RDFHandlerException> {
        final RDFHandler handler;
        final Dataset dataset;
        final Map<String, BNode> varBNodes = new HashMap<String, BNode>();
        final Map<String, ListContext> namedGraphLists = new HashMap<String, ListContext>();
        ExtensionContext inlineBindings;
        Resource list;
        Resource subject;
        IRI predicate;
        ListContext namedGraphContext;
        boolean isMultiProjection;
        boolean isSubQuery;
        boolean hasGroup;

        SpinVisitor(RDFHandler handler, Resource list, Resource subject, Dataset dataset) {
            this.handler = handler;
            this.list = list;
            this.subject = subject;
            this.dataset = dataset;
        }

        private ExtensionContext meetExtension(TupleExpr expr) {
            ExtensionContext extVisitor = new ExtensionContext();
            expr.visit(extVisitor);
            ExtensionContext oldInlineBindings = this.inlineBindings;
            this.inlineBindings = extVisitor.extension != null ? extVisitor : null;
            return oldInlineBindings;
        }

        ListContext save() {
            return new ListContext(this.list, this.subject);
        }

        void update(ListContext ctx) {
            ctx.list = this.list;
            ctx.subject = this.subject;
        }

        void restore(ListContext ctx) {
            this.list = ctx.list;
            this.subject = ctx.subject;
        }

        ListContext newList(Resource res) {
            ListContext ctx = this.save();
            this.list = res;
            this.subject = null;
            return ctx;
        }

        void listEntry() throws RDFHandlerException {
            this.listEntry(null);
        }

        void listEntry(Value entry) throws RDFHandlerException {
            if (this.list == null) {
                this.list = SpinRenderer.this.valueFactory.createBNode();
            }
            if (this.subject != null) {
                this.nextListEntry(SpinRenderer.this.valueFactory.createBNode());
            }
            if (entry == null) {
                entry = SpinRenderer.this.valueFactory.createBNode();
            }
            this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.list, RDF.FIRST, entry));
            this.subject = entry instanceof Resource ? (Resource)entry : RDF.NIL;
        }

        void endList(ListContext ctx) throws RDFHandlerException {
            this.nextListEntry(RDF.NIL);
            if (ctx != null) {
                this.restore(ctx);
            }
        }

        private void nextListEntry(Resource nextEntry) throws RDFHandlerException {
            this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.list, RDF.REST, (Value)nextEntry));
            this.list = nextEntry;
            this.subject = null;
        }

        Resource getVar(String name2) throws RDFHandlerException {
            Resource res;
            Resource resource2 = res = SpinRenderer.this.wellKnownVars != null ? (Resource)SpinRenderer.this.wellKnownVars.apply(name2) : null;
            if (res == null && (res = (Resource)this.varBNodes.get(name2)) == null) {
                BNode bnode = SpinRenderer.this.valueFactory.createBNode(name2);
                this.varBNodes.put(name2, bnode);
                res = bnode;
            }
            return res;
        }

        ListContext getNamedGraph(Var context) throws RDFHandlerException {
            ListContext currentCtx;
            this.namedGraphContext = this.namedGraphLists.get(context.getName());
            if (this.namedGraphContext == null) {
                this.listEntry();
                this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, RDF.TYPE, (Value)SP.NAMED_GRAPH_CLASS));
                this.predicate = SP.GRAPH_NAME_NODE_PROPERTY;
                context.visit(this);
                BNode elementsList = SpinRenderer.this.valueFactory.createBNode();
                this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, SP.ELEMENTS_PROPERTY, (Value)elementsList));
                currentCtx = this.newList(elementsList);
                this.namedGraphContext = this.save();
                this.namedGraphLists.put(context.getName(), this.namedGraphContext);
            } else {
                currentCtx = this.save();
                this.restore(this.namedGraphContext);
            }
            return currentCtx;
        }

        void restoreNamedGraph(ListContext ctx) {
            this.update(this.namedGraphContext);
            this.restore(ctx);
        }

        public void end() throws RDFHandlerException {
            if (this.list != null) {
                this.endList(null);
            }
            for (ListContext listContext : this.namedGraphLists.values()) {
                this.restore(listContext);
                this.endList(null);
            }
            for (Map.Entry entry : this.varBNodes.entrySet()) {
                this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement((Resource)entry.getValue(), SP.VAR_NAME_PROPERTY, (Value)SpinRenderer.this.valueFactory.createLiteral((String)entry.getKey())));
            }
        }

        @Override
        public void meet(MultiProjection node2) throws RDFHandlerException {
            ExtensionContext oldInlineBindings = this.meetExtension(node2.getArg());
            ListContext ctx = this.startTemplateList();
            this.isMultiProjection = true;
            for (ProjectionElemList proj : node2.getProjections()) {
                proj.visit(this);
            }
            this.endTemplateList(ctx);
            this.isMultiProjection = false;
            this.visitWhere(node2.getArg());
            this.inlineBindings = oldInlineBindings;
        }

        ListContext startTemplateList() throws RDFHandlerException {
            BNode elemListBNode = SpinRenderer.this.valueFactory.createBNode();
            this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, SP.TEMPLATES_PROPERTY, (Value)elemListBNode));
            return this.newList(elemListBNode);
        }

        void endTemplateList(ListContext ctx) throws RDFHandlerException {
            this.endList(ctx);
        }

        @Override
        public void meet(Projection node2) throws RDFHandlerException {
            ExtensionContext oldInlineBindings = this.meetExtension(node2.getArg());
            if (this.isSubQuery) {
                this.listEntry();
                this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, RDF.TYPE, (Value)SP.SUB_QUERY_CLASS));
                BNode queryBNode = SpinRenderer.this.valueFactory.createBNode();
                this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, SP.QUERY_PROPERTY, (Value)queryBNode));
                this.subject = queryBNode;
                this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, RDF.TYPE, (Value)SP.SELECT_CLASS));
            }
            node2.getProjectionElemList().visit(this);
            this.visitWhere(node2.getArg());
            node2.getArg().visit(new GroupVisitor());
            node2.getArg().visit(new OrderVisitor());
            this.inlineBindings = oldInlineBindings;
            this.hasGroup = false;
        }

        private void visitWhere(TupleExpr where) throws RDFHandlerException {
            BNode whereBNode = SpinRenderer.this.valueFactory.createBNode();
            this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, SP.WHERE_PROPERTY, (Value)whereBNode));
            this.isSubQuery = true;
            ListContext ctx = this.newList(whereBNode);
            where.visit(this);
            this.endList(ctx);
        }

        @Override
        public void meet(ProjectionElemList node2) throws RDFHandlerException {
            BNode elemListBNode = SpinRenderer.this.valueFactory.createBNode();
            this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, SP.RESULT_VARIABLES_PROPERTY, (Value)elemListBNode));
            ListContext ctx = this.newList(elemListBNode);
            super.meet(node2);
            this.endList(ctx);
        }

        @Override
        public void meet(ProjectionElem node2) throws RDFHandlerException {
            ValueExpr valueExpr = null;
            if (this.inlineBindings != null) {
                String varName = node2.getSourceName();
                valueExpr = this.inlineBindings.getValueExpr(varName);
            }
            Resource targetVar = this.getVar(node2.getTargetName());
            this.listEntry(targetVar);
            if (valueExpr != null && !(valueExpr instanceof Var)) {
                Resource currentSubj = this.subject;
                this.subject = SpinRenderer.this.valueFactory.createBNode();
                this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(targetVar, SP.EXPRESSION_PROPERTY, (Value)this.subject));
                valueExpr.visit(new ExtensionVisitor());
                this.subject = currentSubj;
            }
        }

        @Override
        public void meet(Extension node2) throws RDFHandlerException {
            if (this.inlineBindings != null && this.inlineBindings.extension == node2) {
                node2.getArg().visit(this);
            } else {
                node2.getArg().visit(this);
                for (ExtensionElem elem : node2.getElements()) {
                    elem.visit(this);
                }
            }
        }

        @Override
        public void meet(ExtensionElem node2) throws RDFHandlerException {
            this.listEntry();
            this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, RDF.TYPE, (Value)SP.BIND_CLASS));
            Resource var = this.getVar(node2.getName());
            this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, SP.VARIABLE_PROPERTY, (Value)var));
            this.meet(node2.getExpr());
        }

        private void meet(ValueExpr node2) throws RDFHandlerException {
            this.predicate = SP.EXPRESSION_PROPERTY;
            ListContext ctx = this.save();
            this.list = null;
            node2.visit(this);
            this.restore(ctx);
        }

        private void flushPendingStatement() throws RDFHandlerException {
            if (this.predicate != null) {
                BNode res = SpinRenderer.this.valueFactory.createBNode();
                this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, this.predicate, (Value)res));
                this.subject = res;
            }
        }

        @Override
        public void meet(StatementPattern node2) throws RDFHandlerException {
            ListContext ctxList = null;
            if (StatementPattern.Scope.NAMED_CONTEXTS == node2.getScope()) {
                ctxList = this.getNamedGraph(node2.getContextVar());
            }
            this.listEntry();
            this.predicate = SP.SUBJECT_PROPERTY;
            node2.getSubjectVar().visit(this);
            this.predicate = SP.PREDICATE_PROPERTY;
            node2.getPredicateVar().visit(this);
            this.predicate = SP.OBJECT_PROPERTY;
            node2.getObjectVar().visit(this);
            this.predicate = null;
            if (ctxList != null) {
                this.restoreNamedGraph(ctxList);
            }
        }

        @Override
        public void meet(Var node2) throws RDFHandlerException {
            Value value = node2.isConstant() ? node2.getValue() : this.getVar(node2.getName());
            this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, this.predicate, value));
        }

        @Override
        public void meet(ValueConstant node2) throws RDFHandlerException {
            this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, this.predicate, node2.getValue()));
        }

        @Override
        public void meet(Filter node2) throws RDFHandlerException {
            this.hasGroup = false;
            node2.getArg().visit(this);
            if (!this.hasGroup) {
                this.listEntry();
                this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, RDF.TYPE, (Value)SP.FILTER_CLASS));
                this.meet(node2.getCondition());
            }
        }

        @Override
        public void meet(Compare node2) throws RDFHandlerException {
            Resource currentSubj = this.subject;
            this.flushPendingStatement();
            this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, RDF.TYPE, this.toValue(node2.getOperator())));
            this.predicate = SP.ARG1_PROPERTY;
            node2.getLeftArg().visit(this);
            this.predicate = SP.ARG2_PROPERTY;
            node2.getRightArg().visit(this);
            this.subject = currentSubj;
            this.predicate = null;
        }

        private Value toValue(Compare.CompareOp op) {
            switch (op) {
                case EQ: {
                    return SP.EQ;
                }
                case NE: {
                    return SP.NE;
                }
                case LT: {
                    return SP.LT;
                }
                case LE: {
                    return SP.LE;
                }
                case GE: {
                    return SP.GE;
                }
                case GT: {
                    return SP.GT;
                }
            }
            throw new AssertionError((Object)("Unrecognised CompareOp: " + (Object)((Object)op)));
        }

        @Override
        public void meet(MathExpr node2) throws RDFHandlerException {
            Resource currentSubj = this.subject;
            this.flushPendingStatement();
            this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, RDF.TYPE, this.toValue(node2.getOperator())));
            this.predicate = SP.ARG1_PROPERTY;
            node2.getLeftArg().visit(this);
            this.predicate = SP.ARG2_PROPERTY;
            node2.getRightArg().visit(this);
            this.subject = currentSubj;
            this.predicate = null;
        }

        @Override
        public void meet(And node2) throws RDFHandlerException {
            Resource currentSubj = this.subject;
            this.flushPendingStatement();
            this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, RDF.TYPE, (Value)SP.AND));
            this.predicate = SP.ARG1_PROPERTY;
            node2.getLeftArg().visit(this);
            this.predicate = SP.ARG2_PROPERTY;
            node2.getRightArg().visit(this);
            this.subject = currentSubj;
            this.predicate = null;
        }

        @Override
        public void meet(Or node2) throws RDFHandlerException {
            Resource currentSubj = this.subject;
            this.flushPendingStatement();
            this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, RDF.TYPE, (Value)SP.OR));
            this.predicate = SP.ARG1_PROPERTY;
            node2.getLeftArg().visit(this);
            this.predicate = SP.ARG2_PROPERTY;
            node2.getRightArg().visit(this);
            this.subject = currentSubj;
            this.predicate = null;
        }

        @Override
        public void meet(Bound node2) throws RDFHandlerException {
            Resource currentSubj = this.subject;
            this.flushPendingStatement();
            this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, RDF.TYPE, (Value)SP.BOUND));
            this.predicate = SP.ARG1_PROPERTY;
            node2.getArg().visit(this);
            this.subject = currentSubj;
            this.predicate = null;
        }

        @Override
        public void meet(If node2) throws RDFHandlerException {
            Resource currentSubj = this.subject;
            this.flushPendingStatement();
            this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, RDF.TYPE, (Value)SP.IF));
            this.predicate = SP.ARG1_PROPERTY;
            node2.getCondition().visit(this);
            this.predicate = SP.ARG2_PROPERTY;
            node2.getResult().visit(this);
            this.predicate = SP.ARG3_PROPERTY;
            node2.getAlternative().visit(this);
            this.subject = currentSubj;
            this.predicate = null;
        }

        @Override
        public void meet(Coalesce node2) throws RDFHandlerException {
            Resource currentSubj = this.subject;
            this.flushPendingStatement();
            this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, RDF.TYPE, (Value)SP.COALESCE));
            List<ValueExpr> args = node2.getArguments();
            for (int i = 0; i < args.size(); ++i) {
                this.predicate = this.toArgProperty(i + 1);
                args.get(i).visit(this);
            }
            this.subject = currentSubj;
            this.predicate = null;
        }

        @Override
        public void meet(IsURI node2) throws RDFHandlerException {
            Resource currentSubj = this.subject;
            this.flushPendingStatement();
            this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, RDF.TYPE, (Value)SP.IS_IRI));
            this.predicate = SP.ARG1_PROPERTY;
            node2.getArg().visit(this);
            this.subject = currentSubj;
            this.predicate = null;
        }

        @Override
        public void meet(IsBNode node2) throws RDFHandlerException {
            Resource currentSubj = this.subject;
            this.flushPendingStatement();
            this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, RDF.TYPE, (Value)SP.IS_BLANK));
            this.predicate = SP.ARG1_PROPERTY;
            node2.getArg().visit(this);
            this.subject = currentSubj;
            this.predicate = null;
        }

        @Override
        public void meet(IsLiteral node2) throws RDFHandlerException {
            Resource currentSubj = this.subject;
            this.flushPendingStatement();
            this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, RDF.TYPE, (Value)SP.IS_LITERAL));
            this.predicate = SP.ARG1_PROPERTY;
            node2.getArg().visit(this);
            this.subject = currentSubj;
            this.predicate = null;
        }

        @Override
        public void meet(IsNumeric node2) throws RDFHandlerException {
            Resource currentSubj = this.subject;
            this.flushPendingStatement();
            this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, RDF.TYPE, (Value)SP.IS_NUMERIC));
            this.predicate = SP.ARG1_PROPERTY;
            node2.getArg().visit(this);
            this.subject = currentSubj;
            this.predicate = null;
        }

        @Override
        public void meet(Str node2) throws RDFHandlerException {
            Resource currentSubj = this.subject;
            this.flushPendingStatement();
            this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, RDF.TYPE, (Value)SP.STR));
            this.predicate = SP.ARG1_PROPERTY;
            node2.getArg().visit(this);
            this.subject = currentSubj;
            this.predicate = null;
        }

        @Override
        public void meet(Lang node2) throws RDFHandlerException {
            Resource currentSubj = this.subject;
            this.flushPendingStatement();
            this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, RDF.TYPE, (Value)SP.LANG));
            this.predicate = SP.ARG1_PROPERTY;
            node2.getArg().visit(this);
            this.subject = currentSubj;
            this.predicate = null;
        }

        @Override
        public void meet(Datatype node2) throws RDFHandlerException {
            Resource currentSubj = this.subject;
            this.flushPendingStatement();
            this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, RDF.TYPE, (Value)SP.DATATYPE));
            this.predicate = SP.ARG1_PROPERTY;
            node2.getArg().visit(this);
            this.subject = currentSubj;
            this.predicate = null;
        }

        @Override
        public void meet(IRIFunction node2) throws RDFHandlerException {
            Resource currentSubj = this.subject;
            this.flushPendingStatement();
            this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, RDF.TYPE, (Value)SP.IRI));
            this.predicate = SP.ARG1_PROPERTY;
            node2.getArg().visit(this);
            this.subject = currentSubj;
            this.predicate = null;
        }

        @Override
        public void meet(BNodeGenerator node2) throws RDFHandlerException {
            Resource currentSubj = this.subject;
            this.flushPendingStatement();
            this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, RDF.TYPE, (Value)SP.BNODE));
            if (node2.getNodeIdExpr() != null) {
                this.predicate = SP.ARG1_PROPERTY;
                node2.getNodeIdExpr().visit(this);
            }
            this.subject = currentSubj;
            this.predicate = null;
        }

        @Override
        public void meet(Regex node2) throws RDFHandlerException {
            Resource currentSubj = this.subject;
            this.flushPendingStatement();
            this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, RDF.TYPE, (Value)SP.REGEX));
            this.predicate = SP.ARG1_PROPERTY;
            node2.getLeftArg().visit(this);
            this.predicate = SP.ARG2_PROPERTY;
            node2.getRightArg().visit(this);
            this.subject = currentSubj;
            this.predicate = null;
        }

        @Override
        public void meet(LocalName node2) throws RDFHandlerException {
            Resource currentSubj = this.subject;
            this.flushPendingStatement();
            this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, RDF.TYPE, (Value)AFN.LOCALNAME));
            this.predicate = SP.ARG1_PROPERTY;
            node2.getArg().visit(this);
            this.subject = currentSubj;
            this.predicate = null;
        }

        private Value toValue(MathExpr.MathOp op) {
            switch (op) {
                case PLUS: {
                    return SP.ADD;
                }
                case MINUS: {
                    return SP.SUB;
                }
                case MULTIPLY: {
                    return SP.MUL;
                }
                case DIVIDE: {
                    return SP.DIVIDE;
                }
            }
            throw new AssertionError((Object)("Unrecognised MathOp: " + (Object)((Object)op)));
        }

        @Override
        public void meet(FunctionCall node2) throws RDFHandlerException {
            Resource currentSubj = this.subject;
            this.flushPendingStatement();
            this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, RDF.TYPE, this.toValue(node2)));
            List<ValueExpr> args = node2.getArgs();
            for (int i = 0; i < args.size(); ++i) {
                this.predicate = this.toArgProperty(i + 1);
                args.get(i).visit(this);
            }
            this.subject = currentSubj;
            this.predicate = null;
        }

        private Value toValue(FunctionCall node2) {
            String funcName = node2.getURI();
            IRI funcUri = (IRI)SpinRenderer.this.wellKnownFunctions.apply(funcName);
            if (funcUri == null) {
                funcUri = SpinRenderer.this.valueFactory.createIRI(funcName);
            }
            return funcUri;
        }

        private IRI toArgProperty(int i) {
            switch (i) {
                case 1: {
                    return SP.ARG1_PROPERTY;
                }
                case 2: {
                    return SP.ARG2_PROPERTY;
                }
                case 3: {
                    return SP.ARG3_PROPERTY;
                }
                case 4: {
                    return SP.ARG4_PROPERTY;
                }
                case 5: {
                    return SP.ARG5_PROPERTY;
                }
            }
            return SpinRenderer.this.valueFactory.createIRI("http://spinrdf.org/sp#", "arg" + i);
        }

        @Override
        public void meet(Not node2) throws RDFHandlerException {
            if (node2.getArg() instanceof Exists) {
                super.meet(node2);
            } else {
                Resource currentSubj = this.subject;
                this.flushPendingStatement();
                this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, RDF.TYPE, (Value)SP.NOT));
                this.predicate = SP.ARG1_PROPERTY;
                node2.getArg().visit(this);
                this.subject = currentSubj;
                this.predicate = null;
            }
        }

        @Override
        public void meet(Exists node2) throws RDFHandlerException {
            Resource currentSubj = this.subject;
            this.flushPendingStatement();
            IRI op = node2.getParentNode() instanceof Not ? SP.NOT_EXISTS : SP.EXISTS;
            this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, RDF.TYPE, (Value)op));
            BNode elementsList = SpinRenderer.this.valueFactory.createBNode();
            this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, SP.ELEMENTS_PROPERTY, (Value)elementsList));
            ListContext elementsCtx = this.newList(elementsList);
            node2.getSubQuery().visit(this);
            this.endList(elementsCtx);
            this.subject = currentSubj;
            this.predicate = null;
        }

        @Override
        public void meet(Group node2) throws RDFHandlerException {
            node2.getArg().visit(this);
            this.hasGroup = true;
        }

        @Override
        public void meet(Order node2) throws RDFHandlerException {
            node2.getArg().visit(this);
        }

        @Override
        public void meet(Slice node2) throws RDFHandlerException {
            node2.getArg().visit(this);
            if (node2.hasLimit()) {
                this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, SP.LIMIT_PROPERTY, (Value)SpinRenderer.this.valueFactory.createLiteral(Long.toString(node2.getLimit()), XMLSchema.INTEGER)));
            }
            if (node2.hasOffset()) {
                this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, SP.OFFSET_PROPERTY, (Value)SpinRenderer.this.valueFactory.createLiteral(Long.toString(node2.getOffset()), XMLSchema.INTEGER)));
            }
        }

        @Override
        public void meet(Distinct node2) throws RDFHandlerException {
            node2.getArg().visit(this);
            this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, SP.DISTINCT_PROPERTY, (Value)BooleanLiteral.TRUE));
        }

        @Override
        public void meet(Reduced node2) throws RDFHandlerException {
            node2.getArg().visit(this);
            this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, SP.REDUCED_PROPERTY, (Value)BooleanLiteral.TRUE));
        }

        @Override
        public void meet(Join node2) throws RDFHandlerException {
            boolean isGroupGraphPattern = node2.getRightArg() instanceof Join;
            if (!isGroupGraphPattern) {
                super.meet(node2);
            } else {
                this.listEntry();
                ListContext leftGroupCtx = this.newList(this.subject);
                node2.getLeftArg().visit(this);
                this.endList(leftGroupCtx);
                this.listEntry();
                ListContext rightGroupCtx = this.newList(this.subject);
                node2.getRightArg().visit(this);
                this.endList(rightGroupCtx);
            }
        }

        @Override
        public void meet(LeftJoin node2) throws RDFHandlerException {
            node2.getLeftArg().visit(this);
            this.listEntry();
            this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, RDF.TYPE, (Value)SP.OPTIONAL_CLASS));
            BNode elementsList = SpinRenderer.this.valueFactory.createBNode();
            this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, SP.ELEMENTS_PROPERTY, (Value)elementsList));
            ListContext elementsCtx = this.newList(elementsList);
            node2.getRightArg().visit(this);
            this.endList(elementsCtx);
        }

        @Override
        public void meet(Union node2) throws RDFHandlerException {
            this.listEntry();
            this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, RDF.TYPE, (Value)SP.UNION_CLASS));
            BNode elementsList = SpinRenderer.this.valueFactory.createBNode();
            this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, SP.ELEMENTS_PROPERTY, (Value)elementsList));
            ListContext elementsCtx = this.newList(elementsList);
            this.listEntry();
            ListContext leftCtx = this.newList(this.subject);
            node2.getLeftArg().visit(this);
            this.endList(leftCtx);
            this.listEntry();
            ListContext rightCtx = this.newList(this.subject);
            node2.getRightArg().visit(this);
            this.endList(rightCtx);
            this.endList(elementsCtx);
        }

        @Override
        public void meet(Difference node2) throws RDFHandlerException {
            node2.getLeftArg().visit(this);
            this.listEntry();
            this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, RDF.TYPE, (Value)SP.MINUS_CLASS));
            BNode elementsList = SpinRenderer.this.valueFactory.createBNode();
            this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, SP.ELEMENTS_PROPERTY, (Value)elementsList));
            ListContext elementsCtx = this.newList(elementsList);
            node2.getRightArg().visit(this);
            this.endList(elementsCtx);
        }

        @Override
        public void meet(Service node2) throws RDFHandlerException {
            this.listEntry();
            this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, RDF.TYPE, (Value)SP.SERVICE_CLASS));
            this.predicate = SP.SERVICE_URI_PROPERTY;
            node2.getServiceRef().visit(this);
            this.predicate = null;
            BNode elementsList = SpinRenderer.this.valueFactory.createBNode();
            this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, SP.ELEMENTS_PROPERTY, (Value)elementsList));
            ListContext elementsCtx = this.newList(elementsList);
            node2.getArg().visit(this);
            this.endList(elementsCtx);
        }

        @Override
        public void meet(BindingSetAssignment node2) throws RDFHandlerException {
            this.listEntry();
            this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, RDF.TYPE, (Value)SP.VALUES_CLASS));
            BNode bindingList = SpinRenderer.this.valueFactory.createBNode();
            this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, SP.BINDINGS_PROPERTY, (Value)bindingList));
            ListContext bindingCtx = this.newList(bindingList);
            ArrayList<String> bindingVars = new ArrayList<String>(node2.getBindingNames());
            for (BindingSet bs : node2.getBindingSets()) {
                this.listEntry();
                ListContext setCtx = this.newList(this.subject);
                for (String varName : bindingVars) {
                    Value v = bs.getValue(varName);
                    if (v == null) {
                        v = SP.UNDEF;
                    }
                    this.listEntry(v);
                }
                this.endList(setCtx);
            }
            this.endList(bindingCtx);
            BNode varNameList = SpinRenderer.this.valueFactory.createBNode();
            this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, SP.VAR_NAMES_PROPERTY, (Value)varNameList));
            ListContext varnameCtx = this.newList(varNameList);
            for (String varName : bindingVars) {
                this.listEntry(SpinRenderer.this.valueFactory.createLiteral(varName));
            }
            this.endList(varnameCtx);
        }

        @Override
        public void meet(Modify node2) throws RDFHandlerException {
            TupleExpr insertExpr = node2.getInsertExpr();
            TupleExpr deleteExpr = node2.getDeleteExpr();
            TupleExpr whereExpr = node2.getWhereExpr();
            if (insertExpr == null && whereExpr.equals(deleteExpr)) {
                this.visitWhere(whereExpr);
            } else {
                if (insertExpr != null) {
                    BNode insertList = SpinRenderer.this.valueFactory.createBNode();
                    this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, SP.INSERT_PATTERN_PROPERTY, (Value)insertList));
                    ListContext insertCtx = this.newList(insertList);
                    insertExpr.visit(this);
                    this.endList(insertCtx);
                }
                if (deleteExpr != null) {
                    BNode deleteList = SpinRenderer.this.valueFactory.createBNode();
                    this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, SP.DELETE_PATTERN_PROPERTY, (Value)deleteList));
                    ListContext deleteCtx = this.newList(deleteList);
                    deleteExpr.visit(this);
                    this.endList(deleteCtx);
                }
                if (whereExpr != null) {
                    BNode whereList = SpinRenderer.this.valueFactory.createBNode();
                    this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, SP.WHERE_PROPERTY, (Value)whereList));
                    ListContext whereCtx = this.newList(whereList);
                    whereExpr.visit(this);
                    this.endList(whereCtx);
                }
            }
        }

        @Override
        public void meet(InsertData node2) throws RDFHandlerException {
            BNode dataList = SpinRenderer.this.valueFactory.createBNode();
            this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, SP.DATA_PROPERTY, (Value)dataList));
            ListContext dataCtx = this.newList(dataList);
            this.renderDataBlock(node2.getDataBlock());
            this.endList(dataCtx);
        }

        @Override
        public void meet(DeleteData node2) throws RDFHandlerException {
            BNode dataList = SpinRenderer.this.valueFactory.createBNode();
            this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, SP.DATA_PROPERTY, (Value)dataList));
            ListContext dataCtx = this.newList(dataList);
            this.renderDataBlock(node2.getDataBlock());
            this.endList(dataCtx);
        }

        private void renderDataBlock(String data2) throws RDFHandlerException {
            SPARQLUpdateDataBlockParser parser = new SPARQLUpdateDataBlockParser(SpinRenderer.this.valueFactory);
            parser.setAllowBlankNodes(false);
            parser.setRDFHandler(new RDFHandlerBase(){
                final Map<Resource, ListContext> namedGraphLists = new HashMap<Resource, ListContext>();
                ListContext namedGraphContext;

                @Override
                public void handleStatement(Statement st) throws RDFHandlerException {
                    ListContext ctxList = null;
                    if (st.getContext() != null) {
                        ctxList = this.getNamedGraph(st.getContext());
                    }
                    SpinVisitor.this.listEntry();
                    SpinVisitor.this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(SpinVisitor.this.subject, SP.SUBJECT_PROPERTY, (Value)st.getSubject()));
                    SpinVisitor.this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(SpinVisitor.this.subject, SP.PREDICATE_PROPERTY, (Value)st.getPredicate()));
                    SpinVisitor.this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(SpinVisitor.this.subject, SP.OBJECT_PROPERTY, st.getObject()));
                    if (ctxList != null) {
                        this.restoreNamedGraph(ctxList);
                    }
                }

                @Override
                public void endRDF() throws RDFHandlerException {
                    for (ListContext ctxList : this.namedGraphLists.values()) {
                        SpinVisitor.this.endList(ctxList);
                    }
                }

                private ListContext getNamedGraph(Resource context) throws RDFHandlerException {
                    ListContext currentCtx;
                    this.namedGraphContext = this.namedGraphLists.get(context);
                    if (this.namedGraphContext == null) {
                        SpinVisitor.this.listEntry();
                        SpinVisitor.this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(SpinVisitor.this.subject, RDF.TYPE, (Value)SP.NAMED_GRAPH_CLASS));
                        SpinVisitor.this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(SpinVisitor.this.subject, SP.GRAPH_NAME_NODE_PROPERTY, (Value)context));
                        BNode elementsList = SpinRenderer.this.valueFactory.createBNode();
                        SpinVisitor.this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(SpinVisitor.this.subject, SP.ELEMENTS_PROPERTY, (Value)elementsList));
                        currentCtx = SpinVisitor.this.newList(elementsList);
                        this.namedGraphContext = SpinVisitor.this.save();
                        this.namedGraphLists.put(context, this.namedGraphContext);
                    } else {
                        currentCtx = SpinVisitor.this.save();
                        SpinVisitor.this.restore(this.namedGraphContext);
                    }
                    return currentCtx;
                }

                private void restoreNamedGraph(ListContext ctx) {
                    SpinVisitor.this.update(this.namedGraphContext);
                    SpinVisitor.this.restore(ctx);
                }
            });
            try {
                parser.parse(new StringReader(data2), "");
            }
            catch (RDFParseException e2) {
                throw new RDFHandlerException(e2);
            }
            catch (IOException e3) {
                throw new RDFHandlerException(e3);
            }
        }

        @Override
        public void meet(Load node2) throws RDFHandlerException {
            this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, SP.DOCUMENT_PROPERTY, node2.getSource().getValue()));
            this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, SP.INTO_PROPERTY, node2.getGraph().getValue()));
        }

        @Override
        public void meet(Clear node2) throws RDFHandlerException {
            if (node2.isSilent()) {
                this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, SP.SILENT_PROPERTY, (Value)BooleanLiteral.TRUE));
            }
            if (node2.getGraph() != null) {
                this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, SP.GRAPH_IRI_PROPERTY, node2.getGraph().getValue()));
            } else if (node2.getScope() != null) {
                switch (node2.getScope()) {
                    case DEFAULT_CONTEXTS: {
                        this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, SP.DEFAULT_PROPERTY, (Value)BooleanLiteral.TRUE));
                        break;
                    }
                    case NAMED_CONTEXTS: {
                        this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, SP.NAMED_PROPERTY, (Value)BooleanLiteral.TRUE));
                    }
                }
            } else {
                this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, SP.ALL_PROPERTY, (Value)BooleanLiteral.TRUE));
            }
        }

        @Override
        public void meet(Create node2) throws RDFHandlerException {
            if (node2.isSilent()) {
                this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, SP.SILENT_PROPERTY, (Value)BooleanLiteral.TRUE));
            }
            if (node2.getGraph() != null) {
                this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, SP.GRAPH_IRI_PROPERTY, node2.getGraph().getValue()));
            }
        }

        private final class OrderVisitor
        extends QueryModelVisitorBase<RDFHandlerException> {
            private OrderVisitor() {
            }

            @Override
            public void meet(Order node2) throws RDFHandlerException {
                BNode orderByList = SpinRenderer.this.valueFactory.createBNode();
                SpinVisitor.this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(SpinVisitor.this.subject, SP.ORDER_BY_PROPERTY, (Value)orderByList));
                ListContext orderByCtx = SpinVisitor.this.newList(orderByList);
                for (OrderElem elem : node2.getElements()) {
                    elem.visit(this);
                }
                SpinVisitor.this.endList(orderByCtx);
            }

            @Override
            public void meet(OrderElem node2) throws RDFHandlerException {
                IRI asc = node2.isAscending() ? SP.ASC_CLASS : SP.DESC_CLASS;
                SpinVisitor.this.listEntry();
                SpinVisitor.this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(SpinVisitor.this.subject, RDF.TYPE, (Value)asc));
                SpinVisitor.this.meet(node2.getExpr());
            }

            @Override
            protected void meetNode(QueryModelNode node2) {
            }
        }

        private final class GroupVisitor
        extends QueryModelVisitorBase<RDFHandlerException> {
            Group group;

            private GroupVisitor() {
            }

            @Override
            public void meet(Order node2) throws RDFHandlerException {
                node2.getArg().visit(this);
            }

            @Override
            public void meet(Extension node2) throws RDFHandlerException {
                node2.getArg().visit(this);
            }

            @Override
            public void meet(Group node2) throws RDFHandlerException {
                this.group = node2;
                Set<String> groupNames = node2.getGroupBindingNames();
                if (!groupNames.isEmpty()) {
                    BNode groupByList = SpinRenderer.this.valueFactory.createBNode();
                    SpinVisitor.this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(SpinVisitor.this.subject, SP.GROUP_BY_PROPERTY, (Value)groupByList));
                    ListContext groupByCtx = SpinVisitor.this.newList(groupByList);
                    for (String groupName : groupNames) {
                        Resource var = SpinVisitor.this.getVar(groupName);
                        SpinVisitor.this.listEntry(var);
                    }
                    SpinVisitor.this.endList(groupByCtx);
                }
            }

            @Override
            public void meet(Filter node2) throws RDFHandlerException {
                node2.getArg().visit(this);
                if (this.group != null) {
                    BNode havingList = SpinRenderer.this.valueFactory.createBNode();
                    SpinVisitor.this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(SpinVisitor.this.subject, SP.HAVING_PROPERTY, (Value)havingList));
                    ListContext havingCtx = SpinVisitor.this.newList(havingList);
                    SpinVisitor.this.listEntry();
                    node2.getCondition().visit(SpinVisitor.this);
                    SpinVisitor.this.endList(havingCtx);
                }
            }

            @Override
            protected void meetNode(QueryModelNode node2) {
            }
        }

        private final class ExtensionVisitor
        extends QueryModelVisitorBase<RDFHandlerException> {
            private ExtensionVisitor() {
            }

            @Override
            public void meet(Count node2) throws RDFHandlerException {
                SpinVisitor.this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(SpinVisitor.this.subject, RDF.TYPE, (Value)SP.COUNT_CLASS));
                if (node2.isDistinct()) {
                    SpinVisitor.this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(SpinVisitor.this.subject, SP.DISTINCT_PROPERTY, (Value)BooleanLiteral.TRUE));
                }
                Resource oldSubject = SpinVisitor.this.subject;
                super.meet(node2);
                SpinVisitor.this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(oldSubject, SP.EXPRESSION_PROPERTY, (Value)SpinVisitor.this.subject));
                SpinVisitor.this.subject = oldSubject;
            }

            @Override
            public void meet(Max node2) throws RDFHandlerException {
                SpinVisitor.this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(SpinVisitor.this.subject, RDF.TYPE, (Value)SP.MAX_CLASS));
                if (node2.isDistinct()) {
                    SpinVisitor.this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(SpinVisitor.this.subject, SP.DISTINCT_PROPERTY, (Value)BooleanLiteral.TRUE));
                }
                Resource oldSubject = SpinVisitor.this.subject;
                super.meet(node2);
                SpinVisitor.this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(oldSubject, SP.EXPRESSION_PROPERTY, (Value)SpinVisitor.this.subject));
                SpinVisitor.this.subject = oldSubject;
            }

            @Override
            public void meet(Min node2) throws RDFHandlerException {
                SpinVisitor.this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(SpinVisitor.this.subject, RDF.TYPE, (Value)SP.MIN_CLASS));
                if (node2.isDistinct()) {
                    SpinVisitor.this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(SpinVisitor.this.subject, SP.DISTINCT_PROPERTY, (Value)BooleanLiteral.TRUE));
                }
                Resource oldSubject = SpinVisitor.this.subject;
                super.meet(node2);
                SpinVisitor.this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(oldSubject, SP.EXPRESSION_PROPERTY, (Value)SpinVisitor.this.subject));
                SpinVisitor.this.subject = oldSubject;
            }

            @Override
            public void meet(Sum node2) throws RDFHandlerException {
                SpinVisitor.this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(SpinVisitor.this.subject, RDF.TYPE, (Value)SP.SUM_CLASS));
                if (node2.isDistinct()) {
                    SpinVisitor.this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(SpinVisitor.this.subject, SP.DISTINCT_PROPERTY, (Value)BooleanLiteral.TRUE));
                }
                Resource oldSubject = SpinVisitor.this.subject;
                super.meet(node2);
                SpinVisitor.this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(oldSubject, SP.EXPRESSION_PROPERTY, (Value)SpinVisitor.this.subject));
                SpinVisitor.this.subject = oldSubject;
            }

            @Override
            public void meet(Avg node2) throws RDFHandlerException {
                SpinVisitor.this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(SpinVisitor.this.subject, RDF.TYPE, (Value)SP.AVG_CLASS));
                if (node2.isDistinct()) {
                    SpinVisitor.this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(SpinVisitor.this.subject, SP.DISTINCT_PROPERTY, (Value)BooleanLiteral.TRUE));
                }
                Resource oldSubject = SpinVisitor.this.subject;
                super.meet(node2);
                SpinVisitor.this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(oldSubject, SP.EXPRESSION_PROPERTY, (Value)SpinVisitor.this.subject));
                SpinVisitor.this.subject = oldSubject;
            }

            @Override
            public void meet(GroupConcat node2) throws RDFHandlerException {
                SpinVisitor.this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(SpinVisitor.this.subject, RDF.TYPE, (Value)SP.GROUP_CONCAT_CLASS));
                if (node2.isDistinct()) {
                    SpinVisitor.this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(SpinVisitor.this.subject, SP.DISTINCT_PROPERTY, (Value)BooleanLiteral.TRUE));
                }
                Resource oldSubject = SpinVisitor.this.subject;
                super.meet(node2);
                SpinVisitor.this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(oldSubject, SP.EXPRESSION_PROPERTY, (Value)SpinVisitor.this.subject));
                SpinVisitor.this.subject = oldSubject;
            }

            @Override
            public void meet(Sample node2) throws RDFHandlerException {
                SpinVisitor.this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(SpinVisitor.this.subject, RDF.TYPE, (Value)SP.SAMPLE_CLASS));
                if (node2.isDistinct()) {
                    SpinVisitor.this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(SpinVisitor.this.subject, SP.DISTINCT_PROPERTY, (Value)BooleanLiteral.TRUE));
                }
                Resource oldSubject = SpinVisitor.this.subject;
                super.meet(node2);
                SpinVisitor.this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(oldSubject, SP.EXPRESSION_PROPERTY, (Value)SpinVisitor.this.subject));
                SpinVisitor.this.subject = oldSubject;
            }

            @Override
            public void meet(Var node2) throws RDFHandlerException {
                SpinVisitor.this.subject = SpinVisitor.this.getVar(node2.getName());
            }
        }
    }

    private class ConstructVisitor
    extends SpinVisitor {
        ConstructVisitor(RDFHandler handler, Resource subject, Dataset dataset) {
            super(handler, null, subject, dataset);
        }

        @Override
        public void meet(Reduced node2) throws RDFHandlerException {
            if (!this.isSubQuery) {
                node2.getArg().visit(this);
            } else {
                super.meet(node2);
            }
        }

        @Override
        public void meet(ProjectionElemList node2) throws RDFHandlerException {
            if (this.isSubQuery) {
                super.meet(node2);
            } else if (this.isMultiProjection) {
                this.listEntry();
                this.meetNode(node2);
            } else {
                ListContext ctx = this.startTemplateList();
                this.listEntry();
                this.meetNode(node2);
                this.endTemplateList(ctx);
            }
        }

        @Override
        public void meet(ProjectionElem node2) throws RDFHandlerException {
            if (this.isSubQuery) {
                super.meet(node2);
            } else {
                IRI pred;
                String varName = node2.getSourceName();
                ValueExpr valueExpr = this.inlineBindings.getValueExpr(varName);
                Value value = valueExpr instanceof ValueConstant ? ((ValueConstant)valueExpr).getValue() : this.getVar(varName);
                String targetName = node2.getTargetName();
                if ("subject".equals(targetName)) {
                    pred = SP.SUBJECT_PROPERTY;
                } else if ("predicate".equals(targetName)) {
                    pred = SP.PREDICATE_PROPERTY;
                } else if ("object".equals(targetName)) {
                    pred = SP.OBJECT_PROPERTY;
                } else {
                    throw new AssertionError((Object)("Unexpected ProjectionElem: " + node2));
                }
                this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, pred, value));
            }
        }
    }

    private class DescribeVisitor
    extends SpinVisitor {
        DescribeVisitor(RDFHandler handler, Resource subject, Dataset dataset) {
            super(handler, null, subject, dataset);
        }

        @Override
        public void meet(ProjectionElemList node2) throws RDFHandlerException {
            if (this.isSubQuery) {
                super.meet(node2);
            } else {
                BNode elemListBNode = SpinRenderer.this.valueFactory.createBNode();
                this.handler.handleStatement(SpinRenderer.this.valueFactory.createStatement(this.subject, SP.RESULT_NODES_PROPERTY, (Value)elemListBNode));
                ListContext ctx = this.newList(elemListBNode);
                this.meetNode(node2);
                this.endList(ctx);
            }
        }
    }

    private class AskVisitor
    extends SpinVisitor {
        AskVisitor(RDFHandler handler, Resource list, Dataset dataset) {
            super(handler, list, null, dataset);
        }

        @Override
        public void meet(Slice node2) throws RDFHandlerException {
            if (!this.isSubQuery) {
                node2.getArg().visit(this);
            } else {
                super.meet(node2);
            }
        }
    }

    public static enum Output {
        TEXT_AND_RDF(true, true),
        TEXT_ONLY(true, false),
        RDF_ONLY(false, true);

        final boolean text;
        final boolean rdf;

        private Output(boolean text, boolean rdf) {
            this.text = text;
            this.rdf = rdf;
        }
    }
}

