/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.spin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.rdf4j.RDF4JException;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.RDFS;
import org.eclipse.rdf4j.model.vocabulary.SPIN;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.algebra.AbstractQueryModelNode;
import org.eclipse.rdf4j.query.algebra.Join;
import org.eclipse.rdf4j.query.algebra.Service;
import org.eclipse.rdf4j.query.algebra.SingletonSet;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.TupleFunctionCall;
import org.eclipse.rdf4j.query.algebra.Union;
import org.eclipse.rdf4j.query.algebra.ValueExpr;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryOptimizer;
import org.eclipse.rdf4j.query.algebra.evaluation.TripleSource;
import org.eclipse.rdf4j.query.algebra.evaluation.federation.AbstractFederatedServiceResolver;
import org.eclipse.rdf4j.query.algebra.evaluation.federation.TupleFunctionFederatedService;
import org.eclipse.rdf4j.query.algebra.evaluation.function.TupleFunction;
import org.eclipse.rdf4j.query.algebra.evaluation.function.TupleFunctionRegistry;
import org.eclipse.rdf4j.query.algebra.evaluation.util.TripleSources;
import org.eclipse.rdf4j.query.algebra.helpers.BGPCollector;
import org.eclipse.rdf4j.query.algebra.helpers.QueryModelVisitorBase;
import org.eclipse.rdf4j.query.algebra.helpers.TupleExprs;
import org.eclipse.rdf4j.query.parser.ParsedTupleQuery;
import org.eclipse.rdf4j.queryrender.sparql.SPARQLQueryRenderer;
import org.eclipse.rdf4j.spin.SpinParser;
import org.eclipse.rdf4j.spin.function.ConstructTupleFunction;
import org.eclipse.rdf4j.spin.function.InverseMagicProperty;
import org.eclipse.rdf4j.spin.function.SelectTupleFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpinMagicPropertyInterpreter
implements QueryOptimizer {
    private static final Logger logger = LoggerFactory.getLogger(SpinMagicPropertyInterpreter.class);
    private static final String SPIN_SERVICE = "spin:/";
    private final TripleSource tripleSource;
    private final SpinParser parser;
    private final TupleFunctionRegistry tupleFunctionRegistry;
    private AbstractFederatedServiceResolver serviceResolver;
    private final IRI spinServiceUri;

    static void registerSpinParsingTupleFunctions(SpinParser parser, TupleFunctionRegistry tupleFunctionRegistry) {
        if (!tupleFunctionRegistry.has(SPIN.CONSTRUCT_PROPERTY.stringValue())) {
            tupleFunctionRegistry.add(new ConstructTupleFunction(parser));
        }
        if (!tupleFunctionRegistry.has(SPIN.SELECT_PROPERTY.stringValue())) {
            tupleFunctionRegistry.add(new SelectTupleFunction(parser));
        }
    }

    public SpinMagicPropertyInterpreter(SpinParser parser, TripleSource tripleSource, TupleFunctionRegistry tupleFunctionRegistry, AbstractFederatedServiceResolver serviceResolver) {
        this.parser = parser;
        this.tripleSource = tripleSource;
        this.tupleFunctionRegistry = tupleFunctionRegistry;
        this.serviceResolver = serviceResolver;
        this.spinServiceUri = tripleSource.getValueFactory().createIRI(SPIN_SERVICE);
    }

    @Override
    public void optimize(TupleExpr tupleExpr, Dataset dataset, BindingSet bindings) {
        try {
            tupleExpr.visit(new PropertyScanner());
        }
        catch (RDF4JException e2) {
            logger.warn("Failed to parse tuple function");
        }
    }

    private class PropertyScanner
    extends QueryModelVisitorBase<RDF4JException> {
        private PropertyScanner() {
        }

        private void processGraphPattern(List<StatementPattern> sps) throws RDF4JException {
            TupleFunction func;
            LinkedHashMap<StatementPattern, TupleFunction> magicProperties = new LinkedHashMap<StatementPattern, TupleFunction>();
            HashMap<String, Map<IRI, List<StatementPattern>>> spIndex = new HashMap<String, Map<IRI, List<StatementPattern>>>();
            for (StatementPattern statementPattern : sps) {
                ArrayList<StatementPattern> v;
                IRI pred = (IRI)statementPattern.getPredicateVar().getValue();
                if (pred == null) continue;
                func = SpinMagicPropertyInterpreter.this.tupleFunctionRegistry.get(pred.stringValue()).orElse(null);
                if (func != null) {
                    magicProperties.put(statementPattern, func);
                    continue;
                }
                Statement magicPropStmt = TripleSources.single(pred, RDF.TYPE, SPIN.MAGIC_PROPERTY_CLASS, SpinMagicPropertyInterpreter.this.tripleSource);
                if (magicPropStmt != null) {
                    func = SpinMagicPropertyInterpreter.this.parser.parseMagicProperty(pred, SpinMagicPropertyInterpreter.this.tripleSource);
                    SpinMagicPropertyInterpreter.this.tupleFunctionRegistry.add(func);
                    magicProperties.put(statementPattern, func);
                    continue;
                }
                String subj = statementPattern.getSubjectVar().getName();
                HashMap<IRI, ArrayList<StatementPattern>> predMap = (HashMap<IRI, ArrayList<StatementPattern>>)spIndex.get(subj);
                if (predMap == null) {
                    predMap = new HashMap<IRI, ArrayList<StatementPattern>>(8);
                    spIndex.put(subj, predMap);
                }
                if ((v = (ArrayList<StatementPattern>)predMap.get(pred)) == null) {
                    v = new ArrayList<StatementPattern>(1);
                    predMap.put(pred, v);
                }
                v.add(statementPattern);
            }
            if (!magicProperties.isEmpty()) {
                for (Map.Entry entry : magicProperties.entrySet()) {
                    AbstractQueryModelNode magicPropertyNode;
                    StatementPattern sp = (StatementPattern)entry.getKey();
                    func = (TupleFunction)entry.getValue();
                    Union union2 = new Union();
                    sp.replaceWith(union2);
                    AbstractQueryModelNode stmts = sp;
                    ArrayList<ValueExpr> subjList = new ArrayList(4);
                    TupleExpr subjNodes = this.addList(subjList, sp.getSubjectVar(), spIndex);
                    if (subjNodes != null) {
                        stmts = new Join((TupleExpr)((Object)stmts), subjNodes);
                    } else {
                        subjList = Collections.singletonList(sp.getSubjectVar());
                    }
                    ArrayList<ValueExpr> objList = new ArrayList(4);
                    TupleExpr objNodes = this.addList(objList, sp.getObjectVar(), spIndex);
                    if (objNodes != null) {
                        stmts = new Join((TupleExpr)((Object)stmts), objNodes);
                    } else {
                        objList = Collections.singletonList(sp.getObjectVar());
                    }
                    union2.setLeftArg((TupleExpr)((Object)stmts));
                    TupleFunctionCall funcCall = new TupleFunctionCall();
                    funcCall.setURI(sp.getPredicateVar().getValue().stringValue());
                    if (func instanceof InverseMagicProperty) {
                        funcCall.setArgs(objList);
                        funcCall.setResultVars(subjList);
                    } else {
                        funcCall.setArgs(subjList);
                        funcCall.setResultVars(objList);
                    }
                    if (SpinMagicPropertyInterpreter.this.serviceResolver != null) {
                        String exprString;
                        if (!SpinMagicPropertyInterpreter.this.serviceResolver.hasService(SpinMagicPropertyInterpreter.SPIN_SERVICE)) {
                            SpinMagicPropertyInterpreter.this.serviceResolver.registerService(SpinMagicPropertyInterpreter.SPIN_SERVICE, new TupleFunctionFederatedService(SpinMagicPropertyInterpreter.this.tupleFunctionRegistry, SpinMagicPropertyInterpreter.this.tripleSource.getValueFactory()));
                        }
                        Var serviceRef = TupleExprs.createConstVar(SpinMagicPropertyInterpreter.this.spinServiceUri);
                        try {
                            exprString = new SPARQLQueryRenderer().render(new ParsedTupleQuery((TupleExpr)((Object)stmts)));
                            exprString = exprString.substring(exprString.indexOf(123) + 1, exprString.lastIndexOf(125));
                        }
                        catch (Exception e2) {
                            throw new MalformedQueryException(e2);
                        }
                        HashMap<String, String> prefixDecls = new HashMap<String, String>(8);
                        prefixDecls.put("sp", "http://spinrdf.org/sp#");
                        prefixDecls.put("spin", "http://spinrdf.org/spin#");
                        prefixDecls.put("spl", "http://spinrdf.org/spl#");
                        magicPropertyNode = new Service(serviceRef, funcCall, exprString, prefixDecls, null, false);
                    } else {
                        magicPropertyNode = funcCall;
                    }
                    union2.setRightArg((TupleExpr)((Object)magicPropertyNode));
                }
            }
        }

        private TupleExpr join(TupleExpr node2, TupleExpr toMove) {
            toMove.replaceWith(new SingletonSet());
            node2 = node2 != null ? new Join(node2, toMove) : toMove;
            return node2;
        }

        private TupleExpr addList(List<? super Var> list, Var subj, Map<String, Map<IRI, List<StatementPattern>>> spIndex) {
            TupleExpr node2 = null;
            do {
                Map<IRI, List<StatementPattern>> predMap;
                if ((predMap = spIndex.get(subj.getName())) == null) {
                    return null;
                }
                List<StatementPattern> firstStmts = predMap.get(RDF.FIRST);
                if (firstStmts == null) {
                    return null;
                }
                if (firstStmts.size() != 1) {
                    return null;
                }
                List<StatementPattern> restStmts = predMap.get(RDF.REST);
                if (restStmts == null) {
                    return null;
                }
                if (restStmts.size() != 1) {
                    return null;
                }
                StatementPattern firstStmt = firstStmts.get(0);
                list.add(firstStmt.getObjectVar());
                node2 = this.join(node2, firstStmt);
                StatementPattern restStmt = restStmts.get(0);
                subj = restStmt.getObjectVar();
                node2 = this.join(node2, restStmt);
                List<StatementPattern> typeStmts = predMap.get(RDF.TYPE);
                if (typeStmts == null) continue;
                for (StatementPattern sp : firstStmts) {
                    Value type2 = sp.getObjectVar().getValue();
                    if (!RDFS.RESOURCE.equals(type2) && !RDF.LIST.equals(type2)) continue;
                    node2 = this.join(node2, sp);
                }
            } while (!RDF.NIL.equals(subj.getValue()));
            return node2;
        }

        @Override
        public void meet(Join node2) throws RDF4JException {
            BGPCollector<RDF4JException> collector = new BGPCollector<RDF4JException>(this);
            node2.visit(collector);
            this.processGraphPattern(collector.getStatementPatterns());
        }

        @Override
        public void meet(StatementPattern node2) throws RDF4JException {
            this.processGraphPattern(Collections.singletonList(node2));
        }
    }
}

