/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.nativerdf;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.Optional;
import org.eclipse.rdf4j.common.concurrent.locks.Lock;
import org.eclipse.rdf4j.common.concurrent.locks.ReadWriteLockManager;
import org.eclipse.rdf4j.common.concurrent.locks.WritePrefReadWriteLockManager;
import org.eclipse.rdf4j.common.io.ByteArrayUtil;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.AbstractValueFactory;
import org.eclipse.rdf4j.model.util.Literals;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.XMLSchema;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.nativerdf.LRUCache;
import org.eclipse.rdf4j.sail.nativerdf.ValueStoreRevision;
import org.eclipse.rdf4j.sail.nativerdf.datastore.DataStore;
import org.eclipse.rdf4j.sail.nativerdf.model.NativeBNode;
import org.eclipse.rdf4j.sail.nativerdf.model.NativeIRI;
import org.eclipse.rdf4j.sail.nativerdf.model.NativeLiteral;
import org.eclipse.rdf4j.sail.nativerdf.model.NativeResource;
import org.eclipse.rdf4j.sail.nativerdf.model.NativeValue;

public class ValueStore
extends AbstractValueFactory {
    public static final int VALUE_CACHE_SIZE = 512;
    public static final int VALUE_ID_CACHE_SIZE = 128;
    public static final int NAMESPACE_CACHE_SIZE = 64;
    public static final int NAMESPACE_ID_CACHE_SIZE = 32;
    private static final String FILENAME_PREFIX = "values";
    private static final byte URI_VALUE = 1;
    private static final byte BNODE_VALUE = 2;
    private static final byte LITERAL_VALUE = 3;
    private final DataStore dataStore;
    private final ReadWriteLockManager lockManager = new WritePrefReadWriteLockManager();
    private volatile ValueStoreRevision revision;
    private final LRUCache<Integer, NativeValue> valueCache;
    private final LRUCache<NativeValue, Integer> valueIDCache;
    private final LRUCache<Integer, String> namespaceCache;
    private final LRUCache<String, Integer> namespaceIDCache;

    public ValueStore(File dataDir) throws IOException {
        this(dataDir, false);
    }

    public ValueStore(File dataDir, boolean forceSync) throws IOException {
        this(dataDir, forceSync, 512, 128, 64, 32);
    }

    public ValueStore(File dataDir, boolean forceSync, int valueCacheSize, int valueIDCacheSize, int namespaceCacheSize, int namespaceIDCacheSize) throws IOException {
        this.dataStore = new DataStore(dataDir, FILENAME_PREFIX, forceSync);
        this.valueCache = new LRUCache(valueCacheSize);
        this.valueIDCache = new LRUCache(valueIDCacheSize);
        this.namespaceCache = new LRUCache(namespaceCacheSize);
        this.namespaceIDCache = new LRUCache(namespaceIDCacheSize);
        this.setNewRevision();
    }

    private void setNewRevision() {
        this.revision = new ValueStoreRevision(this);
    }

    public ValueStoreRevision getRevision() {
        return this.revision;
    }

    public Lock getReadLock() throws InterruptedException {
        return this.lockManager.getReadLock();
    }

    public NativeValue getValue(int id) throws IOException {
        byte[] data2;
        Integer cacheID = new Integer(id);
        NativeValue resultValue = this.valueCache.get(cacheID);
        if (resultValue == null && (data2 = this.dataStore.getData(id)) != null) {
            resultValue = this.data2value(id, data2);
            this.valueCache.put(cacheID, resultValue);
        }
        return resultValue;
    }

    public int getID(Value value) throws IOException {
        int id;
        NativeValue nativeValue;
        boolean isOwnValue = this.isOwnValue(value);
        if (isOwnValue && this.revisionIsCurrent(nativeValue = (NativeValue)value) && (id = nativeValue.getInternalID()) != -1) {
            return id;
        }
        Integer cachedID = this.valueIDCache.get(value);
        if (cachedID != null) {
            id = cachedID;
            if (isOwnValue) {
                ((NativeValue)value).setInternalID(id, this.revision);
            }
            return id;
        }
        byte[] data2 = this.value2data(value, false);
        if (data2 == null && value instanceof Literal) {
            data2 = this.literal2legacy((Literal)value);
        }
        if (data2 != null) {
            int id2 = this.dataStore.getID(data2);
            if (id2 == -1 && value instanceof Literal) {
                id2 = this.dataStore.getID(this.literal2legacy((Literal)value));
            }
            if (id2 != -1) {
                if (isOwnValue) {
                    ((NativeValue)value).setInternalID(id2, this.revision);
                } else {
                    NativeValue nv = this.getNativeValue(value);
                    nv.setInternalID(id2, this.revision);
                    this.valueIDCache.put(nv, new Integer(id2));
                }
            }
            return id2;
        }
        return -1;
    }

    public int storeValue(Value value) throws IOException {
        int id;
        NativeValue nativeValue;
        boolean isOwnValue = this.isOwnValue(value);
        if (isOwnValue && this.revisionIsCurrent(nativeValue = (NativeValue)value) && (id = nativeValue.getInternalID()) != -1) {
            return id;
        }
        Integer cachedID = this.valueIDCache.get(value);
        if (cachedID != null) {
            id = cachedID;
            if (isOwnValue) {
                ((NativeValue)value).setInternalID(id, this.revision);
            }
            return id;
        }
        byte[] valueData = this.value2data(value, true);
        int id2 = this.dataStore.storeData(valueData);
        NativeValue nv = isOwnValue ? (NativeValue)value : this.getNativeValue(value);
        nv.setInternalID(id2, this.revision);
        this.valueIDCache.put(nv, new Integer(id2));
        return id2;
    }

    public void clear() throws IOException {
        try {
            Lock writeLock = this.lockManager.getWriteLock();
            try {
                this.dataStore.clear();
                this.valueCache.clear();
                this.valueIDCache.clear();
                this.namespaceCache.clear();
                this.namespaceIDCache.clear();
                this.initBNodeParams();
                this.setNewRevision();
            }
            finally {
                writeLock.release();
            }
        }
        catch (InterruptedException e2) {
            IOException ioe = new IOException("Failed to acquire write lock");
            ioe.initCause(e2);
            throw ioe;
        }
    }

    public void sync() throws IOException {
        this.dataStore.sync();
    }

    public void close() throws IOException {
        this.dataStore.close();
    }

    public void checkConsistency() throws SailException, IOException {
        int maxID = this.dataStore.getMaxID();
        for (int id = 1; id <= maxID; ++id) {
            byte[] data2 = this.dataStore.getData(id);
            if (this.isNamespaceData(data2)) {
                String namespace2 = this.data2namespace(data2);
                try {
                    if (id == this.getNamespaceID(namespace2, false) && URI.create(namespace2 + "part").isAbsolute()) {
                        continue;
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                throw new SailException("Store must be manually exported and imported to fix namespaces like " + namespace2);
            }
            NativeValue value = this.data2value(id, data2);
            if (id == this.getID(this.copy(value))) continue;
            throw new SailException("Store must be manually exported and imported to merge values like " + value);
        }
    }

    private Value copy(Value value) {
        if (value instanceof IRI) {
            return this.createIRI(value.stringValue());
        }
        if (value instanceof Literal) {
            Literal lit = (Literal)value;
            if (Literals.isLanguageLiteral(lit)) {
                return this.createLiteral(value.stringValue(), (String)lit.getLanguage().orElse(null));
            }
            return this.createLiteral(value.stringValue(), lit.getDatatype());
        }
        return this.createBNode(value.stringValue());
    }

    private boolean isOwnValue(Value value) {
        return value instanceof NativeValue && ((NativeValue)value).getValueStoreRevision().getValueStore() == this;
    }

    private boolean revisionIsCurrent(NativeValue value) {
        return this.revision.equals(value.getValueStoreRevision());
    }

    private byte[] value2data(Value value, boolean create) throws IOException {
        if (value instanceof IRI) {
            return this.uri2data((IRI)value, create);
        }
        if (value instanceof BNode) {
            return this.bnode2data((BNode)value, create);
        }
        if (value instanceof Literal) {
            return this.literal2data((Literal)value, create);
        }
        throw new IllegalArgumentException("value parameter should be a URI, BNode or Literal");
    }

    private byte[] uri2data(IRI uri, boolean create) throws IOException {
        int nsID = this.getNamespaceID(uri.getNamespace(), create);
        if (nsID == -1) {
            return null;
        }
        byte[] localNameData = uri.getLocalName().getBytes("UTF-8");
        byte[] uriData = new byte[5 + localNameData.length];
        uriData[0] = 1;
        ByteArrayUtil.putInt(nsID, uriData, 1);
        ByteArrayUtil.put(localNameData, uriData, 5);
        return uriData;
    }

    private byte[] bnode2data(BNode bNode, boolean create) throws IOException {
        byte[] idData = bNode.getID().getBytes("UTF-8");
        byte[] bNodeData = new byte[1 + idData.length];
        bNodeData[0] = 2;
        ByteArrayUtil.put(idData, bNodeData, 1);
        return bNodeData;
    }

    private byte[] literal2data(Literal literal, boolean create) throws IOException {
        return this.literal2data(literal.getLabel(), literal.getLanguage(), literal.getDatatype(), create);
    }

    private byte[] literal2legacy(Literal literal) throws IOException {
        IRI dt = literal.getDatatype();
        if (XMLSchema.STRING.equals(dt) || RDF.LANGSTRING.equals(dt)) {
            return this.literal2data(literal.getLabel(), literal.getLanguage(), null, false);
        }
        return this.literal2data(literal.getLabel(), literal.getLanguage(), dt, false);
    }

    private byte[] literal2data(String label, Optional<String> lang, IRI dt, boolean create) throws IOException, UnsupportedEncodingException {
        int datatypeID = -1;
        if (create) {
            datatypeID = this.storeValue(dt);
        } else if (dt != null && (datatypeID = this.getID(dt)) == -1) {
            return null;
        }
        byte[] langData = null;
        int langDataLength = 0;
        if (lang.isPresent()) {
            langData = lang.get().getBytes("UTF-8");
            langDataLength = langData.length;
        }
        byte[] labelData = label.getBytes("UTF-8");
        byte[] literalData = new byte[6 + langDataLength + labelData.length];
        literalData[0] = 3;
        ByteArrayUtil.putInt(datatypeID, literalData, 1);
        literalData[5] = (byte)langDataLength;
        if (langData != null) {
            ByteArrayUtil.put(langData, literalData, 6);
        }
        ByteArrayUtil.put(labelData, literalData, 6 + langDataLength);
        return literalData;
    }

    private boolean isNamespaceData(byte[] data2) {
        return data2[0] != 1 && data2[0] != 2 && data2[0] != 3;
    }

    private NativeValue data2value(int id, byte[] data2) throws IOException {
        switch (data2[0]) {
            case 1: {
                return this.data2uri(id, data2);
            }
            case 2: {
                return this.data2bnode(id, data2);
            }
            case 3: {
                return this.data2literal(id, data2);
            }
        }
        throw new IllegalArgumentException("Namespaces cannot be converted into values: " + this.data2namespace(data2));
    }

    private NativeIRI data2uri(int id, byte[] data2) throws IOException {
        int nsID = ByteArrayUtil.getInt(data2, 1);
        String namespace2 = this.getNamespace(nsID);
        String localName = new String(data2, 5, data2.length - 5, "UTF-8");
        return new NativeIRI(this.revision, namespace2, localName, id);
    }

    private NativeBNode data2bnode(int id, byte[] data2) throws IOException {
        String nodeID = new String(data2, 1, data2.length - 1, "UTF-8");
        return new NativeBNode(this.revision, nodeID, id);
    }

    private NativeLiteral data2literal(int id, byte[] data2) throws IOException {
        int datatypeID = ByteArrayUtil.getInt(data2, 1);
        IRI datatype = null;
        if (datatypeID != -1) {
            datatype = (IRI)((Object)this.getValue(datatypeID));
        }
        String lang = null;
        byte langLength = data2[5];
        if (langLength > 0) {
            lang = new String(data2, 6, (int)langLength, "UTF-8");
        }
        String label = new String(data2, 6 + langLength, data2.length - 6 - langLength, "UTF-8");
        if (lang != null) {
            return new NativeLiteral(this.revision, label, lang, id);
        }
        if (datatype != null) {
            return new NativeLiteral(this.revision, label, datatype, id);
        }
        return new NativeLiteral(this.revision, label, XMLSchema.STRING, id);
    }

    private String data2namespace(byte[] data2) throws UnsupportedEncodingException {
        return new String(data2, "UTF-8");
    }

    private int getNamespaceID(String namespace2, boolean create) throws IOException {
        Integer cacheID = this.namespaceIDCache.get(namespace2);
        if (cacheID != null) {
            return cacheID;
        }
        byte[] namespaceData = namespace2.getBytes("UTF-8");
        int id = create ? this.dataStore.storeData(namespaceData) : this.dataStore.getID(namespaceData);
        if (id != -1) {
            this.namespaceIDCache.put(namespace2, new Integer(id));
        }
        return id;
    }

    private String getNamespace(int id) throws IOException {
        Integer cacheID = new Integer(id);
        String namespace2 = this.namespaceCache.get(cacheID);
        if (namespace2 == null) {
            byte[] namespaceData = this.dataStore.getData(id);
            namespace2 = this.data2namespace(namespaceData);
            this.namespaceCache.put(cacheID, namespace2);
        }
        return namespace2;
    }

    @Override
    public NativeIRI createIRI(String uri) {
        return new NativeIRI(this.revision, uri);
    }

    @Override
    public NativeIRI createIRI(String namespace2, String localName) {
        return new NativeIRI(this.revision, namespace2, localName);
    }

    @Override
    public NativeBNode createBNode(String nodeID) {
        return new NativeBNode(this.revision, nodeID);
    }

    @Override
    public NativeLiteral createLiteral(String value) {
        return new NativeLiteral(this.revision, value, XMLSchema.STRING);
    }

    @Override
    public NativeLiteral createLiteral(String value, String language) {
        return new NativeLiteral(this.revision, value, language);
    }

    @Override
    public NativeLiteral createLiteral(String value, IRI datatype) {
        return new NativeLiteral(this.revision, value, datatype);
    }

    public NativeValue getNativeValue(Value value) {
        if (value instanceof Resource) {
            return this.getNativeResource((Resource)value);
        }
        if (value instanceof Literal) {
            return this.getNativeLiteral((Literal)value);
        }
        throw new IllegalArgumentException("Unknown value type: " + value.getClass());
    }

    public NativeResource getNativeResource(Resource resource2) {
        if (resource2 instanceof IRI) {
            return this.getNativeURI((IRI)resource2);
        }
        if (resource2 instanceof BNode) {
            return this.getNativeBNode((BNode)resource2);
        }
        throw new IllegalArgumentException("Unknown resource type: " + resource2.getClass());
    }

    public NativeIRI getNativeURI(IRI uri) {
        if (this.isOwnValue(uri)) {
            return (NativeIRI)uri;
        }
        return new NativeIRI(this.revision, uri.toString());
    }

    public NativeBNode getNativeBNode(BNode bnode) {
        if (this.isOwnValue(bnode)) {
            return (NativeBNode)bnode;
        }
        return new NativeBNode(this.revision, bnode.getID());
    }

    public NativeLiteral getNativeLiteral(Literal l) {
        if (this.isOwnValue(l)) {
            return (NativeLiteral)l;
        }
        if (Literals.isLanguageLiteral(l)) {
            return new NativeLiteral(this.revision, l.getLabel(), l.getLanguage().get());
        }
        NativeIRI datatype = this.getNativeURI(l.getDatatype());
        return new NativeLiteral(this.revision, l.getLabel(), datatype);
    }

    public static void main(String[] args) throws Exception {
        File dataDir = new File(args[0]);
        ValueStore valueStore = new ValueStore(dataDir);
        int maxID = valueStore.dataStore.getMaxID();
        for (int id = 1; id <= maxID; ++id) {
            byte[] data2 = valueStore.dataStore.getData(id);
            if (valueStore.isNamespaceData(data2)) {
                String ns2 = valueStore.data2namespace(data2);
                System.out.println("[" + id + "] " + ns2);
                continue;
            }
            NativeValue value = valueStore.data2value(id, data2);
            System.out.println("[" + id + "] " + value.toString());
        }
    }
}

