/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.lucene;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.spatial4j.core.context.SpatialContext;
import com.spatial4j.core.context.SpatialContextFactory;
import com.spatial4j.core.shape.Circle;
import com.spatial4j.core.shape.Point;
import com.spatial4j.core.shape.Shape;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.UndeclaredThrowableException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.DocsEnum;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.CustomScoreQuery;
import org.apache.lucene.queries.function.FunctionQuery;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.highlight.Highlighter;
import org.apache.lucene.search.highlight.QueryScorer;
import org.apache.lucene.search.highlight.SimpleHTMLFormatter;
import org.apache.lucene.spatial.SpatialStrategy;
import org.apache.lucene.spatial.prefix.RecursivePrefixTreeStrategy;
import org.apache.lucene.spatial.prefix.tree.SpatialPrefixTree;
import org.apache.lucene.spatial.prefix.tree.SpatialPrefixTreeFactory;
import org.apache.lucene.spatial.query.SpatialArgs;
import org.apache.lucene.spatial.query.SpatialOperation;
import org.apache.lucene.store.BaseDirectory;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.RAMDirectory;
import org.apache.lucene.util.Bits;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.URI;
import org.eclipse.rdf4j.model.vocabulary.GEOF;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.lucene.AbstractLuceneIndex;
import org.eclipse.rdf4j.sail.lucene.AbstractReaderMonitor;
import org.eclipse.rdf4j.sail.lucene.BulkUpdater;
import org.eclipse.rdf4j.sail.lucene.DocumentDistance;
import org.eclipse.rdf4j.sail.lucene.DocumentResult;
import org.eclipse.rdf4j.sail.lucene.DocumentScore;
import org.eclipse.rdf4j.sail.lucene.LuceneDocument;
import org.eclipse.rdf4j.sail.lucene.LuceneDocumentDistance;
import org.eclipse.rdf4j.sail.lucene.LuceneDocumentResult;
import org.eclipse.rdf4j.sail.lucene.LuceneDocumentScore;
import org.eclipse.rdf4j.sail.lucene.LuceneQuery;
import org.eclipse.rdf4j.sail.lucene.ReaderMonitor;
import org.eclipse.rdf4j.sail.lucene.SearchDocument;
import org.eclipse.rdf4j.sail.lucene.SearchFields;
import org.eclipse.rdf4j.sail.lucene.SearchQuery;
import org.eclipse.rdf4j.sail.lucene.SimpleBulkUpdater;
import org.eclipse.rdf4j.sail.lucene.util.GeoUnits;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LuceneIndex
extends AbstractLuceneIndex {
    private static final String GEO_FIELD_PREFIX = "_geo_";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private volatile Directory directory;
    private volatile Analyzer analyzer;
    private volatile Analyzer queryAnalyzer;
    private volatile IndexWriter indexWriter;
    protected volatile ReaderMonitor currentMonitor;
    private volatile Function<? super String, ? extends SpatialStrategy> geoStrategyMapper;
    private final AtomicBoolean closed = new AtomicBoolean(false);

    public LuceneIndex() {
    }

    public LuceneIndex(Directory directory, Analyzer analyzer) throws IOException {
        this.directory = directory;
        this.analyzer = analyzer;
        this.geoStrategyMapper = this.createSpatialStrategyMapper(Collections.emptyMap());
        this.postInit();
    }

    @Override
    public synchronized void initialize(Properties parameters) throws Exception {
        super.initialize(parameters);
        this.directory = this.createDirectory(parameters);
        this.analyzer = this.createAnalyzer(parameters);
        this.geoStrategyMapper = this.createSpatialStrategyMapper(parameters);
        this.postInit();
    }

    protected Directory createDirectory(Properties parameters) throws IOException {
        BaseDirectory dir2;
        if (parameters.containsKey("lucenedir")) {
            dir2 = FSDirectory.open(Paths.get(parameters.getProperty("lucenedir"), new String[0]));
        } else if (parameters.containsKey("useramdir") && "true".equals(parameters.getProperty("useramdir"))) {
            dir2 = new RAMDirectory();
        } else {
            throw new IOException("No luceneIndex set, and no 'lucenedir' or 'useramdir' parameter given. ");
        }
        return dir2;
    }

    protected Analyzer createAnalyzer(Properties parameters) throws Exception {
        Analyzer analyzer = parameters.containsKey("analyzer") ? (Analyzer)Class.forName(parameters.getProperty("analyzer")).newInstance() : new StandardAnalyzer();
        return analyzer;
    }

    private void postInit() throws IOException {
        this.queryAnalyzer = new StandardAnalyzer();
        if (!DirectoryReader.indexExists(this.directory)) {
            this.logger.debug("creating new Lucene index in directory {}", (Object)this.directory);
            IndexWriterConfig indexWriterConfig = new IndexWriterConfig(this.analyzer);
            indexWriterConfig.setOpenMode(IndexWriterConfig.OpenMode.CREATE);
            IndexWriter writer2 = new IndexWriter(this.directory, indexWriterConfig);
            writer2.close();
        }
    }

    protected Function<String, ? extends SpatialStrategy> createSpatialStrategyMapper(Map<String, String> parameters) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        SpatialContext geoContext = SpatialContextFactory.makeSpatialContext(parameters, classLoader);
        final SpatialPrefixTree spt = SpatialPrefixTreeFactory.makeSPT(parameters, classLoader, geoContext);
        return new Function<String, SpatialStrategy>(){

            @Override
            public SpatialStrategy apply(String field) {
                return new RecursivePrefixTreeStrategy(spt, LuceneIndex.GEO_FIELD_PREFIX + field);
            }
        };
    }

    @Override
    protected SpatialContext getSpatialContext(String property) {
        return this.geoStrategyMapper.apply(property).getSpatialContext();
    }

    public Directory getDirectory() {
        return this.directory;
    }

    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    public Function<? super String, ? extends SpatialStrategy> getSpatialStrategyMapper() {
        return this.geoStrategyMapper;
    }

    public synchronized IndexReader getIndexReader() throws IOException {
        if (this.closed.get()) {
            throw new SailException("Index has been closed");
        }
        return this.getIndexSearcher().getIndexReader();
    }

    public synchronized IndexSearcher getIndexSearcher() throws IOException {
        if (this.closed.get()) {
            throw new SailException("Index has been closed");
        }
        return this.getCurrentMonitor().getIndexSearcher();
    }

    @Override
    public synchronized ReaderMonitor getCurrentMonitor() {
        if (this.closed.get()) {
            throw new SailException("Index has been closed");
        }
        if (this.currentMonitor == null) {
            this.currentMonitor = new ReaderMonitor(this, this.directory);
        }
        return this.currentMonitor;
    }

    public synchronized IndexWriter getIndexWriter() throws IOException {
        if (this.closed.get()) {
            throw new SailException("Index has been closed");
        }
        if (this.indexWriter == null) {
            IndexWriterConfig indexWriterConfig = new IndexWriterConfig(this.analyzer);
            this.indexWriter = new IndexWriter(this.directory, indexWriterConfig);
        }
        return this.indexWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutDown() throws IOException {
        if (this.closed.compareAndSet(false, true)) {
            try {
                ReaderMonitor toCloseCurrentMonitor = this.currentMonitor;
                this.currentMonitor = null;
                if (toCloseCurrentMonitor != null) {
                    toCloseCurrentMonitor.close();
                }
            }
            finally {
                ArrayList<Throwable> exceptions = new ArrayList<Throwable>();
                try {
                    Collection collection = this.oldmonitors;
                    synchronized (collection) {
                        if (this.oldmonitors.size() > 0) {
                            this.logger.warn("LuceneSail: On shutdown {} IndexReaders were not closed. This is due to non-closed Query Iterators, which must be closed!", (Object)this.oldmonitors.size());
                        }
                        for (AbstractReaderMonitor monitor : this.oldmonitors) {
                            try {
                                monitor.close();
                            }
                            catch (Throwable e2) {
                                exceptions.add(e2);
                            }
                        }
                        this.oldmonitors.clear();
                    }
                }
                finally {
                    try {
                        IndexWriter toCloseIndexWriter = this.indexWriter;
                        this.indexWriter = null;
                        if (toCloseIndexWriter != null) {
                            toCloseIndexWriter.close();
                        }
                    }
                    finally {
                        if (!exceptions.isEmpty()) {
                            throw new UndeclaredThrowableException((Throwable)exceptions.get(0));
                        }
                    }
                }
            }
        }
    }

    @Override
    protected synchronized SearchDocument getDocument(String id) throws IOException {
        Document document = this.getDocument(this.idTerm(id));
        return document != null ? new LuceneDocument(document, this.geoStrategyMapper) : null;
    }

    @Override
    protected synchronized Iterable<? extends SearchDocument> getDocuments(String resourceId) throws IOException {
        List<Document> docs = this.getDocuments(new Term("uri", resourceId));
        return Iterables.transform(docs, new Function<Document, SearchDocument>(){

            @Override
            public SearchDocument apply(Document doc2) {
                return new LuceneDocument(doc2, LuceneIndex.this.geoStrategyMapper);
            }
        });
    }

    @Override
    protected synchronized SearchDocument newDocument(String id, String resourceId, String context) {
        return new LuceneDocument(id, resourceId, context, this.geoStrategyMapper);
    }

    @Override
    protected synchronized SearchDocument copyDocument(SearchDocument doc2) {
        Document document = ((LuceneDocument)doc2).getDocument();
        Document newDocument = new Document();
        for (IndexableField oldField : document.getFields()) {
            newDocument.add(oldField);
        }
        return new LuceneDocument(newDocument, this.geoStrategyMapper);
    }

    @Override
    protected synchronized void addDocument(SearchDocument doc2) throws IOException {
        this.getIndexWriter().addDocument(((LuceneDocument)doc2).getDocument());
    }

    @Override
    protected synchronized void updateDocument(SearchDocument doc2) throws IOException {
        this.getIndexWriter().updateDocument(this.idTerm(doc2.getId()), ((LuceneDocument)doc2).getDocument());
    }

    @Override
    protected synchronized void deleteDocument(SearchDocument doc2) throws IOException {
        this.getIndexWriter().deleteDocuments(this.idTerm(doc2.getId()));
    }

    @Override
    protected synchronized BulkUpdater newBulkUpdate() {
        return new SimpleBulkUpdater(this);
    }

    private Term idTerm(String id) {
        return new Term("id", id);
    }

    private Document getDocument(Term idTerm) throws IOException {
        IndexReader reader2 = this.getIndexReader();
        List<LeafReaderContext> leaves = reader2.leaves();
        int size = leaves.size();
        for (int i = 0; i < size; ++i) {
            LeafReader lreader = leaves.get(i).reader();
            Document document = LuceneIndex.getDocument(lreader, idTerm);
            if (document == null) continue;
            return document;
        }
        return null;
    }

    private static Document getDocument(LeafReader reader2, Term term) throws IOException {
        DocsEnum docs = reader2.termDocsEnum(term);
        if (docs != null) {
            int docId = docs.nextDoc();
            if (docId != Integer.MAX_VALUE) {
                if (docs.nextDoc() != Integer.MAX_VALUE) {
                    throw new IllegalStateException("Multiple Documents for term " + term.text());
                }
                return LuceneIndex.readDocument(reader2, docId, null);
            }
            return null;
        }
        return null;
    }

    private List<Document> getDocuments(Term uriTerm) throws IOException {
        ArrayList<Document> result = new ArrayList<Document>();
        IndexReader reader2 = this.getIndexReader();
        List<LeafReaderContext> leaves = reader2.leaves();
        int size = leaves.size();
        for (int i = 0; i < size; ++i) {
            LeafReader lreader = leaves.get(i).reader();
            LuceneIndex.addDocuments(lreader, uriTerm, result);
        }
        return result;
    }

    private static void addDocuments(LeafReader reader2, Term term, Collection<Document> documents) throws IOException {
        DocsEnum docs = reader2.termDocsEnum(term);
        if (docs != null) {
            int docId;
            while ((docId = docs.nextDoc()) != Integer.MAX_VALUE) {
                Document document = LuceneIndex.readDocument(reader2, docId, null);
                documents.add(document);
            }
        }
    }

    public synchronized Document getDocument(Resource subject, Resource context) throws IOException {
        String resourceId = SearchFields.getResourceID(subject);
        String contextId = SearchFields.getContextID(context);
        Term idTerm = new Term("id", SearchFields.formIdString(resourceId, contextId));
        return this.getDocument(idTerm);
    }

    public synchronized List<Document> getDocuments(Resource subject) throws IOException {
        String resourceId = SearchFields.getResourceID(subject);
        Term uriTerm = new Term("uri", resourceId);
        return this.getDocuments(uriTerm);
    }

    public static void addIDField(String id, Document document) {
        document.add(new StringField("id", id, Field.Store.YES));
    }

    public static void addContextField(String context, Document document) {
        if (context != null) {
            document.add(new StringField("context", context, Field.Store.YES));
        }
    }

    public static void addResourceField(String resourceId, Document document) {
        document.add(new StringField("uri", resourceId, Field.Store.YES));
    }

    public static void addPredicateField(String predicate, String text, Document document) {
        document.add(new TextField(predicate, text, Field.Store.YES));
    }

    public static void addStoredOnlyPredicateField(String predicate, String text, Document document) {
        document.add(new StoredField(predicate, text));
    }

    public static void addTextField(String text, Document document) {
        document.add(new TextField("text", text, Field.Store.YES));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invalidateReaders() throws IOException {
        Collection collection = this.oldmonitors;
        synchronized (collection) {
            if (this.currentMonitor != null) {
                this.oldmonitors.add(this.currentMonitor);
            }
            this.currentMonitor = null;
            Iterator i = this.oldmonitors.iterator();
            while (i.hasNext()) {
                AbstractReaderMonitor monitor = (AbstractReaderMonitor)i.next();
                if (!monitor.closeWhenPossible()) continue;
                i.remove();
            }
            if (this.oldmonitors.isEmpty()) {
                this.logger.debug("Deleting unused files from Lucene index");
                this.getIndexWriter().deleteUnusedFiles();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logIndexStats() {
        try {
            IndexReader reader2 = null;
            try {
                reader2 = this.getIndexReader();
                int totalFields = 0;
                HashSet<String> ids = new HashSet<String>();
                int count2 = 0;
                for (int i = 0; i < reader2.maxDoc(); ++i) {
                    String[] idArray;
                    if (LuceneIndex.isDeleted(reader2, i)) continue;
                    Document doc2 = LuceneIndex.readDocument(reader2, i, null);
                    totalFields += doc2.getFields().size();
                    ++count2;
                    for (String id : idArray = doc2.getValues("id")) {
                        ids.add(id);
                    }
                }
                this.logger.info("Total documents in the index: " + reader2.numDocs() + ", number of deletable documents in the index: " + reader2.numDeletedDocs() + ", valid documents: " + count2 + ", total fields in all documents: " + totalFields + ", average number of fields per document: " + (double)totalFields / (double)reader2.numDocs());
                this.logger.info("Distinct ids in the index: " + ids.size());
            }
            finally {
                ReaderMonitor toCloseCurrentMonitor = this.currentMonitor;
                this.currentMonitor = null;
                if (toCloseCurrentMonitor != null) {
                    toCloseCurrentMonitor.closeWhenPossible();
                }
            }
        }
        catch (IOException e2) {
            this.logger.warn(e2.getMessage(), e2);
        }
    }

    @Override
    public synchronized void begin() throws IOException {
    }

    @Override
    public synchronized void commit() throws IOException {
        this.getIndexWriter().commit();
        this.invalidateReaders();
    }

    @Override
    public synchronized void rollback() throws IOException {
        this.getIndexWriter().rollback();
    }

    @Override
    @Deprecated
    protected SearchQuery parseQuery(String query, URI propertyURI) throws MalformedQueryException {
        Query q;
        try {
            q = this.getQueryParser(propertyURI).parse(query);
        }
        catch (ParseException e2) {
            throw new MalformedQueryException(e2);
        }
        return new LuceneQuery(q, this);
    }

    @Override
    protected Iterable<? extends DocumentScore> query(Resource subject, String query, URI propertyURI, boolean highlight) throws MalformedQueryException, IOException {
        Highlighter highlighter;
        Query q;
        try {
            q = this.getQueryParser(propertyURI).parse(query);
        }
        catch (ParseException e2) {
            throw new MalformedQueryException(e2);
        }
        if (highlight) {
            SimpleHTMLFormatter formatter2 = new SimpleHTMLFormatter("<B>", "</B>");
            highlighter = new Highlighter(formatter2, new QueryScorer(q));
        } else {
            highlighter = null;
        }
        TopDocs docs = subject != null ? this.search(subject, q) : this.search(q);
        return Iterables.transform(Arrays.asList(docs.scoreDocs), new Function<ScoreDoc, DocumentScore>(){

            @Override
            public DocumentScore apply(ScoreDoc doc2) {
                return new LuceneDocumentScore(doc2, highlighter, LuceneIndex.this);
            }
        });
    }

    @Override
    protected Iterable<? extends DocumentDistance> geoQuery(URI geoProperty, Point p, final URI units, double distance, String distanceVar, Var contextVar) throws MalformedQueryException, IOException {
        double degs = GeoUnits.toDegrees(distance, units);
        final String geoField = SearchFields.getPropertyField(geoProperty);
        SpatialStrategy strategy = this.getSpatialStrategyMapper().apply(geoField);
        final Circle boundingCircle = strategy.getSpatialContext().makeCircle(p, degs);
        Query q = strategy.makeQuery(new SpatialArgs(SpatialOperation.Intersects, boundingCircle));
        if (contextVar != null) {
            q = this.addContextTerm(q, (Resource)contextVar.getValue());
        }
        TopDocs docs = this.search(new CustomScoreQuery(q, new FunctionQuery(strategy.makeRecipDistanceValueSource(boundingCircle))));
        final boolean requireContext = contextVar != null && !contextVar.hasValue();
        return Iterables.transform(Arrays.asList(docs.scoreDocs), new Function<ScoreDoc, DocumentDistance>(){

            @Override
            public DocumentDistance apply(ScoreDoc doc2) {
                return new LuceneDocumentDistance(doc2, geoField, units, boundingCircle.getCenter(), requireContext, LuceneIndex.this);
            }
        });
    }

    private Query addContextTerm(Query q, Resource ctx) {
        BooleanQuery combinedQuery = new BooleanQuery();
        TermQuery idQuery = new TermQuery(new Term("context", SearchFields.getContextID(ctx)));
        combinedQuery.add(idQuery, ctx != null ? BooleanClause.Occur.MUST : BooleanClause.Occur.MUST_NOT);
        combinedQuery.add(q, BooleanClause.Occur.MUST);
        return combinedQuery;
    }

    @Override
    protected Iterable<? extends DocumentResult> geoRelationQuery(String relation, URI geoProperty, Shape shape, Var contextVar) throws MalformedQueryException, IOException {
        SpatialOperation op = this.toSpatialOp(relation);
        if (op == null) {
            return null;
        }
        String geoField = SearchFields.getPropertyField(geoProperty);
        SpatialStrategy strategy = this.getSpatialStrategyMapper().apply(geoField);
        Query q = strategy.makeQuery(new SpatialArgs(op, shape));
        if (contextVar != null) {
            q = this.addContextTerm(q, (Resource)contextVar.getValue());
        }
        TopDocs docs = this.search(q);
        final HashSet<String> fields = Sets.newHashSet("uri", geoField);
        if (contextVar != null && !contextVar.hasValue()) {
            fields.add("context");
        }
        return Iterables.transform(Arrays.asList(docs.scoreDocs), new Function<ScoreDoc, DocumentResult>(){

            @Override
            public DocumentResult apply(ScoreDoc doc2) {
                return new LuceneDocumentResult(doc2, LuceneIndex.this, fields);
            }
        });
    }

    private SpatialOperation toSpatialOp(String relation) {
        if (GEOF.SF_INTERSECTS.stringValue().equals(relation)) {
            return SpatialOperation.Intersects;
        }
        if (GEOF.SF_DISJOINT.stringValue().equals(relation)) {
            return SpatialOperation.IsDisjointTo;
        }
        if (GEOF.SF_EQUALS.stringValue().equals(relation)) {
            return SpatialOperation.IsEqualTo;
        }
        if (GEOF.SF_OVERLAPS.stringValue().equals(relation)) {
            return SpatialOperation.Overlaps;
        }
        if (GEOF.EH_COVERED_BY.stringValue().equals(relation)) {
            return SpatialOperation.IsWithin;
        }
        if (GEOF.EH_COVERS.stringValue().equals(relation)) {
            return SpatialOperation.Contains;
        }
        return null;
    }

    public synchronized Document getDocument(int docId, Set<String> fieldsToLoad) {
        try {
            return LuceneIndex.readDocument(this.getIndexReader(), docId, fieldsToLoad);
        }
        catch (CorruptIndexException e2) {
            this.logger.error("The index seems to be corrupted:", e2);
            return null;
        }
        catch (IOException e3) {
            this.logger.error("Could not read from index:", e3);
            return null;
        }
    }

    public synchronized String getSnippet(String fieldName, String text, Highlighter highlighter) {
        String snippet;
        try {
            TokenStream tokenStream = this.getAnalyzer().tokenStream(fieldName, new StringReader(text));
            snippet = highlighter.getBestFragments(tokenStream, text, 2, "...");
        }
        catch (Exception e2) {
            this.logger.error("Exception while getting snippet for field " + fieldName, e2);
            snippet = null;
        }
        return snippet;
    }

    public synchronized TopDocs search(Resource resource2, Query query) throws IOException {
        TermQuery idQuery = new TermQuery(new Term("uri", SearchFields.getResourceID(resource2)));
        BooleanQuery combinedQuery = new BooleanQuery();
        combinedQuery.add(idQuery, BooleanClause.Occur.MUST);
        combinedQuery.add(query, BooleanClause.Occur.MUST);
        return this.search(combinedQuery);
    }

    public synchronized TopDocs search(Query query) throws IOException {
        int nDocs = this.maxDocs > 0 ? this.maxDocs : Math.max(this.getIndexReader().numDocs(), 1);
        return this.getIndexSearcher().search(query, nDocs);
    }

    private QueryParser getQueryParser(URI propertyURI) {
        if (propertyURI == null) {
            return new QueryParser("text", this.queryAnalyzer);
        }
        return new QueryParser(SearchFields.getPropertyField(propertyURI), this.queryAnalyzer);
    }

    @Override
    public synchronized void clearContexts(Resource ... contexts) throws IOException {
        this.logger.debug("deleting contexts: {}", (Object)Arrays.toString(contexts));
        for (Resource context : contexts) {
            String contextString = SearchFields.getContextID(context);
            Term contextTerm = new Term("context", contextString);
            this.getIndexWriter().deleteDocuments(contextTerm);
        }
    }

    @Override
    public synchronized void clear() throws IOException {
        if (this.closed.get()) {
            throw new SailException("Index has been closed");
        }
        this.invalidateReaders();
        if (this.indexWriter != null) {
            this.indexWriter.close();
        }
        IndexWriterConfig indexWriterConfig = new IndexWriterConfig(this.analyzer);
        indexWriterConfig.setOpenMode(IndexWriterConfig.OpenMode.CREATE);
        this.indexWriter = new IndexWriter(this.directory, indexWriterConfig);
        this.indexWriter.close();
        this.indexWriter = null;
    }

    private static boolean isDeleted(IndexReader reader2, int docId) {
        if (reader2.hasDeletions()) {
            List<LeafReaderContext> leaves = reader2.leaves();
            int size = leaves.size();
            for (int i = 0; i < size; ++i) {
                boolean isDeleted;
                Bits liveDocs = leaves.get(i).reader().getLiveDocs();
                if (docId >= liveDocs.length()) continue;
                boolean bl = isDeleted = !liveDocs.get(docId);
                if (!isDeleted) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    private static Document readDocument(IndexReader reader2, int docId, Set<String> fieldsToLoad) throws IOException {
        DocumentStoredFieldVisitor visitor = new DocumentStoredFieldVisitor(fieldsToLoad);
        reader2.document(docId, visitor);
        return visitor.getDocument();
    }

    static {
        BooleanQuery.setMaxClauseCount(0x100000);
    }

    static class DocumentStoredFieldVisitor
    extends StoredFieldVisitor {
        private final Set<String> fieldsToLoad;
        private final Document document = new Document();

        DocumentStoredFieldVisitor(Set<String> fieldsToLoad) {
            this.fieldsToLoad = fieldsToLoad;
        }

        @Override
        public StoredFieldVisitor.Status needsField(FieldInfo fieldInfo) throws IOException {
            return this.fieldsToLoad == null || this.fieldsToLoad.contains(fieldInfo.name) ? StoredFieldVisitor.Status.YES : StoredFieldVisitor.Status.NO;
        }

        @Override
        public void stringField(FieldInfo fieldInfo, byte[] value) {
            String stringValue = new String(value, StandardCharsets.UTF_8);
            String name2 = fieldInfo.name;
            if ("id".equals(name2)) {
                LuceneIndex.addIDField(stringValue, this.document);
            } else if ("context".equals(name2)) {
                LuceneIndex.addContextField(stringValue, this.document);
            } else if ("uri".equals(name2)) {
                LuceneIndex.addResourceField(stringValue, this.document);
            } else if ("text".equals(name2)) {
                LuceneIndex.addTextField(stringValue, this.document);
            } else {
                LuceneIndex.addPredicateField(name2, stringValue, this.document);
            }
        }

        Document getDocument() {
            return this.document;
        }
    }
}

