/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.federation.optimizers;

import java.util.List;
import org.eclipse.rdf4j.query.algebra.BinaryTupleOperator;
import org.eclipse.rdf4j.query.algebra.EmptySet;
import org.eclipse.rdf4j.query.algebra.Join;
import org.eclipse.rdf4j.query.algebra.LeftJoin;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.SingletonSet;
import org.eclipse.rdf4j.query.algebra.Slice;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.algebra.helpers.AbstractQueryModelVisitor;
import org.eclipse.rdf4j.sail.federation.algebra.NaryJoin;

public class EvaluationStatistics {
    protected CardinalityCalculator calculator;
    private final Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getCardinality(TupleExpr expr) {
        Object object = this.lock;
        synchronized (object) {
            if (this.calculator == null) {
                this.calculator = this.createCardinalityCalculator();
            }
            expr.visit(this.calculator);
            return this.calculator.getCardinality();
        }
    }

    protected CardinalityCalculator createCardinalityCalculator() {
        return new CardinalityCalculator();
    }

    protected static class CardinalityCalculator
    extends AbstractQueryModelVisitor<RuntimeException> {
        protected double cardinality;

        protected CardinalityCalculator() {
        }

        public double getCardinality() {
            return this.cardinality;
        }

        @Override
        public void meet(EmptySet node2) {
            this.cardinality = 0.0;
        }

        @Override
        public void meet(SingletonSet node2) {
            this.cardinality = 1.0;
        }

        @Override
        public void meet(StatementPattern pattern) {
            this.cardinality = this.getCardinality(pattern);
        }

        @Override
        public void meet(Slice slice) {
            this.cardinality = 1.0;
        }

        protected double getCardinality(StatementPattern pattern) {
            List<Var> vars = pattern.getVarList();
            int constantVarCount = this.countConstantVars(vars);
            double unboundVarFactor = (double)(vars.size() - constantVarCount) / (double)vars.size();
            return Math.pow(1000.0, unboundVarFactor);
        }

        protected int countConstantVars(Iterable<Var> vars) {
            int constantVarCount = 0;
            for (Var var : vars) {
                if (!var.hasValue()) continue;
                ++constantVarCount;
            }
            return constantVarCount;
        }

        @Override
        public void meetOther(QueryModelNode node2) {
            if (node2 instanceof NaryJoin) {
                this.meetMultiJoin((NaryJoin)node2);
            } else {
                super.meetOther(node2);
            }
        }

        public void meetMultiJoin(NaryJoin node2) {
            double cost = 1.0;
            for (TupleExpr arg : node2.getArgs()) {
                arg.visit(this);
                cost *= this.cardinality;
            }
            this.cardinality = cost;
        }

        @Override
        public void meet(Join node2) {
            double cost = 1.0;
            for (TupleExpr arg : new TupleExpr[]{node2.getLeftArg(), node2.getRightArg()}) {
                arg.visit(this);
                cost *= this.cardinality;
            }
            this.cardinality = cost;
        }

        @Override
        public void meet(LeftJoin node2) {
            node2.getLeftArg().visit(this);
            double leftArgCost = this.cardinality;
            node2.getRightArg().visit(this);
            this.cardinality *= leftArgCost;
        }

        @Override
        protected void meetBinaryTupleOperator(BinaryTupleOperator node2) {
            double cost = 0.0;
            for (TupleExpr arg : new TupleExpr[]{node2.getLeftArg(), node2.getRightArg()}) {
                arg.visit(this);
                cost += this.cardinality;
            }
            this.cardinality = cost;
        }
    }
}

