/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.rio.turtle;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.rdf4j.common.io.IndentingWriter;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.datatypes.XMLDatatypeUtil;
import org.eclipse.rdf4j.model.impl.LinkedHashModel;
import org.eclipse.rdf4j.model.util.Literals;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.XMLSchema;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFWriter;
import org.eclipse.rdf4j.rio.helpers.AbstractRDFWriter;
import org.eclipse.rdf4j.rio.helpers.BasicParserSettings;
import org.eclipse.rdf4j.rio.helpers.BasicWriterSettings;
import org.eclipse.rdf4j.rio.turtle.TurtleUtil;

public class TurtleWriter
extends AbstractRDFWriter
implements RDFWriter {
    protected IndentingWriter writer;
    protected boolean writingStarted;
    protected boolean statementClosed;
    protected Resource lastWrittenSubject;
    protected IRI lastWrittenPredicate;
    protected Model prettyPrintModel = null;

    public TurtleWriter(OutputStream out) {
        this(new OutputStreamWriter(out, Charset.forName("UTF-8")));
    }

    public TurtleWriter(Writer writer2) {
        this.writer = new IndentingWriter(writer2);
        this.namespaceTable = new LinkedHashMap();
        this.writingStarted = false;
        this.statementClosed = true;
        this.lastWrittenSubject = null;
        this.lastWrittenPredicate = null;
    }

    @Override
    public RDFFormat getRDFFormat() {
        return RDFFormat.TURTLE;
    }

    @Override
    public void startRDF() throws RDFHandlerException {
        if (this.writingStarted) {
            throw new RuntimeException("Document writing has already started");
        }
        this.writingStarted = true;
        if (this.getWriterConfig().get(BasicWriterSettings.PRETTY_PRINT).booleanValue()) {
            this.prettyPrintModel = new LinkedHashModel();
        }
        try {
            for (Map.Entry entry : this.namespaceTable.entrySet()) {
                String name2 = (String)entry.getKey();
                String prefix = (String)entry.getValue();
                this.writeNamespace(prefix, name2);
                if (this.prettyPrintModel == null) continue;
                this.prettyPrintModel.setNamespace(prefix, name2);
            }
            if (!this.namespaceTable.isEmpty()) {
                this.writer.writeEOL();
            }
        }
        catch (IOException e2) {
            throw new RDFHandlerException(e2);
        }
    }

    @Override
    public void endRDF() throws RDFHandlerException {
        if (!this.writingStarted) {
            throw new RuntimeException("Document writing has not yet started");
        }
        try {
            if (this.prettyPrintModel != null) {
                for (Resource nextContext : this.prettyPrintModel.contexts()) {
                    for (Resource nextSubject : this.prettyPrintModel.subjects()) {
                        boolean canShortenSubjectBNode = true;
                        if (nextSubject instanceof BNode) {
                            if (this.prettyPrintModel.contains(null, null, (Value)nextSubject, new Resource[0])) {
                                canShortenSubjectBNode = false;
                            } else if (this.prettyPrintModel.filter(nextSubject, null, null, new Resource[0]).contexts().size() > 1) {
                                canShortenSubjectBNode = false;
                            } else if (this.prettyPrintModel.contains(null, null, null, nextSubject)) {
                                canShortenSubjectBNode = false;
                            }
                        }
                        for (IRI nextPredicate : this.prettyPrintModel.filter(nextSubject, null, null, nextContext).predicates()) {
                            Model nextObjects = this.prettyPrintModel.filter(nextSubject, nextPredicate, null, nextContext);
                            for (Statement nextSt : nextObjects) {
                                Value nextObject = nextSt.getObject();
                                boolean canShortenObjectBNode = true;
                                if (nextObject instanceof BNode) {
                                    if (this.prettyPrintModel.contains((Resource)((BNode)nextObject), null, null, new Resource[0])) {
                                        canShortenObjectBNode = false;
                                    } else if (this.prettyPrintModel.filter(null, null, nextObject, new Resource[0]).size() > 1) {
                                        canShortenObjectBNode = false;
                                    } else if (this.prettyPrintModel.filter(null, null, null, (BNode)nextObject).size() > 0) {
                                        canShortenObjectBNode = false;
                                    }
                                }
                                this.handleStatementInternal(nextSt, true, canShortenSubjectBNode, canShortenObjectBNode);
                            }
                        }
                    }
                }
            }
            this.closePreviousStatement();
            this.writer.flush();
        }
        catch (IOException e2) {
            throw new RDFHandlerException(e2);
        }
        finally {
            this.writingStarted = false;
        }
    }

    @Override
    public void handleNamespace(String prefix, String name2) throws RDFHandlerException {
        try {
            if (!this.namespaceTable.containsKey(name2)) {
                boolean isLegalPrefix;
                boolean bl = isLegalPrefix = prefix.length() == 0 || TurtleUtil.isPN_PREFIX(prefix);
                if (!isLegalPrefix || this.namespaceTable.containsValue(prefix)) {
                    if (prefix.length() == 0 || !isLegalPrefix) {
                        prefix = "ns";
                    }
                    int number = 1;
                    while (this.namespaceTable.containsValue(prefix + number)) {
                        ++number;
                    }
                    prefix = prefix + number;
                }
                this.namespaceTable.put(name2, prefix);
                if (this.writingStarted) {
                    this.closePreviousStatement();
                    this.writeNamespace(prefix, name2);
                }
            }
        }
        catch (IOException e2) {
            throw new RDFHandlerException(e2);
        }
    }

    @Override
    public void handleStatement(Statement st) throws RDFHandlerException {
        if (!this.writingStarted) {
            throw new RuntimeException("Document writing has not yet been started");
        }
        if (this.prettyPrintModel != null) {
            this.prettyPrintModel.add(st);
        } else {
            this.handleStatementInternal(st, false, false, false);
        }
    }

    protected void handleStatementInternal(Statement st, boolean endRDFCalled, boolean canShortenSubjectBNode, boolean canShortenObjectBNode) {
        if (this.prettyPrintModel != null && !endRDFCalled) {
            this.prettyPrintModel.add(st);
            return;
        }
        Resource subj = st.getSubject();
        IRI pred = st.getPredicate();
        Value obj = st.getObject();
        try {
            if (subj.equals(this.lastWrittenSubject)) {
                if (pred.equals(this.lastWrittenPredicate)) {
                    this.writer.write(" , ");
                } else {
                    this.writer.write(" ;");
                    this.writer.writeEOL();
                    this.writePredicate(pred);
                    this.writer.write(" ");
                    this.lastWrittenPredicate = pred;
                }
            } else {
                this.closePreviousStatement();
                this.writer.writeEOL();
                this.writeResource(subj, canShortenSubjectBNode);
                this.writer.write(" ");
                this.lastWrittenSubject = subj;
                this.writePredicate(pred);
                this.writer.write(" ");
                this.lastWrittenPredicate = pred;
                this.statementClosed = false;
                this.writer.increaseIndentation();
            }
            this.writeValue(obj, canShortenObjectBNode);
        }
        catch (IOException e2) {
            throw new RDFHandlerException(e2);
        }
    }

    @Override
    public void handleComment(String comment2) throws RDFHandlerException {
        try {
            this.closePreviousStatement();
            if (comment2.indexOf(13) != -1 || comment2.indexOf(10) != -1) {
                StringTokenizer st = new StringTokenizer(comment2, "\r\n");
                while (st.hasMoreTokens()) {
                    this.writeCommentLine(st.nextToken());
                }
            } else {
                this.writeCommentLine(comment2);
            }
        }
        catch (IOException e2) {
            throw new RDFHandlerException(e2);
        }
    }

    protected void writeCommentLine(String line) throws IOException {
        this.writer.write("# ");
        this.writer.write(line);
        this.writer.writeEOL();
    }

    protected void writeNamespace(String prefix, String name2) throws IOException {
        this.writer.write("@prefix ");
        this.writer.write(prefix);
        this.writer.write(": <");
        this.writer.write(TurtleUtil.encodeURIString(name2));
        this.writer.write("> .");
        this.writer.writeEOL();
    }

    protected void writePredicate(IRI predicate) throws IOException {
        if (predicate.equals(RDF.TYPE)) {
            this.writer.write("a");
        } else {
            this.writeURI(predicate);
        }
    }

    @Deprecated
    protected void writeValue(Value val2) throws IOException {
        this.writeValue(val2, false);
    }

    protected void writeValue(Value val2, boolean canShorten) throws IOException {
        if (val2 instanceof Resource) {
            this.writeResource((Resource)val2, canShorten);
        } else {
            this.writeLiteral((Literal)val2);
        }
    }

    @Deprecated
    protected void writeResource(Resource res) throws IOException {
        this.writeResource(res, false);
    }

    protected void writeResource(Resource res, boolean canShorten) throws IOException {
        if (res instanceof IRI) {
            this.writeURI((IRI)res);
        } else {
            this.writeBNode((BNode)res, canShorten);
        }
    }

    protected void writeURI(IRI uri) throws IOException {
        String uriString = uri.toString();
        String prefix = null;
        int splitIdx = TurtleUtil.findURISplitIndex(uriString);
        if (splitIdx > 0) {
            String namespace2 = uriString.substring(0, splitIdx);
            prefix = (String)this.namespaceTable.get(namespace2);
        }
        if (prefix != null) {
            this.writer.write(prefix);
            this.writer.write(":");
            this.writer.write(uriString.substring(splitIdx));
        } else {
            this.writer.write("<");
            this.writer.write(TurtleUtil.encodeURIString(uriString));
            this.writer.write(">");
        }
    }

    @Deprecated
    protected void writeBNode(BNode bNode) throws IOException {
        this.writeBNode(bNode, false);
    }

    protected void writeBNode(BNode bNode, boolean canShorten) throws IOException {
        if (canShorten) {
            this.writer.write("[]");
            return;
        }
        this.writer.write("_:");
        String id = bNode.getID();
        if (id.isEmpty()) {
            if (this.getWriterConfig().get(BasicParserSettings.PRESERVE_BNODE_IDS).booleanValue()) {
                throw new IOException("Cannot consistently write blank nodes with empty internal identifiers");
            }
            this.writer.write("genid-hash-");
            this.writer.write(Integer.toHexString(System.identityHashCode(bNode)));
        } else {
            if (!TurtleUtil.isNameStartChar(id.charAt(0))) {
                this.writer.write("genid-start-");
                this.writer.write(Integer.toHexString(id.charAt(0)));
            } else {
                this.writer.write(id.charAt(0));
            }
            for (int i = 1; i < id.length() - 1; ++i) {
                if (TurtleUtil.isPN_CHARS(id.charAt(i))) {
                    this.writer.write(id.charAt(i));
                    continue;
                }
                this.writer.write(Integer.toHexString(id.charAt(i)));
            }
            if (id.length() > 1) {
                if (!TurtleUtil.isNameEndChar(id.charAt(id.length() - 1))) {
                    this.writer.write(Integer.toHexString(id.charAt(id.length() - 1)));
                } else {
                    this.writer.write(id.charAt(id.length() - 1));
                }
            }
        }
    }

    protected void writeLiteral(Literal lit) throws IOException {
        String label = lit.getLabel();
        IRI datatype = lit.getDatatype();
        if (this.getWriterConfig().get(BasicWriterSettings.PRETTY_PRINT).booleanValue() && (XMLSchema.INTEGER.equals(datatype) || XMLSchema.DECIMAL.equals(datatype) || XMLSchema.DOUBLE.equals(datatype) || XMLSchema.BOOLEAN.equals(datatype))) {
            try {
                this.writer.write(XMLDatatypeUtil.normalize(label, datatype));
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (label.indexOf(10) != -1 || label.indexOf(13) != -1 || label.indexOf(9) != -1) {
            this.writer.write("\"\"\"");
            this.writer.write(TurtleUtil.encodeLongString(label));
            this.writer.write("\"\"\"");
        } else {
            this.writer.write("\"");
            this.writer.write(TurtleUtil.encodeString(label));
            this.writer.write("\"");
        }
        if (Literals.isLanguageLiteral(lit)) {
            this.writer.write("@");
            this.writer.write(lit.getLanguage().get());
        } else if (!XMLSchema.STRING.equals(datatype) || !this.xsdStringToPlainLiteral()) {
            this.writer.write("^^");
            this.writeURI(datatype);
        }
    }

    protected void closePreviousStatement() throws IOException {
        if (!this.statementClosed) {
            this.writer.write(" .");
            this.writer.writeEOL();
            this.writer.decreaseIndentation();
            this.statementClosed = true;
            this.lastWrittenSubject = null;
            this.lastWrittenPredicate = null;
        }
    }

    private boolean xsdStringToPlainLiteral() {
        return this.getWriterConfig().get(BasicWriterSettings.XSD_STRING_TO_PLAIN_LITERAL);
    }
}

