/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.rio.jsonld;

import com.github.jsonldjava.core.JsonLdTripleCallback;
import com.github.jsonldjava.core.RDFDataset;
import java.util.List;
import java.util.Map;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.LinkedHashModel;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.rio.ParseErrorListener;
import org.eclipse.rdf4j.rio.ParserConfig;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.helpers.ParseErrorLogger;
import org.eclipse.rdf4j.rio.helpers.RDFParserHelper;
import org.eclipse.rdf4j.rio.helpers.StatementCollector;

class JSONLDInternalTripleCallback
implements JsonLdTripleCallback {
    private ValueFactory vf;
    private RDFHandler handler;
    private ParserConfig parserConfig;
    private final ParseErrorListener parseErrorListener;

    public JSONLDInternalTripleCallback() {
        this(new StatementCollector(new LinkedHashModel()));
    }

    public JSONLDInternalTripleCallback(RDFHandler nextHandler) {
        this(nextHandler, SimpleValueFactory.getInstance());
    }

    public JSONLDInternalTripleCallback(RDFHandler nextHandler, ValueFactory vf) {
        this(nextHandler, vf, new ParserConfig(), new ParseErrorLogger());
    }

    public JSONLDInternalTripleCallback(RDFHandler nextHandler, ValueFactory vf, ParserConfig parserConfig, ParseErrorListener parseErrorListener) {
        this.handler = nextHandler;
        this.vf = vf;
        this.parserConfig = parserConfig;
        this.parseErrorListener = parseErrorListener;
    }

    private void triple(String s, String p, String o, String graph) {
        if (s == null || p == null || o == null) {
            return;
        }
        Statement result = graph == null ? this.vf.createStatement(this.createResource(s), this.vf.createIRI(p), (Value)this.createResource(o)) : this.vf.createStatement(this.createResource(s), this.vf.createIRI(p), (Value)this.createResource(o), this.createResource(graph));
        if (this.handler != null) {
            try {
                this.handler.handleStatement(result);
            }
            catch (RDFHandlerException e2) {
                throw new RuntimeException(e2);
            }
        }
    }

    private Resource createResource(String resource2) {
        if (resource2.equals("_:")) {
            return this.vf.createBNode();
        }
        if (resource2.startsWith("_:")) {
            return this.vf.createBNode(resource2.substring(2));
        }
        return this.vf.createIRI(resource2);
    }

    private void triple(String s, String p, String value, String datatype, String language, String graph) {
        Literal object;
        if (s == null || p == null || value == null) {
            return;
        }
        Resource subject = this.createResource(s);
        IRI predicate = this.vf.createIRI(p);
        IRI datatypeURI = datatype == null ? null : this.vf.createIRI(datatype);
        try {
            object = RDFParserHelper.createLiteral(value, language, datatypeURI, this.getParserConfig(), this.getParserErrorListener(), this.getValueFactory());
        }
        catch (RDFParseException e2) {
            throw new RuntimeException(e2);
        }
        Statement result = graph == null ? this.vf.createStatement(subject, predicate, (Value)object) : this.vf.createStatement(subject, predicate, (Value)object, this.createResource(graph));
        if (this.handler != null) {
            try {
                this.handler.handleStatement(result);
            }
            catch (RDFHandlerException e3) {
                throw new RuntimeException(e3);
            }
        }
    }

    public ParseErrorListener getParserErrorListener() {
        return this.parseErrorListener;
    }

    public RDFHandler getHandler() {
        return this.handler;
    }

    public void setHandler(RDFHandler handler) {
        this.handler = handler;
    }

    public ParserConfig getParserConfig() {
        return this.parserConfig;
    }

    public void setParserConfig(ParserConfig parserConfig) {
        this.parserConfig = parserConfig;
    }

    public ValueFactory getValueFactory() {
        return this.vf;
    }

    public void setValueFactory(ValueFactory vf) {
        this.vf = vf;
    }

    @Override
    public Object call(RDFDataset dataset) {
        if (this.handler != null) {
            try {
                this.handler.startRDF();
                for (Map.Entry<String, String> nextNamespace : dataset.getNamespaces().entrySet()) {
                    this.handler.handleNamespace(nextNamespace.getKey(), nextNamespace.getValue());
                }
            }
            catch (RDFHandlerException e2) {
                throw new RuntimeException("Could not handle start of RDF", e2);
            }
        }
        for (String graphName : dataset.keySet()) {
            List<RDFDataset.Quad> quads = dataset.getQuads(graphName);
            if ("@default".equals(graphName)) {
                graphName = null;
            }
            for (RDFDataset.Quad quad : quads) {
                if (quad.getObject().isLiteral()) {
                    this.triple(quad.getSubject().getValue(), quad.getPredicate().getValue(), quad.getObject().getValue(), quad.getObject().getDatatype(), quad.getObject().getLanguage(), graphName);
                    continue;
                }
                this.triple(quad.getSubject().getValue(), quad.getPredicate().getValue(), quad.getObject().getValue(), graphName);
            }
        }
        if (this.handler != null) {
            try {
                this.handler.endRDF();
            }
            catch (RDFHandlerException e3) {
                throw new RuntimeException("Could not handle end of RDF", e3);
            }
        }
        return this.getHandler();
    }
}

