/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.repository.manager;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.http.client.HttpClient;
import org.eclipse.rdf4j.http.client.HttpClientDependent;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.config.RepositoryConfig;
import org.eclipse.rdf4j.repository.config.RepositoryConfigException;
import org.eclipse.rdf4j.repository.config.RepositoryConfigUtil;
import org.eclipse.rdf4j.repository.manager.RepositoryInfo;
import org.eclipse.rdf4j.repository.sail.config.ProxyRepositorySchema;
import org.eclipse.rdf4j.repository.sail.config.RepositoryResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RepositoryManager
implements RepositoryResolver,
HttpClientDependent {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected Map<String, Repository> initializedRepositories;

    public RepositoryManager() {
        this(new HashMap<String, Repository>());
    }

    public RepositoryManager(Map<String, Repository> initializedRepositories) {
        this.setInitializedRepositories(initializedRepositories);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInitialized() {
        Map<String, Repository> map2 = this.initializedRepositories;
        synchronized (map2) {
            Repository repo = this.initializedRepositories.get("SYSTEM");
            return repo != null && repo.isInitialized();
        }
    }

    @Override
    public abstract HttpClient getHttpClient();

    @Override
    public abstract void setHttpClient(HttpClient var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() throws RepositoryException {
        Repository systemRepository = this.createSystemRepository();
        Map<String, Repository> map2 = this.initializedRepositories;
        synchronized (map2) {
            this.initializedRepositories.put("SYSTEM", systemRepository);
        }
    }

    protected abstract Repository createSystemRepository() throws RepositoryException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Repository getSystemRepository() {
        if (!this.isInitialized()) {
            throw new IllegalStateException("Repository Manager is not initialized");
        }
        Map<String, Repository> map2 = this.initializedRepositories;
        synchronized (map2) {
            return this.initializedRepositories.get("SYSTEM");
        }
    }

    public String getNewRepositoryID(String baseName) throws RepositoryException, RepositoryConfigException {
        if (baseName != null) {
            baseName = baseName.trim();
            int length = baseName.length();
            StringBuilder buffer = new StringBuilder(length);
            for (char c : baseName.toCharArray()) {
                if (Character.isLetter(c) || Character.isDigit(c) || c == '-' || c == '_' || c == '.') {
                    buffer.append(Character.toLowerCase(c));
                    continue;
                }
                if (c == '\"' || c == '\'') continue;
                buffer.append('-');
            }
            baseName = buffer.toString();
        }
        if (baseName != null && baseName.length() > 0 && !this.hasRepositoryConfig(baseName)) {
            return baseName;
        }
        if (baseName == null || baseName.length() == 0) {
            baseName = "repository-";
        } else if (!baseName.endsWith("-")) {
            baseName = baseName + "-";
        }
        int index2 = 2;
        while (this.hasRepositoryConfig(baseName + index2)) {
            ++index2;
        }
        return baseName + index2;
    }

    public Set<String> getRepositoryIDs() throws RepositoryException {
        return RepositoryConfigUtil.getRepositoryIDs(this.getSystemRepository());
    }

    public boolean hasRepositoryConfig(String repositoryID) throws RepositoryException, RepositoryConfigException {
        return RepositoryConfigUtil.hasRepositoryConfig(this.getSystemRepository(), repositoryID);
    }

    public RepositoryConfig getRepositoryConfig(String repositoryID) throws RepositoryConfigException, RepositoryException {
        return RepositoryConfigUtil.getRepositoryConfig(this.getSystemRepository(), repositoryID);
    }

    public void addRepositoryConfig(RepositoryConfig config) throws RepositoryException, RepositoryConfigException {
        RepositoryConfigUtil.updateRepositoryConfigs(this.getSystemRepository(), config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public boolean removeRepositoryConfig(String repositoryID) throws RepositoryException, RepositoryConfigException {
        this.logger.debug("Removing repository configuration for {}.", (Object)repositoryID);
        boolean isRemoved = false;
        Map<String, Repository> map2 = this.initializedRepositories;
        synchronized (map2) {
            isRemoved = RepositoryConfigUtil.removeRepositoryConfigs(this.getSystemRepository(), repositoryID);
            if (isRemoved) {
                this.logger.debug("Shutdown repository {} after removal of configuration.", (Object)repositoryID);
                Repository repository2 = this.initializedRepositories.remove(repositoryID);
                if (repository2 != null && repository2.isInitialized()) {
                    repository2.shutDown();
                }
                try {
                    this.cleanUpRepository(repositoryID);
                }
                catch (IOException e2) {
                    throw new RepositoryException("Unable to clean up resources for removed repository " + repositoryID, e2);
                }
            }
        }
        return isRemoved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSafeToRemove(String repositoryID) throws RepositoryException {
        try (RepositoryConnection connection = this.getSystemRepository().getConnection();){
            boolean bl = !connection.hasStatement(null, ProxyRepositorySchema.PROXIED_ID, (Value)connection.getValueFactory().createLiteral(repositoryID), false, new Resource[0]);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeRepository(String repositoryID) throws RepositoryException, RepositoryConfigException {
        this.logger.debug("Removing repository {}.", (Object)repositoryID);
        boolean isRemoved = false;
        Map<String, Repository> map2 = this.initializedRepositories;
        synchronized (map2) {
            isRemoved = RepositoryConfigUtil.removeRepositoryConfigs(this.getSystemRepository(), repositoryID);
            if (isRemoved) {
                this.logger.debug("Shutdown repository {} after removal of configuration.", (Object)repositoryID);
                Repository repository2 = this.initializedRepositories.remove(repositoryID);
                if (repository2 != null && repository2.isInitialized()) {
                    repository2.shutDown();
                }
                try {
                    this.cleanUpRepository(repositoryID);
                }
                catch (IOException e2) {
                    throw new RepositoryException("Unable to clean up resources for removed repository " + repositoryID, e2);
                }
            }
        }
        return isRemoved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Repository getRepository(String identity2) throws RepositoryConfigException, RepositoryException {
        Map<String, Repository> map2 = this.initializedRepositories;
        synchronized (map2) {
            this.updateInitializedRepositories();
            Repository result = this.initializedRepositories.get(identity2);
            if (result != null && !result.isInitialized()) {
                this.initializedRepositories.remove(result);
                result = null;
            }
            if (result == null && (result = this.createRepository(identity2)) != null) {
                this.initializedRepositories.put(identity2, result);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getInitializedRepositoryIDs() {
        Map<String, Repository> map2 = this.initializedRepositories;
        synchronized (map2) {
            this.updateInitializedRepositories();
            return new HashSet<String>(this.initializedRepositories.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Repository> getInitializedRepositories() {
        Map<String, Repository> map2 = this.initializedRepositories;
        synchronized (map2) {
            this.updateInitializedRepositories();
            return new ArrayList<Repository>(this.initializedRepositories.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Repository getInitializedRepository(String repositoryID) {
        Map<String, Repository> map2 = this.initializedRepositories;
        synchronized (map2) {
            this.updateInitializedRepositories();
            return this.initializedRepositories.get(repositoryID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Repository removeInitializedRepository(String repositoryID) {
        Map<String, Repository> map2 = this.initializedRepositories;
        synchronized (map2) {
            this.updateInitializedRepositories();
            return this.initializedRepositories.remove(repositoryID);
        }
    }

    protected void setInitializedRepositories(Map<String, Repository> nextInitializedRepositories) {
        this.initializedRepositories = nextInitializedRepositories;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateInitializedRepositories() {
        Map<String, Repository> map2 = this.initializedRepositories;
        synchronized (map2) {
            Iterator<Repository> iter = this.initializedRepositories.values().iterator();
            while (iter.hasNext()) {
                Repository next2 = iter.next();
                if (next2.isInitialized()) continue;
                iter.remove();
                try {
                    next2.shutDown();
                }
                catch (RepositoryException repositoryException) {}
            }
        }
    }

    public Collection<Repository> getAllRepositories() throws RepositoryConfigException, RepositoryException {
        Set<String> idSet = this.getRepositoryIDs();
        ArrayList<Repository> result = new ArrayList<Repository>(idSet.size());
        for (String id : idSet) {
            result.add(this.getRepository(id));
        }
        return result;
    }

    protected abstract Repository createRepository(String var1) throws RepositoryConfigException, RepositoryException;

    public abstract RepositoryInfo getRepositoryInfo(String var1) throws RepositoryException;

    public Collection<RepositoryInfo> getAllRepositoryInfos() throws RepositoryException {
        return this.getAllRepositoryInfos(false);
    }

    public Collection<RepositoryInfo> getAllUserRepositoryInfos() throws RepositoryException {
        return this.getAllRepositoryInfos(true);
    }

    public abstract Collection<RepositoryInfo> getAllRepositoryInfos(boolean var1) throws RepositoryException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        this.logger.debug("Refreshing repository information in manager...");
        try (RepositoryConnection cleanupCon = this.getSystemRepository().getConnection();){
            Map<String, Repository> map2 = this.initializedRepositories;
            synchronized (map2) {
                Iterator<Map.Entry<String, Repository>> iter = this.initializedRepositories.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry<String, Repository> entry = iter.next();
                    String repositoryID = entry.getKey();
                    Repository repository2 = entry.getValue();
                    if ("SYSTEM".equals(repositoryID)) continue;
                    iter.remove();
                    this.refreshRepository(cleanupCon, repositoryID, repository2);
                }
            }
        }
        catch (RepositoryException re) {
            this.logger.error("Failed to refresh repositories", re);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutDown() {
        Map<String, Repository> map2 = this.initializedRepositories;
        synchronized (map2) {
            this.updateInitializedRepositories();
            for (Repository repository2 : this.initializedRepositories.values()) {
                try {
                    if (!repository2.isInitialized()) continue;
                    repository2.shutDown();
                }
                catch (RepositoryException e2) {
                    this.logger.error("Repository shut down failed", e2);
                }
            }
            this.initializedRepositories.clear();
        }
    }

    void refreshRepository(RepositoryConnection con, String repositoryID, Repository repository2) {
        this.logger.debug("Refreshing repository {}...", (Object)repositoryID);
        try {
            if (repository2.isInitialized()) {
                repository2.shutDown();
            }
        }
        catch (RepositoryException e2) {
            this.logger.error("Failed to shut down repository", e2);
        }
        this.cleanupIfRemoved(con, repositoryID);
    }

    void cleanupIfRemoved(RepositoryConnection con, String repositoryID) {
        try {
            if (RepositoryConfigUtil.getContext(con, repositoryID) == null) {
                this.logger.debug("Cleaning up repository {}, its configuration has been removed", (Object)repositoryID);
                this.cleanUpRepository(repositoryID);
            } else {
                this.logger.debug("Repository {} should not be cleaned up.", (Object)repositoryID);
            }
        }
        catch (RepositoryException e2) {
            this.logger.error("Failed to process repository configuration changes", e2);
        }
        catch (RepositoryConfigException e3) {
            this.logger.warn("Unable to determine if configuration for {} is still present in the system repository", (Object)repositoryID);
        }
        catch (IOException e4) {
            this.logger.warn("Unable to remove data dir for removed repository {} ", (Object)repositoryID);
        }
    }

    protected abstract void cleanUpRepository(String var1) throws IOException;

    public abstract URL getLocation() throws MalformedURLException;
}

