/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.impl;

import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.algebra.And;
import org.eclipse.rdf4j.query.algebra.Filter;
import org.eclipse.rdf4j.query.algebra.Or;
import org.eclipse.rdf4j.query.algebra.SameTerm;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.Union;
import org.eclipse.rdf4j.query.algebra.ValueExpr;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryOptimizer;
import org.eclipse.rdf4j.query.algebra.helpers.AbstractQueryModelVisitor;

public class DisjunctiveConstraintOptimizer
implements QueryOptimizer {
    @Override
    public void optimize(TupleExpr tupleExpr, Dataset dataset, BindingSet bindings) {
        tupleExpr.visit(new OrSameTermOptimizer());
    }

    protected static class OrSameTermOptimizer
    extends AbstractQueryModelVisitor<RuntimeException> {
        protected OrSameTermOptimizer() {
        }

        @Override
        public void meet(Filter filter2) {
            if (filter2.getCondition() instanceof Or && this.containsSameTerm(filter2.getCondition())) {
                Or orNode = (Or)filter2.getCondition();
                TupleExpr filterArg = filter2.getArg();
                ValueExpr leftConstraint = orNode.getLeftArg();
                ValueExpr rightConstraint = orNode.getRightArg();
                filter2.replaceWith(filterArg);
                TupleExpr node2 = this.findNotFilter(filterArg);
                Filter leftFilter = new Filter(node2.clone(), leftConstraint);
                Filter rightFilter = new Filter(node2.clone(), rightConstraint);
                Union union2 = new Union(leftFilter, rightFilter);
                node2.replaceWith(union2);
                filter2.getParentNode().visit(this);
            } else {
                super.meet(filter2);
            }
        }

        private TupleExpr findNotFilter(TupleExpr node2) {
            if (node2 instanceof Filter) {
                return this.findNotFilter(((Filter)node2).getArg());
            }
            return node2;
        }

        private boolean containsSameTerm(ValueExpr node2) {
            if (node2 instanceof SameTerm) {
                return true;
            }
            if (node2 instanceof Or) {
                Or or2 = (Or)node2;
                boolean left2 = this.containsSameTerm(or2.getLeftArg());
                return left2 || this.containsSameTerm(or2.getRightArg());
            }
            if (node2 instanceof And) {
                And and2 = (And)node2;
                boolean left3 = this.containsSameTerm(and2.getLeftArg());
                return left3 || this.containsSameTerm(and2.getRightArg());
            }
            return false;
        }
    }
}

