/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra;

import org.eclipse.rdf4j.query.algebra.AbstractQueryModelNode;
import org.eclipse.rdf4j.query.algebra.ExtensionElem;
import org.eclipse.rdf4j.query.algebra.QueryModelVisitor;

public class ProjectionElem
extends AbstractQueryModelNode {
    private String sourceName;
    private String targetName;
    private boolean aggregateOperatorInExpression;
    private ExtensionElem sourceExpression;

    public ProjectionElem() {
    }

    public ProjectionElem(String name2) {
        this(name2, name2);
    }

    public ProjectionElem(String sourceName, String targetName) {
        this.setSourceName(sourceName);
        this.setTargetName(targetName);
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public void setSourceName(String sourceName) {
        assert (sourceName != null) : "sourceName must not be null";
        this.sourceName = sourceName;
    }

    public String getTargetName() {
        return this.targetName;
    }

    public void setTargetName(String targetName) {
        assert (targetName != null) : "targetName must not be null";
        this.targetName = targetName;
    }

    @Override
    public <X extends Exception> void visit(QueryModelVisitor<X> visitor) throws X {
        visitor.meet(this);
    }

    @Override
    public String getSignature() {
        StringBuilder sb = new StringBuilder(32);
        sb.append(super.getSignature());
        sb.append(" \"");
        sb.append(this.sourceName);
        sb.append("\"");
        if (!this.sourceName.equals(this.targetName)) {
            sb.append(" AS \"").append(this.targetName).append("\"");
        }
        return sb.toString();
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof ProjectionElem) {
            ProjectionElem o = (ProjectionElem)other;
            return this.sourceName.equals(o.getSourceName()) && this.targetName.equals(o.getTargetName());
        }
        return false;
    }

    public int hashCode() {
        return this.targetName.hashCode();
    }

    @Override
    public ProjectionElem clone() {
        return (ProjectionElem)super.clone();
    }

    public boolean hasAggregateOperatorInExpression() {
        return this.aggregateOperatorInExpression;
    }

    public void setAggregateOperatorInExpression(boolean aggregateOperatorInExpression) {
        this.aggregateOperatorInExpression = aggregateOperatorInExpression;
    }

    public ExtensionElem getSourceExpression() {
        return this.sourceExpression;
    }

    public void setSourceExpression(ExtensionElem sourceExpression) {
        this.sourceExpression = sourceExpression;
    }
}

