/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra;

import org.eclipse.rdf4j.query.algebra.BinaryValueOperator;
import org.eclipse.rdf4j.query.algebra.QueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.ValueExpr;

public class MathExpr
extends BinaryValueOperator {
    private MathOp operator;

    public MathExpr() {
    }

    public MathExpr(ValueExpr leftArg, ValueExpr rightArg, MathOp operator) {
        super(leftArg, rightArg);
        this.setOperator(operator);
    }

    public MathOp getOperator() {
        return this.operator;
    }

    public void setOperator(MathOp operator) {
        assert (operator != null) : "operator must not be null";
        this.operator = operator;
    }

    @Override
    public <X extends Exception> void visit(QueryModelVisitor<X> visitor) throws X {
        visitor.meet(this);
    }

    @Override
    public String getSignature() {
        return super.getSignature() + " (" + this.operator.getSymbol() + ")";
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof MathExpr && super.equals(other)) {
            MathExpr o = (MathExpr)other;
            return this.operator.equals((Object)o.getOperator());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.operator.hashCode();
    }

    @Override
    public MathExpr clone() {
        return (MathExpr)super.clone();
    }

    public static enum MathOp {
        PLUS("+"),
        MINUS("-"),
        MULTIPLY("*"),
        DIVIDE("/");

        private String symbol;

        private MathOp(String symbol2) {
            this.symbol = symbol2;
        }

        public String getSymbol() {
            return this.symbol;
        }
    }
}

