/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.lucene.spin;

import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.sail.NotifyingSailConnection;
import org.eclipse.rdf4j.sail.SailConnectionListener;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.helpers.NotifyingSailConnectionWrapper;
import org.eclipse.rdf4j.sail.lucene.LuceneSailBuffer;
import org.eclipse.rdf4j.sail.lucene.SearchIndex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LuceneSpinSailConnection
extends NotifyingSailConnectionWrapper {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final SearchIndex luceneIndex;
    private final LuceneSailBuffer buffer = new LuceneSailBuffer();
    protected final SailConnectionListener connectionListener = new SailConnectionListener(){

        @Override
        public void statementAdded(Statement statement) {
            if (statement.getObject() instanceof Literal) {
                if (statement == null) {
                    return;
                }
                Literal literal = (Literal)statement.getObject();
                if (LuceneSpinSailConnection.this.luceneIndex.accept(literal)) {
                    LuceneSpinSailConnection.this.buffer.add(statement);
                }
            }
        }

        @Override
        public void statementRemoved(Statement statement) {
            if (statement.getObject() instanceof Literal) {
                if (statement == null) {
                    return;
                }
                Literal literal = (Literal)statement.getObject();
                if (LuceneSpinSailConnection.this.luceneIndex.accept(literal)) {
                    LuceneSpinSailConnection.this.buffer.remove(statement);
                }
            }
        }
    };
    private final AtomicBoolean closed = new AtomicBoolean(false);

    public LuceneSpinSailConnection(NotifyingSailConnection wrappedConnection, SearchIndex luceneIndex) {
        super(wrappedConnection);
        this.luceneIndex = luceneIndex;
        wrappedConnection.addConnectionListener(this.connectionListener);
    }

    @Override
    public synchronized void addStatement(Resource arg0, IRI arg1, Value arg2, Resource ... arg3) throws SailException {
        super.addStatement(arg0, arg1, arg2, arg3);
    }

    @Override
    public void close() throws SailException {
        if (this.closed.compareAndSet(false, true)) {
            try {
                super.close();
            }
            finally {
                try {
                    this.luceneIndex.endReading();
                }
                catch (IOException e2) {
                    this.logger.warn("could not close IndexReader or IndexSearcher " + e2, e2);
                }
            }
        }
    }

    @Override
    public synchronized void clear(Resource ... arg0) throws SailException {
        this.getWrappedConnection().removeConnectionListener(this.connectionListener);
        try {
            super.clear(arg0);
            this.buffer.clear(arg0);
        }
        finally {
            this.getWrappedConnection().addConnectionListener(this.connectionListener);
        }
    }

    @Override
    public void begin() throws SailException {
        super.begin();
        this.buffer.reset();
        try {
            this.luceneIndex.begin();
        }
        catch (IOException e2) {
            throw new SailException(e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() throws SailException {
        super.commit();
        this.logger.debug("Committing Lucene transaction with {} operations.", (Object)this.buffer.operations().size());
        try {
            try {
                this.buffer.optimize();
                Iterator<LuceneSailBuffer.Operation> i = this.buffer.operations().iterator();
                while (i.hasNext()) {
                    LuceneSailBuffer.Operation op = i.next();
                    if (op instanceof LuceneSailBuffer.AddRemoveOperation) {
                        LuceneSailBuffer.AddRemoveOperation addremove = (LuceneSailBuffer.AddRemoveOperation)op;
                        this.addRemoveStatements(addremove.getAdded(), addremove.getRemoved());
                    } else if (op instanceof LuceneSailBuffer.ClearContextOperation) {
                        this.clearContexts(((LuceneSailBuffer.ClearContextOperation)op).getContexts());
                    } else if (op instanceof LuceneSailBuffer.ClearOperation) {
                        this.logger.debug("clearing index...");
                        this.luceneIndex.clear();
                    } else {
                        throw new RuntimeException("Cannot interpret operation " + op + " of type " + op.getClass().getName());
                    }
                    i.remove();
                }
            }
            catch (Exception e2) {
                this.logger.error("Committing operations in lucenesail, encountered exception " + e2 + ". Only some operations were stored, " + this.buffer.operations().size() + " operations are discarded. Lucene Index is now corrupt.", e2);
                throw new SailException(e2);
            }
        }
        finally {
            this.buffer.reset();
        }
    }

    private void addRemoveStatements(Set<Statement> toAdd, Set<Statement> toRemove) throws IOException {
        this.logger.debug("indexing {}/removing {} statements...", (Object)toAdd.size(), (Object)toRemove.size());
        this.luceneIndex.begin();
        try {
            this.luceneIndex.addRemoveStatements(toAdd, toRemove);
            this.luceneIndex.commit();
        }
        catch (IOException e2) {
            this.logger.error("Rolling back", e2);
            this.luceneIndex.rollback();
            throw e2;
        }
    }

    private void clearContexts(Resource ... contexts) throws IOException {
        this.logger.debug("clearing contexts...");
        this.luceneIndex.begin();
        try {
            this.luceneIndex.clearContexts(contexts);
            this.luceneIndex.commit();
        }
        catch (IOException e2) {
            this.logger.error("Rolling back", e2);
            this.luceneIndex.rollback();
            throw e2;
        }
    }

    @Override
    public synchronized void removeStatements(Resource arg0, IRI arg1, Value arg2, Resource ... arg3) throws SailException {
        super.removeStatements(arg0, arg1, arg2, arg3);
    }

    @Override
    public void rollback() throws SailException {
        super.rollback();
        this.buffer.reset();
        try {
            this.luceneIndex.rollback();
        }
        catch (IOException e2) {
            throw new SailException(e2);
        }
    }
}

