/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.io.IOException;
import org.apache.lucene.index.FilterLeafReader;
import org.apache.lucene.index.FilteredTermsEnum;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;

public final class NumericUtils {
    public static final int PRECISION_STEP_DEFAULT = 16;
    public static final int PRECISION_STEP_DEFAULT_32 = 8;
    public static final byte SHIFT_START_LONG = 32;
    public static final int BUF_SIZE_LONG = 11;
    public static final byte SHIFT_START_INT = 96;
    public static final int BUF_SIZE_INT = 6;

    private NumericUtils() {
    }

    public static void longToPrefixCoded(long val2, int shift, BytesRefBuilder bytes2) {
        NumericUtils.longToPrefixCodedBytes(val2, shift, bytes2);
    }

    public static void intToPrefixCoded(int val2, int shift, BytesRefBuilder bytes2) {
        NumericUtils.intToPrefixCodedBytes(val2, shift, bytes2);
    }

    public static void longToPrefixCodedBytes(long val2, int shift, BytesRefBuilder bytes2) {
        if ((shift & 0xFFFFFFC0) != 0) {
            throw new IllegalArgumentException("Illegal shift value, must be 0..63; got shift=" + shift);
        }
        int nChars = ((63 - shift) * 37 >> 8) + 1;
        bytes2.setLength(nChars + 1);
        bytes2.grow(11);
        bytes2.setByteAt(0, (byte)(32 + shift));
        long sortableBits = val2 ^ Long.MIN_VALUE;
        sortableBits >>>= shift;
        while (nChars > 0) {
            bytes2.setByteAt(nChars--, (byte)(sortableBits & 0x7FL));
            sortableBits >>>= 7;
        }
    }

    public static void intToPrefixCodedBytes(int val2, int shift, BytesRefBuilder bytes2) {
        if ((shift & 0xFFFFFFE0) != 0) {
            throw new IllegalArgumentException("Illegal shift value, must be 0..31; got shift=" + shift);
        }
        int nChars = ((31 - shift) * 37 >> 8) + 1;
        bytes2.setLength(nChars + 1);
        bytes2.grow(11);
        bytes2.setByteAt(0, (byte)(96 + shift));
        int sortableBits = val2 ^ Integer.MIN_VALUE;
        sortableBits >>>= shift;
        while (nChars > 0) {
            bytes2.setByteAt(nChars--, (byte)(sortableBits & 0x7F));
            sortableBits >>>= 7;
        }
    }

    public static int getPrefixCodedLongShift(BytesRef val2) {
        int shift = val2.bytes[val2.offset] - 32;
        if (shift > 63 || shift < 0) {
            throw new NumberFormatException("Invalid shift value (" + shift + ") in prefixCoded bytes (is encoded value really an INT?)");
        }
        return shift;
    }

    public static int getPrefixCodedIntShift(BytesRef val2) {
        int shift = val2.bytes[val2.offset] - 96;
        if (shift > 31 || shift < 0) {
            throw new NumberFormatException("Invalid shift value in prefixCoded bytes (is encoded value really an INT?)");
        }
        return shift;
    }

    public static long prefixCodedToLong(BytesRef val2) {
        long sortableBits = 0L;
        int limit = val2.offset + val2.length;
        for (int i = val2.offset + 1; i < limit; ++i) {
            sortableBits <<= 7;
            byte b = val2.bytes[i];
            if (b < 0) {
                throw new NumberFormatException("Invalid prefixCoded numerical value representation (byte " + Integer.toHexString(b & 0xFF) + " at position " + (i - val2.offset) + " is invalid)");
            }
            sortableBits |= (long)b;
        }
        return sortableBits << NumericUtils.getPrefixCodedLongShift(val2) ^ Long.MIN_VALUE;
    }

    public static int prefixCodedToInt(BytesRef val2) {
        int sortableBits = 0;
        int limit = val2.offset + val2.length;
        for (int i = val2.offset + 1; i < limit; ++i) {
            sortableBits <<= 7;
            byte b = val2.bytes[i];
            if (b < 0) {
                throw new NumberFormatException("Invalid prefixCoded numerical value representation (byte " + Integer.toHexString(b & 0xFF) + " at position " + (i - val2.offset) + " is invalid)");
            }
            sortableBits |= b;
        }
        return sortableBits << NumericUtils.getPrefixCodedIntShift(val2) ^ Integer.MIN_VALUE;
    }

    public static long doubleToSortableLong(double val2) {
        return NumericUtils.sortableDoubleBits(Double.doubleToLongBits(val2));
    }

    public static double sortableLongToDouble(long val2) {
        return Double.longBitsToDouble(NumericUtils.sortableDoubleBits(val2));
    }

    public static int floatToSortableInt(float val2) {
        return NumericUtils.sortableFloatBits(Float.floatToIntBits(val2));
    }

    public static float sortableIntToFloat(int val2) {
        return Float.intBitsToFloat(NumericUtils.sortableFloatBits(val2));
    }

    public static long sortableDoubleBits(long bits) {
        return bits ^ bits >> 63 & Long.MAX_VALUE;
    }

    public static int sortableFloatBits(int bits) {
        return bits ^ bits >> 31 & Integer.MAX_VALUE;
    }

    public static void splitLongRange(LongRangeBuilder builder, int precisionStep, long minBound, long maxBound) {
        NumericUtils.splitRange(builder, 64, precisionStep, minBound, maxBound);
    }

    public static void splitIntRange(IntRangeBuilder builder, int precisionStep, int minBound, int maxBound) {
        NumericUtils.splitRange(builder, 32, precisionStep, minBound, maxBound);
    }

    private static void splitRange(Object builder, int valSize, int precisionStep, long minBound, long maxBound) {
        if (precisionStep < 1) {
            throw new IllegalArgumentException("precisionStep must be >=1");
        }
        if (minBound > maxBound) {
            return;
        }
        int shift = 0;
        while (true) {
            boolean upperWrapped;
            long diff2 = 1L << shift + precisionStep;
            long mask = (1L << precisionStep) - 1L << shift;
            boolean hasLower = (minBound & mask) != 0L;
            boolean hasUpper = (maxBound & mask) != mask;
            long nextMinBound = (hasLower ? minBound + diff2 : minBound) & (mask ^ 0xFFFFFFFFFFFFFFFFL);
            long nextMaxBound = (hasUpper ? maxBound - diff2 : maxBound) & (mask ^ 0xFFFFFFFFFFFFFFFFL);
            boolean lowerWrapped = nextMinBound < minBound;
            boolean bl = upperWrapped = nextMaxBound > maxBound;
            if (shift + precisionStep >= valSize || nextMinBound > nextMaxBound || lowerWrapped || upperWrapped) break;
            if (hasLower) {
                NumericUtils.addRange(builder, valSize, minBound, minBound | mask, shift);
            }
            if (hasUpper) {
                NumericUtils.addRange(builder, valSize, maxBound & (mask ^ 0xFFFFFFFFFFFFFFFFL), maxBound, shift);
            }
            minBound = nextMinBound;
            maxBound = nextMaxBound;
            shift += precisionStep;
        }
        NumericUtils.addRange(builder, valSize, minBound, maxBound, shift);
    }

    private static void addRange(Object builder, int valSize, long minBound, long maxBound, int shift) {
        maxBound |= (1L << shift) - 1L;
        switch (valSize) {
            case 64: {
                ((LongRangeBuilder)builder).addRange(minBound, maxBound, shift);
                break;
            }
            case 32: {
                ((IntRangeBuilder)builder).addRange((int)minBound, (int)maxBound, shift);
                break;
            }
            default: {
                throw new IllegalArgumentException("valSize must be 32 or 64.");
            }
        }
    }

    public static TermsEnum filterPrefixCodedLongs(TermsEnum termsEnum) {
        return new SeekingNumericFilteredTermsEnum(termsEnum){

            @Override
            protected FilteredTermsEnum.AcceptStatus accept(BytesRef term) {
                return NumericUtils.getPrefixCodedLongShift(term) == 0 ? FilteredTermsEnum.AcceptStatus.YES : FilteredTermsEnum.AcceptStatus.END;
            }
        };
    }

    public static TermsEnum filterPrefixCodedInts(TermsEnum termsEnum) {
        return new SeekingNumericFilteredTermsEnum(termsEnum){

            @Override
            protected FilteredTermsEnum.AcceptStatus accept(BytesRef term) {
                return NumericUtils.getPrefixCodedIntShift(term) == 0 ? FilteredTermsEnum.AcceptStatus.YES : FilteredTermsEnum.AcceptStatus.END;
            }
        };
    }

    private static Terms intTerms(Terms terms) {
        return new FilterLeafReader.FilterTerms(terms){

            @Override
            public TermsEnum iterator() throws IOException {
                return NumericUtils.filterPrefixCodedInts(this.in.iterator());
            }
        };
    }

    private static Terms longTerms(Terms terms) {
        return new FilterLeafReader.FilterTerms(terms){

            @Override
            public TermsEnum iterator() throws IOException {
                return NumericUtils.filterPrefixCodedLongs(this.in.iterator());
            }
        };
    }

    public static int getMinInt(Terms terms) throws IOException {
        return NumericUtils.prefixCodedToInt(terms.getMin());
    }

    public static int getMaxInt(Terms terms) throws IOException {
        return NumericUtils.prefixCodedToInt(NumericUtils.intTerms(terms).getMax());
    }

    public static long getMinLong(Terms terms) throws IOException {
        return NumericUtils.prefixCodedToLong(terms.getMin());
    }

    public static long getMaxLong(Terms terms) throws IOException {
        return NumericUtils.prefixCodedToLong(NumericUtils.longTerms(terms).getMax());
    }

    private static abstract class SeekingNumericFilteredTermsEnum
    extends FilteredTermsEnum {
        public SeekingNumericFilteredTermsEnum(TermsEnum tenum) {
            super(tenum, false);
        }

        @Override
        public TermsEnum.SeekStatus seekCeil(BytesRef term) throws IOException {
            TermsEnum.SeekStatus status = this.tenum.seekCeil(term);
            if (status == TermsEnum.SeekStatus.END) {
                return TermsEnum.SeekStatus.END;
            }
            this.actualTerm = this.tenum.term();
            if (this.accept(this.actualTerm) == FilteredTermsEnum.AcceptStatus.YES) {
                return status;
            }
            return TermsEnum.SeekStatus.END;
        }
    }

    public static abstract class IntRangeBuilder {
        public void addRange(BytesRef minPrefixCoded, BytesRef maxPrefixCoded) {
            throw new UnsupportedOperationException();
        }

        public void addRange(int min2, int max2, int shift) {
            BytesRefBuilder minBytes = new BytesRefBuilder();
            BytesRefBuilder maxBytes = new BytesRefBuilder();
            NumericUtils.intToPrefixCodedBytes(min2, shift, minBytes);
            NumericUtils.intToPrefixCodedBytes(max2, shift, maxBytes);
            this.addRange(minBytes.get(), maxBytes.get());
        }
    }

    public static abstract class LongRangeBuilder {
        public void addRange(BytesRef minPrefixCoded, BytesRef maxPrefixCoded) {
            throw new UnsupportedOperationException();
        }

        public void addRange(long min2, long max2, int shift) {
            BytesRefBuilder minBytes = new BytesRefBuilder();
            BytesRefBuilder maxBytes = new BytesRefBuilder();
            NumericUtils.longToPrefixCodedBytes(min2, shift, minBytes);
            NumericUtils.longToPrefixCodedBytes(max2, shift, maxBytes);
            this.addRange(minBytes.get(), maxBytes.get());
        }
    }
}

