/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.util.Arrays;
import java.util.Comparator;
import org.apache.lucene.util.StringHelper;
import org.apache.lucene.util.UnicodeUtil;

public final class BytesRef
implements Comparable<BytesRef>,
Cloneable {
    public static final byte[] EMPTY_BYTES = new byte[0];
    public byte[] bytes;
    public int offset;
    public int length;
    private static final Comparator<BytesRef> utf8SortedAsUnicodeSortOrder = new UTF8SortedAsUnicodeComparator();
    @Deprecated
    private static final Comparator<BytesRef> utf8SortedAsUTF16SortOrder = new UTF8SortedAsUTF16Comparator();

    public BytesRef() {
        this(EMPTY_BYTES);
    }

    public BytesRef(byte[] bytes2, int offset, int length) {
        this.bytes = bytes2;
        this.offset = offset;
        this.length = length;
        assert (this.isValid());
    }

    public BytesRef(byte[] bytes2) {
        this(bytes2, 0, bytes2.length);
    }

    public BytesRef(int capacity) {
        this.bytes = new byte[capacity];
    }

    public BytesRef(CharSequence text) {
        this(new byte[3 * text.length()]);
        this.length = UnicodeUtil.UTF16toUTF8(text, 0, text.length(), this.bytes);
    }

    public boolean bytesEquals(BytesRef other) {
        assert (other != null);
        if (this.length == other.length) {
            int otherUpto = other.offset;
            byte[] otherBytes = other.bytes;
            int end = this.offset + this.length;
            int upto = this.offset;
            while (upto < end) {
                if (this.bytes[upto] != otherBytes[otherUpto]) {
                    return false;
                }
                ++upto;
                ++otherUpto;
            }
            return true;
        }
        return false;
    }

    public BytesRef clone() {
        return new BytesRef(this.bytes, this.offset, this.length);
    }

    public int hashCode() {
        return StringHelper.murmurhash3_x86_32(this, StringHelper.GOOD_FAST_HASH_SEED);
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other instanceof BytesRef) {
            return this.bytesEquals((BytesRef)other);
        }
        return false;
    }

    public String utf8ToString() {
        char[] ref2 = new char[this.length];
        int len = UnicodeUtil.UTF8toUTF16(this.bytes, this.offset, this.length, ref2);
        return new String(ref2, 0, len);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        int end = this.offset + this.length;
        for (int i = this.offset; i < end; ++i) {
            if (i > this.offset) {
                sb.append(' ');
            }
            sb.append(Integer.toHexString(this.bytes[i] & 0xFF));
        }
        sb.append(']');
        return sb.toString();
    }

    @Override
    public int compareTo(BytesRef other) {
        return utf8SortedAsUnicodeSortOrder.compare(this, other);
    }

    public static Comparator<BytesRef> getUTF8SortedAsUnicodeComparator() {
        return utf8SortedAsUnicodeSortOrder;
    }

    @Deprecated
    public static Comparator<BytesRef> getUTF8SortedAsUTF16Comparator() {
        return utf8SortedAsUTF16SortOrder;
    }

    public static BytesRef deepCopyOf(BytesRef other) {
        BytesRef copy2 = new BytesRef();
        copy2.bytes = Arrays.copyOfRange(other.bytes, other.offset, other.offset + other.length);
        copy2.offset = 0;
        copy2.length = other.length;
        return copy2;
    }

    public boolean isValid() {
        if (this.bytes == null) {
            throw new IllegalStateException("bytes is null");
        }
        if (this.length < 0) {
            throw new IllegalStateException("length is negative: " + this.length);
        }
        if (this.length > this.bytes.length) {
            throw new IllegalStateException("length is out of bounds: " + this.length + ",bytes.length=" + this.bytes.length);
        }
        if (this.offset < 0) {
            throw new IllegalStateException("offset is negative: " + this.offset);
        }
        if (this.offset > this.bytes.length) {
            throw new IllegalStateException("offset out of bounds: " + this.offset + ",bytes.length=" + this.bytes.length);
        }
        if (this.offset + this.length < 0) {
            throw new IllegalStateException("offset+length is negative: offset=" + this.offset + ",length=" + this.length);
        }
        if (this.offset + this.length > this.bytes.length) {
            throw new IllegalStateException("offset+length out of bounds: offset=" + this.offset + ",length=" + this.length + ",bytes.length=" + this.bytes.length);
        }
        return true;
    }

    @Deprecated
    private static class UTF8SortedAsUTF16Comparator
    implements Comparator<BytesRef> {
        private UTF8SortedAsUTF16Comparator() {
        }

        @Override
        public int compare(BytesRef a, BytesRef b) {
            byte[] aBytes = a.bytes;
            int aUpto = a.offset;
            byte[] bBytes = b.bytes;
            int bUpto = b.offset;
            int aStop = a.length < b.length ? aUpto + a.length : aUpto + b.length;
            while (aUpto < aStop) {
                int bByte;
                int aByte;
                if ((aByte = aBytes[aUpto++] & 0xFF) == (bByte = bBytes[bUpto++] & 0xFF)) continue;
                if (aByte >= 238 && bByte >= 238) {
                    if ((aByte & 0xFE) == 238) {
                        aByte += 14;
                    }
                    if ((bByte & 0xFE) == 238) {
                        bByte += 14;
                    }
                }
                return aByte - bByte;
            }
            return a.length - b.length;
        }
    }

    private static class UTF8SortedAsUnicodeComparator
    implements Comparator<BytesRef> {
        private UTF8SortedAsUnicodeComparator() {
        }

        @Override
        public int compare(BytesRef a, BytesRef b) {
            byte[] aBytes = a.bytes;
            int aUpto = a.offset;
            byte[] bBytes = b.bytes;
            int bUpto = b.offset;
            int aStop = aUpto + Math.min(a.length, b.length);
            while (aUpto < aStop) {
                int bByte;
                int aByte;
                int diff2;
                if ((diff2 = (aByte = aBytes[aUpto++] & 0xFF) - (bByte = bBytes[bUpto++] & 0xFF)) == 0) continue;
                return diff2;
            }
            return a.length - b.length;
        }
    }
}

