/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.spatial4j.geo3d;

import org.apache.lucene.spatial.spatial4j.geo3d.Bounds;
import org.apache.lucene.spatial.spatial4j.geo3d.GeoBBox;
import org.apache.lucene.spatial.spatial4j.geo3d.GeoBBoxBase;
import org.apache.lucene.spatial.spatial4j.geo3d.GeoBBoxFactory;
import org.apache.lucene.spatial.spatial4j.geo3d.GeoPoint;
import org.apache.lucene.spatial.spatial4j.geo3d.GeoShape;
import org.apache.lucene.spatial.spatial4j.geo3d.Membership;
import org.apache.lucene.spatial.spatial4j.geo3d.Plane;
import org.apache.lucene.spatial.spatial4j.geo3d.SidedPlane;
import org.apache.lucene.spatial.spatial4j.geo3d.Vector;

public class GeoWideNorthRectangle
extends GeoBBoxBase {
    public final double bottomLat;
    public final double leftLon;
    public final double rightLon;
    public final double cosMiddleLat;
    public final GeoPoint LRHC;
    public final GeoPoint LLHC;
    public final SidedPlane bottomPlane;
    public final SidedPlane leftPlane;
    public final SidedPlane rightPlane;
    public final GeoPoint[] bottomPlanePoints;
    public final GeoPoint[] leftPlanePoints;
    public final GeoPoint[] rightPlanePoints;
    public final GeoPoint centerPoint;
    public final EitherBound eitherBound;
    public final GeoPoint[] edgePoints = new GeoPoint[]{NORTH_POLE};

    public GeoWideNorthRectangle(double bottomLat, double leftLon, double rightLon) {
        if (bottomLat > 1.5707963267948966 || bottomLat < -1.5707963267948966) {
            throw new IllegalArgumentException("Bottom latitude out of range");
        }
        if (leftLon < -Math.PI || leftLon > Math.PI) {
            throw new IllegalArgumentException("Left longitude out of range");
        }
        if (rightLon < -Math.PI || rightLon > Math.PI) {
            throw new IllegalArgumentException("Right longitude out of range");
        }
        double extent = rightLon - leftLon;
        if (extent < 0.0) {
            extent += Math.PI * 2;
        }
        if (extent < Math.PI) {
            throw new IllegalArgumentException("Width of rectangle too small");
        }
        this.bottomLat = bottomLat;
        this.leftLon = leftLon;
        this.rightLon = rightLon;
        double sinBottomLat = Math.sin(bottomLat);
        double cosBottomLat = Math.cos(bottomLat);
        double sinLeftLon = Math.sin(leftLon);
        double cosLeftLon = Math.cos(leftLon);
        double sinRightLon = Math.sin(rightLon);
        double cosRightLon = Math.cos(rightLon);
        this.LRHC = new GeoPoint(sinBottomLat, sinRightLon, cosBottomLat, cosRightLon);
        this.LLHC = new GeoPoint(sinBottomLat, sinLeftLon, cosBottomLat, cosLeftLon);
        double middleLat = (1.5707963267948966 + bottomLat) * 0.5;
        double sinMiddleLat = Math.sin(middleLat);
        this.cosMiddleLat = Math.cos(middleLat);
        while (leftLon > rightLon) {
            rightLon += Math.PI * 2;
        }
        double middleLon = (leftLon + rightLon) * 0.5;
        double sinMiddleLon = Math.sin(middleLon);
        double cosMiddleLon = Math.cos(middleLon);
        this.centerPoint = new GeoPoint(sinMiddleLat, sinMiddleLon, this.cosMiddleLat, cosMiddleLon);
        this.bottomPlane = new SidedPlane((Vector)this.centerPoint, sinBottomLat);
        this.leftPlane = new SidedPlane((Vector)this.centerPoint, cosLeftLon, sinLeftLon);
        this.rightPlane = new SidedPlane((Vector)this.centerPoint, cosRightLon, sinRightLon);
        this.bottomPlanePoints = new GeoPoint[]{this.LLHC, this.LRHC};
        this.leftPlanePoints = new GeoPoint[]{NORTH_POLE, this.LLHC};
        this.rightPlanePoints = new GeoPoint[]{NORTH_POLE, this.LRHC};
        this.eitherBound = new EitherBound();
    }

    @Override
    public GeoBBox expand(double angle) {
        double newTopLat = 1.5707963267948966;
        double newBottomLat = this.bottomLat - angle;
        double currentLonSpan = this.rightLon - this.leftLon;
        if (currentLonSpan < 0.0) {
            currentLonSpan += Math.PI * 2;
        }
        double newLeftLon = this.leftLon - angle;
        double newRightLon = this.rightLon + angle;
        if (currentLonSpan + 2.0 * angle >= Math.PI * 2) {
            newLeftLon = -Math.PI;
            newRightLon = Math.PI;
        }
        return GeoBBoxFactory.makeGeoBBox(1.5707963267948966, newBottomLat, newLeftLon, newRightLon);
    }

    @Override
    public boolean isWithin(Vector point) {
        return this.bottomPlane.isWithin(point) && (this.leftPlane.isWithin(point) || this.rightPlane.isWithin(point));
    }

    @Override
    public boolean isWithin(double x, double y, double z) {
        return this.bottomPlane.isWithin(x, y, z) && (this.leftPlane.isWithin(x, y, z) || this.rightPlane.isWithin(x, y, z));
    }

    @Override
    public double getRadius() {
        double centerAngle = (this.rightLon - (this.rightLon + this.leftLon) * 0.5) * this.cosMiddleLat;
        double bottomAngle = this.centerPoint.arcDistance(this.LLHC);
        return Math.max(centerAngle, bottomAngle);
    }

    @Override
    public GeoPoint getCenter() {
        return this.centerPoint;
    }

    @Override
    public GeoPoint[] getEdgePoints() {
        return this.edgePoints;
    }

    @Override
    public boolean intersects(Plane p, GeoPoint[] notablePoints, Membership ... bounds) {
        return p.intersects(this.bottomPlane, notablePoints, this.bottomPlanePoints, bounds, this.eitherBound) || p.intersects(this.leftPlane, notablePoints, this.leftPlanePoints, bounds, this.bottomPlane) || p.intersects(this.rightPlane, notablePoints, this.rightPlanePoints, bounds, this.bottomPlane);
    }

    @Override
    public Bounds getBounds(Bounds bounds) {
        if (bounds == null) {
            bounds = new Bounds();
        }
        bounds.noTopLatitudeBound().addLatitudeZone(this.bottomLat).addLongitudeSlice(this.leftLon, this.rightLon);
        return bounds;
    }

    @Override
    public int getRelationship(GeoShape path2) {
        int insideRectangle = this.isShapeInsideBBox(path2);
        if (insideRectangle == 1) {
            return 2;
        }
        boolean insideShape = path2.isWithin(NORTH_POLE);
        if (insideRectangle == 0 && insideShape) {
            return 2;
        }
        if (path2.intersects(this.bottomPlane, this.bottomPlanePoints, this.eitherBound) || path2.intersects(this.leftPlane, this.leftPlanePoints, this.bottomPlane) || path2.intersects(this.rightPlane, this.rightPlanePoints, this.bottomPlane)) {
            return 2;
        }
        if (insideRectangle == 0) {
            return 1;
        }
        if (insideShape) {
            return 0;
        }
        return 3;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof GeoWideNorthRectangle)) {
            return false;
        }
        GeoWideNorthRectangle other = (GeoWideNorthRectangle)o;
        return other.LLHC.equals(this.LLHC) && other.LRHC.equals(this.LRHC);
    }

    public int hashCode() {
        int result = this.LLHC.hashCode();
        result = 31 * result + this.LRHC.hashCode();
        return result;
    }

    public String toString() {
        return "GeoWideNorthRectangle: {bottomlat=" + this.bottomLat + "(" + this.bottomLat * 180.0 / Math.PI + "), leftlon=" + this.leftLon + "(" + this.leftLon * 180.0 / Math.PI + "), rightlon=" + this.rightLon + "(" + this.rightLon * 180.0 / Math.PI + ")}";
    }

    protected class EitherBound
    implements Membership {
        @Override
        public boolean isWithin(Vector v) {
            return GeoWideNorthRectangle.this.leftPlane.isWithin(v) || GeoWideNorthRectangle.this.rightPlane.isWithin(v);
        }

        @Override
        public boolean isWithin(double x, double y, double z) {
            return GeoWideNorthRectangle.this.leftPlane.isWithin(x, y, z) || GeoWideNorthRectangle.this.rightPlane.isWithin(x, y, z);
        }
    }
}

