/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.spatial4j.geo3d;

import org.apache.lucene.spatial.spatial4j.geo3d.Bounds;
import org.apache.lucene.spatial.spatial4j.geo3d.GeoBaseExtendedShape;
import org.apache.lucene.spatial.spatial4j.geo3d.GeoDistanceShape;
import org.apache.lucene.spatial.spatial4j.geo3d.GeoPoint;
import org.apache.lucene.spatial.spatial4j.geo3d.GeoSizeable;
import org.apache.lucene.spatial.spatial4j.geo3d.Membership;
import org.apache.lucene.spatial.spatial4j.geo3d.Plane;
import org.apache.lucene.spatial.spatial4j.geo3d.SidedPlane;
import org.apache.lucene.spatial.spatial4j.geo3d.Vector;

public class GeoCircle
extends GeoBaseExtendedShape
implements GeoDistanceShape,
GeoSizeable {
    public final GeoPoint center;
    public final double cutoffAngle;
    public final double cutoffNormalDistance;
    public final double cutoffLinearDistance;
    public final SidedPlane circlePlane;
    public final GeoPoint[] edgePoints;
    public static final GeoPoint[] circlePoints = new GeoPoint[0];

    public GeoCircle(double lat, double lon, double cutoffAngle) {
        if (lat < -1.5707963267948966 || lat > 1.5707963267948966) {
            throw new IllegalArgumentException("Latitude out of bounds");
        }
        if (lon < -Math.PI || lon > Math.PI) {
            throw new IllegalArgumentException("Longitude out of bounds");
        }
        if (cutoffAngle <= 0.0 || cutoffAngle > Math.PI) {
            throw new IllegalArgumentException("Cutoff angle out of bounds");
        }
        double sinAngle = Math.sin(cutoffAngle);
        double cosAngle = Math.cos(cutoffAngle);
        this.center = new GeoPoint(lat, lon);
        this.cutoffNormalDistance = sinAngle;
        double xDiff = 1.0 - cosAngle;
        this.cutoffLinearDistance = Math.sqrt(xDiff * xDiff + sinAngle * sinAngle);
        this.cutoffAngle = cutoffAngle;
        this.circlePlane = new SidedPlane((Vector)this.center, (Vector)this.center, -cosAngle);
        if (cutoffAngle == Math.PI) {
            this.edgePoints = new GeoPoint[0];
        } else {
            double newLat = lat + cutoffAngle;
            double newLon = lon;
            if (newLat > 1.5707963267948966) {
                newLat = Math.PI - newLat;
                newLon += Math.PI;
            }
            while (newLon > Math.PI) {
                newLon -= Math.PI * 2;
            }
            GeoPoint edgePoint = new GeoPoint(newLat, newLon);
            this.edgePoints = new GeoPoint[]{edgePoint};
        }
    }

    @Override
    public double getRadius() {
        return this.cutoffAngle;
    }

    @Override
    public GeoPoint getCenter() {
        return this.center;
    }

    @Override
    public double computeNormalDistance(GeoPoint point) {
        double normalDistance = this.center.normalDistance(point);
        if (normalDistance > this.cutoffNormalDistance) {
            return Double.MAX_VALUE;
        }
        return normalDistance;
    }

    @Override
    public double computeNormalDistance(double x, double y, double z) {
        double normalDistance = this.center.normalDistance(x, y, z);
        if (normalDistance > this.cutoffNormalDistance) {
            return Double.MAX_VALUE;
        }
        return normalDistance;
    }

    @Override
    public double computeSquaredNormalDistance(GeoPoint point) {
        double normalDistanceSquared = this.center.normalDistanceSquared(point);
        if (normalDistanceSquared > this.cutoffNormalDistance * this.cutoffNormalDistance) {
            return Double.MAX_VALUE;
        }
        return normalDistanceSquared;
    }

    @Override
    public double computeSquaredNormalDistance(double x, double y, double z) {
        double normalDistanceSquared = this.center.normalDistanceSquared(x, y, z);
        if (normalDistanceSquared > this.cutoffNormalDistance * this.cutoffNormalDistance) {
            return Double.MAX_VALUE;
        }
        return normalDistanceSquared;
    }

    @Override
    public double computeLinearDistance(GeoPoint point) {
        double linearDistance = this.center.linearDistance(point);
        if (linearDistance > this.cutoffLinearDistance) {
            return Double.MAX_VALUE;
        }
        return linearDistance;
    }

    @Override
    public double computeLinearDistance(double x, double y, double z) {
        double linearDistance = this.center.linearDistance(x, y, z);
        if (linearDistance > this.cutoffLinearDistance) {
            return Double.MAX_VALUE;
        }
        return linearDistance;
    }

    @Override
    public double computeSquaredLinearDistance(GeoPoint point) {
        double linearDistanceSquared = this.center.linearDistanceSquared(point);
        if (linearDistanceSquared > this.cutoffLinearDistance * this.cutoffLinearDistance) {
            return Double.MAX_VALUE;
        }
        return linearDistanceSquared;
    }

    @Override
    public double computeSquaredLinearDistance(double x, double y, double z) {
        double linearDistanceSquared = this.center.linearDistanceSquared(x, y, z);
        if (linearDistanceSquared > this.cutoffLinearDistance * this.cutoffLinearDistance) {
            return Double.MAX_VALUE;
        }
        return linearDistanceSquared;
    }

    @Override
    public double computeArcDistance(GeoPoint point) {
        double dist = this.center.arcDistance(point);
        if (dist > this.cutoffAngle) {
            return Double.MAX_VALUE;
        }
        return dist;
    }

    @Override
    public boolean isWithin(Vector point) {
        return this.circlePlane.isWithin(point);
    }

    @Override
    public boolean isWithin(double x, double y, double z) {
        return this.circlePlane.isWithin(x, y, z);
    }

    @Override
    public GeoPoint[] getEdgePoints() {
        return this.edgePoints;
    }

    @Override
    public boolean intersects(Plane p, GeoPoint[] notablePoints, Membership ... bounds) {
        return this.circlePlane.intersects(p, notablePoints, circlePoints, bounds, new Membership[0]);
    }

    @Override
    public Bounds getBounds(Bounds bounds) {
        bounds = super.getBounds(bounds);
        bounds.addPoint(this.center);
        this.circlePlane.recordBounds(bounds, new Membership[0]);
        return bounds;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof GeoCircle)) {
            return false;
        }
        GeoCircle other = (GeoCircle)o;
        return other.center.equals(this.center) && other.cutoffAngle == this.cutoffAngle;
    }

    public int hashCode() {
        int result = this.center.hashCode();
        long temp = Double.doubleToLongBits(this.cutoffAngle);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public String toString() {
        return "GeoCircle: {center=" + this.center + ", radius=" + this.cutoffAngle + "(" + this.cutoffAngle * 180.0 / Math.PI + ")}";
    }
}

