/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.bbox;

import com.spatial4j.core.shape.Rectangle;
import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.spatial.bbox.BBoxStrategy;
import org.apache.lucene.util.Bits;

class BBoxValueSource
extends ValueSource {
    private final BBoxStrategy strategy;

    public BBoxValueSource(BBoxStrategy strategy) {
        this.strategy = strategy;
    }

    @Override
    public String description() {
        return "bboxShape(" + this.strategy.getFieldName() + ")";
    }

    @Override
    public FunctionValues getValues(Map context, LeafReaderContext readerContext) throws IOException {
        LeafReader reader2 = readerContext.reader();
        final NumericDocValues minX = DocValues.getNumeric(reader2, this.strategy.field_minX);
        final NumericDocValues minY = DocValues.getNumeric(reader2, this.strategy.field_minY);
        final NumericDocValues maxX = DocValues.getNumeric(reader2, this.strategy.field_maxX);
        final NumericDocValues maxY = DocValues.getNumeric(reader2, this.strategy.field_maxY);
        final Bits validBits = DocValues.getDocsWithField(reader2, this.strategy.field_minX);
        final Rectangle rect = this.strategy.getSpatialContext().makeRectangle(0.0, 0.0, 0.0, 0.0);
        return new FunctionValues(){

            @Override
            public Object objectVal(int doc2) {
                if (!validBits.get(doc2)) {
                    return null;
                }
                rect.reset(Double.longBitsToDouble(minX.get(doc2)), Double.longBitsToDouble(maxX.get(doc2)), Double.longBitsToDouble(minY.get(doc2)), Double.longBitsToDouble(maxY.get(doc2)));
                return rect;
            }

            @Override
            public String strVal(int doc2) {
                Object v = this.objectVal(doc2);
                return v == null ? null : v.toString();
            }

            @Override
            public boolean exists(int doc2) {
                return validBits.get(doc2);
            }

            @Override
            public Explanation explain(int doc2) {
                return Explanation.match(Float.NaN, this.toString(doc2), new Explanation[0]);
            }

            @Override
            public String toString(int doc2) {
                return BBoxValueSource.this.description() + '=' + this.strVal(doc2);
            }
        };
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BBoxValueSource that = (BBoxValueSource)o;
        return this.strategy.equals(that.strategy);
    }

    @Override
    public int hashCode() {
        return this.strategy.hashCode();
    }
}

