/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.BitsFilteredDocIdSet;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.FilterCache;
import org.apache.lucene.search.FilterCachingPolicy;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Accountables;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.RoaringDocIdSet;

@Deprecated
public class LRUFilterCache
implements FilterCache,
Accountable {
    static final long FILTER_DEFAULT_RAM_BYTES_USED = 216L;
    static final long HASHTABLE_RAM_BYTES_PER_ENTRY = 2 * RamUsageEstimator.NUM_BYTES_OBJECT_REF * 2;
    static final long LINKED_HASHTABLE_RAM_BYTES_PER_ENTRY = HASHTABLE_RAM_BYTES_PER_ENTRY + (long)(2 * RamUsageEstimator.NUM_BYTES_OBJECT_REF);
    private final int maxSize;
    private final long maxRamBytesUsed;
    private final Map<Filter, Filter> uniqueFilters;
    private final Set<Filter> mostRecentlyUsedFilters;
    private final Map<Object, LeafCache> cache;
    private volatile long ramBytesUsed;
    private volatile long hitCount;
    private volatile long missCount;
    private volatile long cacheCount;
    private volatile long cacheSize;

    public LRUFilterCache(int maxSize, long maxRamBytesUsed) {
        this.maxSize = maxSize;
        this.maxRamBytesUsed = maxRamBytesUsed;
        this.uniqueFilters = new LinkedHashMap<Filter, Filter>(16, 0.75f, true);
        this.mostRecentlyUsedFilters = this.uniqueFilters.keySet();
        this.cache = new IdentityHashMap<Object, LeafCache>();
        this.ramBytesUsed = 0L;
    }

    protected void onHit(Object readerCoreKey, Filter filter2) {
        ++this.hitCount;
    }

    protected void onMiss(Object readerCoreKey, Filter filter2) {
        assert (filter2 != null);
        ++this.missCount;
    }

    protected void onFilterCache(Filter filter2, long ramBytesUsed) {
        this.ramBytesUsed += ramBytesUsed;
    }

    protected void onFilterEviction(Filter filter2, long ramBytesUsed) {
        this.ramBytesUsed -= ramBytesUsed;
    }

    protected void onDocIdSetCache(Object readerCoreKey, long ramBytesUsed) {
        ++this.cacheSize;
        ++this.cacheCount;
        this.ramBytesUsed += ramBytesUsed;
    }

    protected void onDocIdSetEviction(Object readerCoreKey, int numEntries, long sumRamBytesUsed) {
        this.ramBytesUsed -= sumRamBytesUsed;
        this.cacheSize -= (long)numEntries;
    }

    protected void onClear() {
        this.ramBytesUsed = 0L;
        this.cacheSize = 0L;
    }

    boolean requiresEviction() {
        int size = this.mostRecentlyUsedFilters.size();
        if (size == 0) {
            return false;
        }
        return size > this.maxSize || this.ramBytesUsed() > this.maxRamBytesUsed;
    }

    synchronized DocIdSet get(Filter filter2, LeafReaderContext context) {
        Object readerKey = context.reader().getCoreCacheKey();
        LeafCache leafCache = this.cache.get(readerKey);
        if (leafCache == null) {
            this.onMiss(readerKey, filter2);
            return null;
        }
        Filter singleton = this.uniqueFilters.get(filter2);
        if (singleton == null) {
            this.onMiss(readerKey, filter2);
            return null;
        }
        DocIdSet cached = leafCache.get(singleton);
        if (cached == null) {
            this.onMiss(readerKey, singleton);
        } else {
            this.onHit(readerKey, singleton);
        }
        return cached;
    }

    synchronized void putIfAbsent(Filter filter2, LeafReaderContext context, DocIdSet set2) {
        assert (set2.isCacheable());
        Filter singleton = this.uniqueFilters.get(filter2);
        if (singleton == null) {
            this.uniqueFilters.put(filter2, filter2);
            this.onFilterCache(singleton, LINKED_HASHTABLE_RAM_BYTES_PER_ENTRY + this.ramBytesUsed(filter2));
        } else {
            filter2 = singleton;
        }
        Object key2 = context.reader().getCoreCacheKey();
        LeafCache leafCache = this.cache.get(key2);
        if (leafCache == null) {
            leafCache = new LeafCache(key2);
            LeafCache previous = this.cache.put(context.reader().getCoreCacheKey(), leafCache);
            this.ramBytesUsed += HASHTABLE_RAM_BYTES_PER_ENTRY;
            assert (previous == null);
            context.reader().addCoreClosedListener(new LeafReader.CoreClosedListener(){

                @Override
                public void onClose(Object ownerCoreCacheKey) {
                    LRUFilterCache.this.clearCoreCacheKey(ownerCoreCacheKey);
                }
            });
        }
        leafCache.putIfAbsent(filter2, set2);
        this.evictIfNecessary();
    }

    synchronized void evictIfNecessary() {
        if (this.requiresEviction()) {
            Iterator<Filter> iterator = this.mostRecentlyUsedFilters.iterator();
            do {
                Filter filter2 = iterator.next();
                iterator.remove();
                this.onEviction(filter2);
            } while (iterator.hasNext() && this.requiresEviction());
        }
    }

    public synchronized void clearCoreCacheKey(Object coreKey) {
        LeafCache leafCache = this.cache.remove(coreKey);
        if (leafCache != null) {
            this.ramBytesUsed -= HASHTABLE_RAM_BYTES_PER_ENTRY;
            this.onDocIdSetEviction(coreKey, leafCache.cache.size(), leafCache.ramBytesUsed);
        }
    }

    public synchronized void clearFilter(Filter filter2) {
        Filter singleton = this.uniqueFilters.remove(filter2);
        if (singleton != null) {
            this.onEviction(singleton);
        }
    }

    private void onEviction(Filter singleton) {
        this.onFilterEviction(singleton, LINKED_HASHTABLE_RAM_BYTES_PER_ENTRY + this.ramBytesUsed(singleton));
        for (LeafCache leafCache : this.cache.values()) {
            leafCache.remove(singleton);
        }
    }

    public synchronized void clear() {
        this.cache.clear();
        this.mostRecentlyUsedFilters.clear();
        this.onClear();
    }

    synchronized void assertConsistent() {
        if (this.requiresEviction()) {
            throw new AssertionError((Object)("requires evictions: size=" + this.mostRecentlyUsedFilters.size() + ", maxSize=" + this.maxSize + ", ramBytesUsed=" + this.ramBytesUsed() + ", maxRamBytesUsed=" + this.maxRamBytesUsed));
        }
        for (LeafCache leafCache : this.cache.values()) {
            Set keys2 = Collections.newSetFromMap(new IdentityHashMap());
            keys2.addAll(leafCache.cache.keySet());
            keys2.removeAll(this.mostRecentlyUsedFilters);
            if (!keys2.isEmpty()) {
                throw new AssertionError((Object)("One leaf cache contains more keys than the top-level cache: " + keys2));
            }
        }
        long recomputedRamBytesUsed = HASHTABLE_RAM_BYTES_PER_ENTRY * (long)this.cache.size() + LINKED_HASHTABLE_RAM_BYTES_PER_ENTRY * (long)this.uniqueFilters.size();
        for (Filter filter2 : this.mostRecentlyUsedFilters) {
            recomputedRamBytesUsed += this.ramBytesUsed(filter2);
        }
        for (LeafCache leafCache : this.cache.values()) {
            recomputedRamBytesUsed += HASHTABLE_RAM_BYTES_PER_ENTRY * (long)leafCache.cache.size();
            for (DocIdSet set2 : leafCache.cache.values()) {
                recomputedRamBytesUsed += set2.ramBytesUsed();
            }
        }
        if (recomputedRamBytesUsed != this.ramBytesUsed) {
            throw new AssertionError((Object)("ramBytesUsed mismatch : " + this.ramBytesUsed + " != " + recomputedRamBytesUsed));
        }
        long recomputedCacheSize = 0L;
        for (LeafCache leafCache : this.cache.values()) {
            recomputedCacheSize += (long)leafCache.cache.size();
        }
        if (recomputedCacheSize != this.getCacheSize()) {
            throw new AssertionError((Object)("cacheSize mismatch : " + this.getCacheSize() + " != " + recomputedCacheSize));
        }
    }

    synchronized List<Filter> cachedFilters() {
        return new ArrayList<Filter>(this.mostRecentlyUsedFilters);
    }

    @Override
    public Filter doCache(Filter filter2, FilterCachingPolicy policy) {
        while (filter2 instanceof CachingWrapperFilter) {
            filter2 = ((CachingWrapperFilter)filter2).in;
        }
        return new CachingWrapperFilter(filter2, policy);
    }

    protected DocIdSet docIdSetToCache(DocIdSet docIdSet, LeafReader reader2) throws IOException {
        if (docIdSet == null || docIdSet.isCacheable()) {
            return docIdSet;
        }
        DocIdSetIterator it = docIdSet.iterator();
        if (it == null) {
            return null;
        }
        return this.cacheImpl(it, reader2);
    }

    @Override
    public long ramBytesUsed() {
        return this.ramBytesUsed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Accountable> getChildResources() {
        LRUFilterCache lRUFilterCache = this;
        synchronized (lRUFilterCache) {
            return Accountables.namedAccountables("segment", this.cache);
        }
    }

    protected long ramBytesUsed(Filter filter2) {
        if (filter2 instanceof Accountable) {
            return ((Accountable)((Object)filter2)).ramBytesUsed();
        }
        return 216L;
    }

    protected DocIdSet cacheImpl(DocIdSetIterator iterator, LeafReader reader2) throws IOException {
        return new RoaringDocIdSet.Builder(reader2.maxDoc()).add(iterator).build();
    }

    public final long getTotalCount() {
        return this.getHitCount() + this.getMissCount();
    }

    public final long getHitCount() {
        return this.hitCount;
    }

    public final long getMissCount() {
        return this.missCount;
    }

    public final long getCacheSize() {
        return this.cacheSize;
    }

    public final long getCacheCount() {
        return this.cacheCount;
    }

    public final long getEvictionCount() {
        return this.getCacheCount() - this.getCacheSize();
    }

    private class CachingWrapperFilter
    extends Filter {
        private final Filter in;
        private final FilterCachingPolicy policy;

        CachingWrapperFilter(Filter in, FilterCachingPolicy policy) {
            this.in = in;
            this.policy = policy;
        }

        @Override
        public DocIdSet getDocIdSet(LeafReaderContext context, Bits acceptDocs) throws IOException {
            DocIdSet set2;
            if (context.ord == 0) {
                this.policy.onUse(this.in);
            }
            if ((set2 = LRUFilterCache.this.get(this.in, context)) == null && this.policy.shouldCache(this.in, context, set2 = this.in.getDocIdSet(context, null))) {
                if ((set2 = LRUFilterCache.this.docIdSetToCache(set2, context.reader())) == null) {
                    set2 = DocIdSet.EMPTY;
                }
                LRUFilterCache.this.putIfAbsent(this.in, context, set2);
            }
            return set2 == DocIdSet.EMPTY ? null : BitsFilteredDocIdSet.wrap(set2, acceptDocs);
        }

        @Override
        public boolean equals(Object obj) {
            return super.equals(obj) && this.in.equals(((CachingWrapperFilter)obj).in);
        }

        @Override
        public int hashCode() {
            return 31 * super.hashCode() + this.in.hashCode();
        }

        @Override
        public String toString(String field) {
            return "CachingWrapperFilter(" + this.in.toString(field) + ")";
        }
    }

    private class LeafCache
    implements Accountable {
        private final Object key;
        private final Map<Filter, DocIdSet> cache;
        private volatile long ramBytesUsed;

        LeafCache(Object key2) {
            this.key = key2;
            this.cache = new IdentityHashMap<Filter, DocIdSet>();
            this.ramBytesUsed = 0L;
        }

        private void onDocIdSetCache(long ramBytesUsed) {
            this.ramBytesUsed += ramBytesUsed;
            LRUFilterCache.this.onDocIdSetCache(this.key, ramBytesUsed);
        }

        private void onDocIdSetEviction(long ramBytesUsed) {
            this.ramBytesUsed -= ramBytesUsed;
            LRUFilterCache.this.onDocIdSetEviction(this.key, 1, ramBytesUsed);
        }

        DocIdSet get(Filter filter2) {
            return this.cache.get(filter2);
        }

        void putIfAbsent(Filter filter2, DocIdSet set2) {
            if (!this.cache.containsKey(filter2)) {
                this.cache.put(filter2, set2);
                this.onDocIdSetCache(HASHTABLE_RAM_BYTES_PER_ENTRY + set2.ramBytesUsed());
            }
        }

        void remove(Filter filter2) {
            DocIdSet removed = this.cache.remove(filter2);
            if (removed != null) {
                this.onDocIdSetEviction(HASHTABLE_RAM_BYTES_PER_ENTRY + removed.ramBytesUsed());
            }
        }

        @Override
        public long ramBytesUsed() {
            return this.ramBytesUsed;
        }

        @Override
        public Collection<Accountable> getChildResources() {
            return Collections.emptyList();
        }
    }
}

