/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import org.apache.lucene.index.RandomAccessOrds;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.BytesRef;

final class SingletonSortedSetDocValues
extends RandomAccessOrds {
    private final SortedDocValues in;
    private long currentOrd;
    private long ord;

    public SingletonSortedSetDocValues(SortedDocValues in) {
        this.in = in;
    }

    public SortedDocValues getSortedDocValues() {
        return this.in;
    }

    @Override
    public long nextOrd() {
        long v = this.currentOrd;
        this.currentOrd = -1L;
        return v;
    }

    @Override
    public void setDocument(int docID) {
        this.currentOrd = this.ord = (long)this.in.getOrd(docID);
    }

    @Override
    public BytesRef lookupOrd(long ord) {
        return this.in.lookupOrd((int)ord);
    }

    @Override
    public long getValueCount() {
        return this.in.getValueCount();
    }

    @Override
    public long lookupTerm(BytesRef key2) {
        return this.in.lookupTerm(key2);
    }

    @Override
    public long ordAt(int index2) {
        return this.ord;
    }

    @Override
    public int cardinality() {
        return (int)(this.ord >>> 63) ^ 1;
    }

    @Override
    public TermsEnum termsEnum() {
        return this.in.termsEnum();
    }
}

