/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene50;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.NormsConsumer;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.FilterIterator;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.InPlaceMergeSorter;
import org.apache.lucene.util.packed.BlockPackedWriter;
import org.apache.lucene.util.packed.MonotonicBlockPackedWriter;
import org.apache.lucene.util.packed.PackedInts;

class Lucene50NormsConsumer
extends NormsConsumer {
    static final byte DELTA_COMPRESSED = 0;
    static final byte TABLE_COMPRESSED = 1;
    static final byte CONST_COMPRESSED = 2;
    static final byte UNCOMPRESSED = 3;
    static final byte INDIRECT = 4;
    static final byte PATCHED_BITSET = 5;
    static final byte PATCHED_TABLE = 6;
    static final int BLOCK_SIZE = 16384;
    static final float INDIRECT_THRESHOLD = 0.96774197f;
    IndexOutput data;
    IndexOutput meta;
    static final /* synthetic */ boolean $assertionsDisabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Lucene50NormsConsumer(SegmentWriteState state, String dataCodec, String dataExtension, String metaCodec, String metaExtension) throws IOException {
        boolean success = false;
        try {
            String dataName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, dataExtension);
            this.data = state.directory.createOutput(dataName, state.context);
            CodecUtil.writeIndexHeader(this.data, dataCodec, 0, state.segmentInfo.getId(), state.segmentSuffix);
            String metaName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, metaExtension);
            this.meta = state.directory.createOutput(metaName, state.context);
            CodecUtil.writeIndexHeader(this.meta, metaCodec, 0, state.segmentInfo.getId(), state.segmentSuffix);
            return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException(this);
            throw throwable;
        }
    }

    @Override
    public void addNormsField(FieldInfo field, Iterable<Number> values) throws IOException {
        this.writeNormsField(field, values, 0);
    }

    private void writeNormsField(FieldInfo field, Iterable<Number> values, int level) throws IOException {
        if (!$assertionsDisabled && level > 1) {
            throw new AssertionError();
        }
        this.meta.writeVInt(field.number);
        NormMap uniqueValues = new NormMap();
        int count2 = 0;
        for (Number nv : values) {
            if (nv == null) {
                throw new IllegalStateException("illegal norms data for field " + field.name + ", got null for value: " + count2);
            }
            long v = nv.longValue();
            if (uniqueValues != null) {
                if (v >= -128L && v <= 127L) {
                    if (uniqueValues.add((byte)v) && uniqueValues.size > 256) {
                        uniqueValues = null;
                    }
                } else {
                    uniqueValues = null;
                }
            }
            ++count2;
        }
        if (uniqueValues == null) {
            this.addDeltaCompressed(values, count2);
        } else if (uniqueValues.size == 1) {
            this.addConstant(uniqueValues.values[0]);
        } else {
            uniqueValues.optimizeOrdinals();
            int numCommonValues = -1;
            int commonValuesCount = 0;
            if (level == 0 && count2 > 256) {
                float threshold_count = (float)count2 * 0.96774197f;
                if ((float)uniqueValues.freqs[0] > threshold_count) {
                    numCommonValues = 1;
                } else {
                    int n;
                    commonValuesCount = this.sum(uniqueValues.freqs, 0, 3);
                    if ((float)n > threshold_count && uniqueValues.size > 4) {
                        numCommonValues = 3;
                    } else {
                        int n2;
                        commonValuesCount = this.sum(uniqueValues.freqs, 0, 15);
                        if ((float)n2 > threshold_count && uniqueValues.size > 16) {
                            numCommonValues = 15;
                        }
                    }
                }
            }
            if (numCommonValues == -1) {
                PackedInts.FormatAndBits compression = this.fastestFormatAndBits(uniqueValues.size - 1);
                if (compression.bitsPerValue == 8) {
                    this.addUncompressed(values, count2);
                } else {
                    this.addTableCompressed(values, compression, count2, uniqueValues);
                }
            } else if (numCommonValues == 1) {
                byte commonValue = uniqueValues.values[0];
                if (commonValue == 0) {
                    this.addIndirect(field, values, count2, uniqueValues, 0);
                } else {
                    this.addPatchedBitset(field, values, count2, uniqueValues);
                }
            } else {
                this.addPatchedTable(field, values, numCommonValues, commonValuesCount, count2, uniqueValues);
            }
        }
    }

    private int sum(int[] freqs, int start, int end) {
        int accum = 0;
        for (int i = start; i < end; ++i) {
            accum += freqs[i];
        }
        return accum;
    }

    private PackedInts.FormatAndBits fastestFormatAndBits(int max2) {
        PackedInts.Format format2 = PackedInts.Format.PACKED_SINGLE_BLOCK;
        int bitsPerValue = PackedInts.bitsRequired(max2);
        if (bitsPerValue == 3) {
            bitsPerValue = 4;
        } else if (bitsPerValue > 4) {
            bitsPerValue = 8;
        }
        return new PackedInts.FormatAndBits(format2, bitsPerValue);
    }

    private void addConstant(byte constant) throws IOException {
        this.meta.writeVInt(0);
        this.meta.writeByte((byte)2);
        this.meta.writeLong(constant);
    }

    private void addUncompressed(Iterable<Number> values, int count2) throws IOException {
        this.meta.writeVInt(count2);
        this.meta.writeByte((byte)3);
        this.meta.writeLong(this.data.getFilePointer());
        for (Number nv : values) {
            this.data.writeByte(nv.byteValue());
        }
    }

    private void addTableCompressed(Iterable<Number> values, PackedInts.FormatAndBits compression, int count2, NormMap uniqueValues) throws IOException {
        this.meta.writeVInt(count2);
        this.meta.writeByte((byte)1);
        this.meta.writeLong(this.data.getFilePointer());
        this.writeTable(values, compression, count2, uniqueValues, uniqueValues.size);
    }

    private void writeTable(Iterable<Number> values, PackedInts.FormatAndBits compression, int count2, NormMap uniqueValues, int numOrds) throws IOException {
        this.data.writeVInt(2);
        this.data.writeVInt(compression.format.getId());
        this.data.writeVInt(compression.bitsPerValue);
        this.data.writeVInt(numOrds);
        for (int i = 0; i < numOrds; ++i) {
            this.data.writeByte(uniqueValues.values[i]);
        }
        PackedInts.Writer writer2 = PackedInts.getWriterNoHeader(this.data, compression.format, count2, compression.bitsPerValue, 1024);
        for (Number nv : values) {
            int ord = uniqueValues.ord(nv.byteValue());
            if (ord < numOrds) {
                writer2.add(ord);
                continue;
            }
            writer2.add(numOrds);
        }
        writer2.finish();
    }

    private void addDeltaCompressed(Iterable<Number> values, int count2) throws IOException {
        this.meta.writeVInt(count2);
        this.meta.writeByte((byte)0);
        this.meta.writeLong(this.data.getFilePointer());
        this.data.writeVInt(2);
        this.data.writeVInt(16384);
        BlockPackedWriter writer2 = new BlockPackedWriter(this.data, 16384);
        for (Number nv : values) {
            writer2.add(nv.longValue());
        }
        writer2.finish();
    }

    private void addPatchedBitset(FieldInfo field, Iterable<Number> values, int count2, NormMap uniqueValues) throws IOException {
        int commonCount = uniqueValues.freqs[0];
        this.meta.writeVInt(count2 - commonCount);
        this.meta.writeByte((byte)5);
        this.meta.writeLong(this.data.getFilePointer());
        this.writeDocsWithValue(values, uniqueValues, 0);
        this.meta.writeVInt(field.number);
        if (uniqueValues.size == 2) {
            this.addConstant(uniqueValues.values[1]);
        } else {
            this.addIndirect(field, values, count2, uniqueValues, 0);
        }
    }

    private void addPatchedTable(FieldInfo field, Iterable<Number> values, int numCommonValues, int commonValuesCount, int count2, NormMap uniqueValues) throws IOException {
        this.meta.writeVInt(count2);
        this.meta.writeByte((byte)6);
        this.meta.writeLong(this.data.getFilePointer());
        if (!$assertionsDisabled && numCommonValues != 3 && numCommonValues != 15) {
            throw new AssertionError();
        }
        PackedInts.FormatAndBits compression = this.fastestFormatAndBits(numCommonValues);
        this.writeTable(values, compression, count2, uniqueValues, numCommonValues);
        this.meta.writeVInt(field.number);
        this.addIndirect(field, values, count2 - commonValuesCount, uniqueValues, numCommonValues);
    }

    private void addIndirect(FieldInfo field, final Iterable<Number> values, int count2, final NormMap uniqueValues, final int minOrd) throws IOException {
        int commonCount = uniqueValues.freqs[minOrd];
        this.meta.writeVInt(count2 - commonCount);
        this.meta.writeByte((byte)4);
        this.meta.writeLong(this.data.getFilePointer());
        this.writeDocsWithValue(values, uniqueValues, minOrd);
        this.writeNormsField(field, new Iterable<Number>(){

            @Override
            public Iterator<Number> iterator() {
                return new FilterIterator<Number, Number>(values.iterator()){

                    @Override
                    protected boolean predicateFunction(Number value) {
                        return uniqueValues.ord(value.byteValue()) > minOrd;
                    }
                };
            }
        }, 1);
    }

    private void writeDocsWithValue(Iterable<Number> values, NormMap uniqueValues, int minOrd) throws IOException {
        this.data.writeLong(uniqueValues.values[minOrd]);
        this.data.writeVInt(2);
        this.data.writeVInt(16384);
        MonotonicBlockPackedWriter writer2 = new MonotonicBlockPackedWriter(this.data, 16384);
        int doc2 = 0;
        for (Number n : values) {
            int ord = uniqueValues.ord(n.byteValue());
            if (ord > minOrd) {
                writer2.add(doc2);
            }
            ++doc2;
        }
        writer2.finish();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        block7: {
            block6: {
                boolean success = false;
                try {
                    if (this.meta != null) {
                        this.meta.writeVInt(-1);
                        CodecUtil.writeFooter(this.meta);
                    }
                    if (this.data != null) {
                        CodecUtil.writeFooter(this.data);
                    }
                    if (!(success = true)) break block6;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close(this.data, this.meta);
                    } else {
                        IOUtils.closeWhileHandlingException(this.data, this.meta);
                    }
                    this.data = null;
                    this.meta = null;
                    throw throwable;
                }
                IOUtils.close(this.data, this.meta);
                break block7;
            }
            IOUtils.closeWhileHandlingException(this.data, this.meta);
        }
        this.data = null;
        this.meta = null;
    }

    static {
        boolean bl = $assertionsDisabled = !Lucene50NormsConsumer.class.desiredAssertionStatus();
        if (!$assertionsDisabled && !PackedInts.Format.PACKED_SINGLE_BLOCK.isSupported(1)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !PackedInts.Format.PACKED_SINGLE_BLOCK.isSupported(2)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !PackedInts.Format.PACKED_SINGLE_BLOCK.isSupported(4)) {
            throw new AssertionError();
        }
    }

    static class NormMap {
        private final short[] ords = new short[256];
        final int[] freqs = new int[257];
        final byte[] values = new byte[257];
        int size;

        NormMap() {
            Arrays.fill(this.ords, (short)-1);
        }

        public boolean add(byte l) {
            assert (this.size <= 256);
            int index2 = l + 128;
            short previous = this.ords[index2];
            if (previous < 0) {
                short slot;
                this.ords[index2] = slot = (short)this.size;
                short s = slot;
                this.freqs[s] = this.freqs[s] + 1;
                this.values[slot] = l;
                ++this.size;
                return true;
            }
            short s = previous;
            this.freqs[s] = this.freqs[s] + 1;
            return false;
        }

        public int ord(byte value) {
            return this.ords[value + 128];
        }

        public void optimizeOrdinals() {
            new InPlaceMergeSorter(){

                @Override
                protected int compare(int i, int j) {
                    return NormMap.this.freqs[j] - NormMap.this.freqs[i];
                }

                @Override
                protected void swap(int i, int j) {
                    ((NormMap)NormMap.this).ords[NormMap.this.values[i] + 128] = (short)j;
                    ((NormMap)NormMap.this).ords[NormMap.this.values[j] + 128] = (short)i;
                    int tmpFreq = NormMap.this.freqs[i];
                    byte tmpValue = NormMap.this.values[i];
                    NormMap.this.freqs[i] = NormMap.this.freqs[j];
                    NormMap.this.values[i] = NormMap.this.values[j];
                    NormMap.this.freqs[j] = tmpFreq;
                    NormMap.this.values[j] = tmpValue;
                }
            }.sort(0, this.size);
        }
    }
}

