/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.spin.function;

import java.util.List;
import java.util.Map;
import org.eclipse.rdf4j.RDF4JException;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.SPIN;
import org.eclipse.rdf4j.query.algebra.evaluation.TripleSource;
import org.eclipse.rdf4j.query.algebra.evaluation.function.TupleFunction;
import org.eclipse.rdf4j.query.algebra.evaluation.util.TripleSources;
import org.eclipse.rdf4j.query.parser.ParsedQuery;
import org.eclipse.rdf4j.spin.Argument;
import org.eclipse.rdf4j.spin.SpinParser;
import org.eclipse.rdf4j.spin.function.SpinTupleFunction;
import org.eclipse.rdf4j.spin.function.TupleFunctionParser;

public class SpinTupleFunctionParser
implements TupleFunctionParser {
    private final SpinParser parser;

    public SpinTupleFunctionParser(SpinParser parser) {
        this.parser = parser;
    }

    @Override
    public TupleFunction parse(IRI funcUri, TripleSource store) throws RDF4JException {
        Value body = TripleSources.singleValue(funcUri, SPIN.BODY_PROPERTY, store);
        if (!(body instanceof Resource)) {
            return null;
        }
        ParsedQuery query = this.parser.parseQuery((Resource)body, store);
        Map<IRI, Argument> templateArgs = this.parser.parseArguments(funcUri, store);
        SpinTupleFunction func = new SpinTupleFunction(funcUri.stringValue());
        func.setParsedQuery(query);
        List<IRI> orderedArgs = SpinParser.orderArguments(templateArgs.keySet());
        for (IRI IRI2 : orderedArgs) {
            Argument arg = templateArgs.get(IRI2);
            func.addArgument(arg);
        }
        return func;
    }
}

