/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.rio.jsonld;

import com.fasterxml.jackson.core.JsonParseException;
import com.github.jsonldjava.core.JsonLdError;
import com.github.jsonldjava.core.JsonLdOptions;
import com.github.jsonldjava.core.JsonLdProcessor;
import com.github.jsonldjava.utils.JsonUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.RDFParser;
import org.eclipse.rdf4j.rio.helpers.AbstractRDFParser;
import org.eclipse.rdf4j.rio.jsonld.JSONLDInternalTripleCallback;

public class JSONLDParser
extends AbstractRDFParser
implements RDFParser {
    public JSONLDParser() {
    }

    public JSONLDParser(ValueFactory valueFactory) {
        super(valueFactory);
    }

    @Override
    public RDFFormat getRDFFormat() {
        return RDFFormat.JSONLD;
    }

    @Override
    public void parse(InputStream in, String baseURI) throws IOException, RDFParseException, RDFHandlerException {
        JSONLDInternalTripleCallback callback = new JSONLDInternalTripleCallback(this.getRDFHandler(), this.valueFactory, this.getParserConfig(), this.getParseErrorListener());
        JsonLdOptions options = new JsonLdOptions(baseURI);
        options.useNamespaces = true;
        try {
            JsonLdProcessor.toRDF(JsonUtils.fromInputStream(in), callback, options);
        }
        catch (JsonLdError e2) {
            throw new RDFParseException("Could not parse JSONLD", e2);
        }
        catch (JsonParseException e3) {
            throw new RDFParseException("Could not parse JSONLD", e3);
        }
        catch (RuntimeException e4) {
            if (e4.getCause() != null && e4.getCause() instanceof RDFParseException) {
                throw (RDFParseException)e4.getCause();
            }
            throw e4;
        }
    }

    @Override
    public void parse(Reader reader2, String baseURI) throws IOException, RDFParseException, RDFHandlerException {
        JSONLDInternalTripleCallback callback = new JSONLDInternalTripleCallback(this.getRDFHandler(), this.valueFactory, this.getParserConfig(), this.getParseErrorListener());
        JsonLdOptions options = new JsonLdOptions(baseURI);
        options.useNamespaces = true;
        try {
            JsonLdProcessor.toRDF(JsonUtils.fromReader(reader2), callback, options);
        }
        catch (JsonLdError e2) {
            throw new RDFParseException("Could not parse JSONLD", e2);
        }
        catch (JsonParseException e3) {
            throw new RDFParseException("Could not parse JSONLD", e3);
        }
        catch (RuntimeException e4) {
            if (e4.getCause() != null && e4.getCause() instanceof RDFParseException) {
                throw (RDFParseException)e4.getCause();
            }
            throw e4;
        }
    }
}

