/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.resultio;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Optional;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Supplier;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.GraphQueryResult;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryResultHandlerException;
import org.eclipse.rdf4j.query.QueryResults;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.query.TupleQueryResultHandler;
import org.eclipse.rdf4j.query.TupleQueryResultHandlerException;
import org.eclipse.rdf4j.query.impl.QueueCursor;
import org.eclipse.rdf4j.query.impl.TupleQueryResultBuilder;
import org.eclipse.rdf4j.query.resultio.BooleanQueryResultFormat;
import org.eclipse.rdf4j.query.resultio.BooleanQueryResultParser;
import org.eclipse.rdf4j.query.resultio.BooleanQueryResultParserFactory;
import org.eclipse.rdf4j.query.resultio.BooleanQueryResultParserRegistry;
import org.eclipse.rdf4j.query.resultio.BooleanQueryResultWriter;
import org.eclipse.rdf4j.query.resultio.BooleanQueryResultWriterFactory;
import org.eclipse.rdf4j.query.resultio.BooleanQueryResultWriterRegistry;
import org.eclipse.rdf4j.query.resultio.QueryResultFormat;
import org.eclipse.rdf4j.query.resultio.QueryResultParseException;
import org.eclipse.rdf4j.query.resultio.QueryResultWriter;
import org.eclipse.rdf4j.query.resultio.TupleQueryResultFormat;
import org.eclipse.rdf4j.query.resultio.TupleQueryResultParser;
import org.eclipse.rdf4j.query.resultio.TupleQueryResultParserFactory;
import org.eclipse.rdf4j.query.resultio.TupleQueryResultParserRegistry;
import org.eclipse.rdf4j.query.resultio.TupleQueryResultWriter;
import org.eclipse.rdf4j.query.resultio.TupleQueryResultWriterFactory;
import org.eclipse.rdf4j.query.resultio.TupleQueryResultWriterRegistry;
import org.eclipse.rdf4j.query.resultio.UnsupportedQueryResultFormatException;
import org.eclipse.rdf4j.query.resultio.helpers.BackgroundTupleResult;
import org.eclipse.rdf4j.query.resultio.helpers.QueryResultCollector;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFWriter;
import org.eclipse.rdf4j.rio.Rio;
import org.eclipse.rdf4j.rio.UnsupportedRDFormatException;

public class QueryResultIO {
    public static Optional<QueryResultFormat> getParserFormatForMIMEType(String mimeType) {
        return TupleQueryResultParserRegistry.getInstance().getFileFormatForMIMEType(mimeType);
    }

    public static Optional<QueryResultFormat> getParserFormatForFileName(String fileName) {
        return TupleQueryResultParserRegistry.getInstance().getFileFormatForFileName(fileName);
    }

    public static Optional<QueryResultFormat> getWriterFormatForMIMEType(String mimeType) {
        return TupleQueryResultWriterRegistry.getInstance().getFileFormatForMIMEType(mimeType);
    }

    public static Optional<QueryResultFormat> getWriterFormatForFileName(String fileName) {
        return TupleQueryResultWriterRegistry.getInstance().getFileFormatForFileName(fileName);
    }

    public static Optional<QueryResultFormat> getBooleanParserFormatForMIMEType(String mimeType) {
        return BooleanQueryResultParserRegistry.getInstance().getFileFormatForMIMEType(mimeType);
    }

    public static Optional<QueryResultFormat> getBooleanParserFormatForFileName(String fileName) {
        return BooleanQueryResultParserRegistry.getInstance().getFileFormatForFileName(fileName);
    }

    public static Optional<QueryResultFormat> getBooleanWriterFormatForMIMEType(String mimeType) {
        return BooleanQueryResultWriterRegistry.getInstance().getFileFormatForMIMEType(mimeType);
    }

    public static Optional<QueryResultFormat> getBooleanWriterFormatForFileName(String fileName) {
        return BooleanQueryResultWriterRegistry.getInstance().getFileFormatForFileName(fileName);
    }

    public static TupleQueryResultParser createTupleParser(QueryResultFormat format2) throws UnsupportedQueryResultFormatException {
        TupleQueryResultParserFactory factory = (TupleQueryResultParserFactory)TupleQueryResultParserRegistry.getInstance().get(format2).orElseThrow(() -> new UnsupportedQueryResultFormatException("No parser factory available for tuple query result format " + format2));
        return factory.getParser();
    }

    public static TupleQueryResultParser createTupleParser(QueryResultFormat format2, ValueFactory valueFactory) throws UnsupportedQueryResultFormatException {
        TupleQueryResultParser parser = QueryResultIO.createTupleParser(format2);
        parser.setValueFactory(valueFactory);
        return parser;
    }

    public static TupleQueryResultWriter createTupleWriter(QueryResultFormat format2, OutputStream out) throws UnsupportedQueryResultFormatException {
        TupleQueryResultWriterFactory factory = (TupleQueryResultWriterFactory)TupleQueryResultWriterRegistry.getInstance().get(format2).orElseThrow(() -> new UnsupportedQueryResultFormatException("No writer factory available for tuple query result format " + format2));
        return factory.getWriter(out);
    }

    public static BooleanQueryResultParser createBooleanParser(QueryResultFormat format2) throws UnsupportedQueryResultFormatException {
        BooleanQueryResultParserFactory factory = (BooleanQueryResultParserFactory)BooleanQueryResultParserRegistry.getInstance().get(format2).orElseThrow(() -> new UnsupportedQueryResultFormatException("No parser factory available for boolean query result format " + format2));
        return factory.getParser();
    }

    public static BooleanQueryResultWriter createBooleanWriter(QueryResultFormat format2, OutputStream out) throws UnsupportedQueryResultFormatException {
        BooleanQueryResultWriterFactory factory = (BooleanQueryResultWriterFactory)BooleanQueryResultWriterRegistry.getInstance().get(format2).orElseThrow(() -> new UnsupportedQueryResultFormatException("No writer factory available for boolean query result format " + format2));
        return factory.getWriter(out);
    }

    public static QueryResultWriter createWriter(QueryResultFormat format2, OutputStream out) throws UnsupportedQueryResultFormatException {
        Supplier<UnsupportedQueryResultFormatException> exception = () -> new UnsupportedQueryResultFormatException("No writer factory available for query result format " + format2);
        if (format2 instanceof TupleQueryResultFormat) {
            TupleQueryResultWriterFactory factory = (TupleQueryResultWriterFactory)TupleQueryResultWriterRegistry.getInstance().get((TupleQueryResultFormat)format2).orElseThrow(exception);
            return factory.getWriter(out);
        }
        if (format2 instanceof BooleanQueryResultFormat) {
            BooleanQueryResultWriterFactory factory = (BooleanQueryResultWriterFactory)BooleanQueryResultWriterRegistry.getInstance().get((BooleanQueryResultFormat)format2).orElseThrow(exception);
            return factory.getWriter(out);
        }
        throw exception.get();
    }

    public static void parseTuple(InputStream in, QueryResultFormat format2, TupleQueryResultHandler handler, ValueFactory valueFactory) throws IOException, QueryResultParseException, TupleQueryResultHandlerException, UnsupportedQueryResultFormatException {
        TupleQueryResultParser parser = QueryResultIO.createTupleParser(format2);
        parser.setValueFactory(valueFactory);
        parser.setQueryResultHandler(handler);
        try {
            parser.parseQueryResult(in);
        }
        catch (QueryResultHandlerException e2) {
            if (e2 instanceof TupleQueryResultHandlerException) {
                throw (TupleQueryResultHandlerException)e2;
            }
            throw new TupleQueryResultHandlerException(e2);
        }
    }

    public static TupleQueryResult parseTuple(InputStream in, QueryResultFormat format2) throws IOException, QueryResultParseException, TupleQueryResultHandlerException, UnsupportedQueryResultFormatException {
        return QueryResultIO.parseTupleInternal(in, format2, false);
    }

    public static TupleQueryResult parseTupleBackground(InputStream in, QueryResultFormat format2) throws IOException, QueryResultParseException, TupleQueryResultHandlerException, UnsupportedQueryResultFormatException {
        return QueryResultIO.parseTupleInternal(in, format2, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TupleQueryResult parseTupleInternal(InputStream in, QueryResultFormat format2, boolean parseOnBackgroundThread) throws IOException, QueryResultParseException, TupleQueryResultHandlerException, UnsupportedQueryResultFormatException {
        TupleQueryResultParser parser = QueryResultIO.createTupleParser(format2);
        if (parseOnBackgroundThread) {
            BackgroundTupleResult result = new BackgroundTupleResult(new QueueCursor<BindingSet>(new LinkedBlockingQueue(1)), parser, in);
            boolean allGood = false;
            try {
                ForkJoinPool.commonPool().submit(result);
                allGood = true;
            }
            finally {
                if (!allGood) {
                    result.close();
                }
            }
            return result;
        }
        TupleQueryResultBuilder qrBuilder = new TupleQueryResultBuilder();
        try {
            parser.setQueryResultHandler(qrBuilder).parseQueryResult(in);
        }
        catch (QueryResultHandlerException e2) {
            if (e2 instanceof TupleQueryResultHandlerException) {
                throw (TupleQueryResultHandlerException)e2;
            }
            throw new TupleQueryResultHandlerException(e2);
        }
        return qrBuilder.getQueryResult();
    }

    public static boolean parseBoolean(InputStream in, QueryResultFormat format2) throws IOException, QueryResultParseException, UnsupportedQueryResultFormatException {
        BooleanQueryResultParser parser = QueryResultIO.createBooleanParser(format2);
        try {
            QueryResultCollector handler = new QueryResultCollector();
            parser.setQueryResultHandler(handler);
            parser.parseQueryResult(in);
            if (handler.getHandledBoolean()) {
                return handler.getBoolean();
            }
            throw new QueryResultParseException("Did not find a boolean result");
        }
        catch (QueryResultHandlerException e2) {
            throw new QueryResultParseException(e2);
        }
    }

    public static void writeTuple(TupleQueryResult tqr, QueryResultFormat format2, OutputStream out) throws IOException, TupleQueryResultHandlerException, UnsupportedQueryResultFormatException, QueryEvaluationException {
        TupleQueryResultWriter writer2 = QueryResultIO.createTupleWriter(format2, out);
        try {
            writer2.startDocument();
            writer2.startHeader();
            QueryResults.report(tqr, writer2);
        }
        catch (QueryResultHandlerException e2) {
            if (e2.getCause() instanceof IOException) {
                throw (IOException)e2.getCause();
            }
            if (e2 instanceof TupleQueryResultHandlerException) {
                throw (TupleQueryResultHandlerException)e2;
            }
            throw new TupleQueryResultHandlerException(e2);
        }
    }

    public static void writeBoolean(boolean value, QueryResultFormat format2, OutputStream out) throws QueryResultHandlerException, UnsupportedQueryResultFormatException {
        BooleanQueryResultWriter writer2 = QueryResultIO.createBooleanWriter(format2, out);
        writer2.startDocument();
        writer2.startHeader();
        writer2.handleBoolean(value);
    }

    public static void writeGraph(GraphQueryResult gqr, RDFFormat format2, OutputStream out) throws IOException, RDFHandlerException, UnsupportedRDFormatException, QueryEvaluationException {
        RDFWriter writer2 = Rio.createWriter(format2, out);
        try {
            QueryResults.report(gqr, writer2);
        }
        catch (RDFHandlerException e2) {
            if (e2.getCause() instanceof IOException) {
                throw (IOException)e2.getCause();
            }
            throw e2;
        }
    }
}

