/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.dawg;

import org.eclipse.rdf4j.model.Graph;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.impl.GraphImpl;
import org.eclipse.rdf4j.model.util.GraphUtil;
import org.eclipse.rdf4j.model.util.GraphUtilException;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.query.dawg.DAWGTestResultSetSchema;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.helpers.AbstractRDFHandler;

public class DAWGTestBooleanParser
extends AbstractRDFHandler {
    private Graph graph = new GraphImpl();
    private boolean value;

    public boolean getValue() {
        return this.value;
    }

    @Override
    public void startRDF() throws RDFHandlerException {
        this.graph.clear();
    }

    @Override
    public void handleStatement(Statement st) throws RDFHandlerException {
        this.graph.add(st);
    }

    @Override
    public void endRDF() throws RDFHandlerException {
        block4: {
            try {
                Resource resultSetNode = GraphUtil.getUniqueSubject(this.graph, RDF.TYPE, DAWGTestResultSetSchema.RESULTSET, new Resource[0]);
                Literal booleanLit = GraphUtil.getUniqueObjectLiteral(this.graph, resultSetNode, DAWGTestResultSetSchema.BOOLEAN);
                if (booleanLit.equals(DAWGTestResultSetSchema.TRUE)) {
                    this.value = true;
                    break block4;
                }
                if (booleanLit.equals(DAWGTestResultSetSchema.FALSE)) {
                    this.value = false;
                    break block4;
                }
                throw new RDFHandlerException("Invalid boolean value: " + booleanLit);
            }
            catch (GraphUtilException e2) {
                throw new RDFHandlerException(e2.getMessage(), e2);
            }
        }
    }
}

