/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.LockFactory;

public final class VerifyingLockFactory
extends LockFactory {
    final LockFactory lf;
    final InputStream in;
    final OutputStream out;

    public VerifyingLockFactory(LockFactory lf, InputStream in, OutputStream out) throws IOException {
        this.lf = lf;
        this.in = in;
        this.out = out;
    }

    @Override
    public Lock makeLock(Directory dir2, String lockName) {
        return new CheckedLock(this.lf.makeLock(dir2, lockName));
    }

    private class CheckedLock
    extends Lock {
        private final Lock lock;
        private boolean obtained = false;

        public CheckedLock(Lock lock) {
            this.lock = lock;
        }

        private void verify(byte message) throws IOException {
            VerifyingLockFactory.this.out.write(message);
            VerifyingLockFactory.this.out.flush();
            int ret = VerifyingLockFactory.this.in.read();
            if (ret < 0) {
                throw new IllegalStateException("Lock server died because of locking error.");
            }
            if (ret != message) {
                throw new IOException("Protocol violation.");
            }
        }

        @Override
        public synchronized boolean obtain() throws IOException {
            this.obtained = this.lock.obtain();
            if (this.obtained) {
                this.verify((byte)1);
            }
            return this.obtained;
        }

        @Override
        public synchronized boolean isLocked() throws IOException {
            return this.lock.isLocked();
        }

        @Override
        public synchronized void close() throws IOException {
            if (this.obtained) {
                assert (this.isLocked());
                this.verify((byte)0);
            }
            this.lock.close();
        }
    }
}

