/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.FSLockFactory;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.LockObtainFailedException;
import org.apache.lucene.store.LockReleaseFailedException;

public final class SimpleFSLockFactory
extends FSLockFactory {
    public static final SimpleFSLockFactory INSTANCE = new SimpleFSLockFactory();

    private SimpleFSLockFactory() {
    }

    @Override
    protected Lock makeFSLock(FSDirectory dir2, String lockName) {
        return new SimpleFSLock(dir2.getDirectory(), lockName);
    }

    static class SimpleFSLock
    extends Lock {
        Path lockFile;
        Path lockDir;
        boolean obtained = false;

        public SimpleFSLock(Path lockDir, String lockFileName) {
            this.lockDir = lockDir;
            this.lockFile = lockDir.resolve(lockFileName);
        }

        @Override
        public synchronized boolean obtain() throws IOException {
            if (this.obtained) {
                throw new LockObtainFailedException("this lock instance was already obtained");
            }
            try {
                Files.createDirectories(this.lockDir, new FileAttribute[0]);
                Files.createFile(this.lockFile, new FileAttribute[0]);
                this.obtained = true;
            }
            catch (IOException ioe) {
                this.failureReason = ioe;
            }
            return this.obtained;
        }

        @Override
        public synchronized void close() throws LockReleaseFailedException {
            if (this.obtained) {
                try {
                    Files.deleteIfExists(this.lockFile);
                }
                catch (Throwable cause) {
                    throw new LockReleaseFailedException("failed to delete " + this.lockFile, cause);
                }
                finally {
                    this.obtained = false;
                }
            }
        }

        @Override
        public boolean isLocked() {
            return Files.exists(this.lockFile, new LinkOption[0]);
        }

        public String toString() {
            return "SimpleFSLock@" + this.lockFile;
        }
    }
}

