/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.util;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;

public class CachingDoubleValueSource
extends ValueSource {
    final ValueSource source;
    final Map<Integer, Double> cache;

    public CachingDoubleValueSource(ValueSource source2) {
        this.source = source2;
        this.cache = new HashMap<Integer, Double>();
    }

    @Override
    public String description() {
        return "Cached[" + this.source.description() + "]";
    }

    @Override
    public FunctionValues getValues(Map context, LeafReaderContext readerContext) throws IOException {
        final int base = readerContext.docBase;
        final FunctionValues vals2 = this.source.getValues(context, readerContext);
        return new FunctionValues(){

            @Override
            public double doubleVal(int doc2) {
                Integer key2 = base + doc2;
                Double v = CachingDoubleValueSource.this.cache.get(key2);
                if (v == null) {
                    v = vals2.doubleVal(doc2);
                    CachingDoubleValueSource.this.cache.put(key2, v);
                }
                return v;
            }

            @Override
            public float floatVal(int doc2) {
                return (float)this.doubleVal(doc2);
            }

            @Override
            public String toString(int doc2) {
                return this.doubleVal(doc2) + "";
            }
        };
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CachingDoubleValueSource that = (CachingDoubleValueSource)o;
        return !(this.source != null ? !this.source.equals(that.source) : that.source != null);
    }

    @Override
    public int hashCode() {
        return this.source != null ? this.source.hashCode() : 0;
    }
}

