/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.spatial4j.geo3d;

import org.apache.lucene.spatial.spatial4j.geo3d.Bounds;
import org.apache.lucene.spatial.spatial4j.geo3d.GeoBBox;
import org.apache.lucene.spatial.spatial4j.geo3d.GeoBBoxBase;
import org.apache.lucene.spatial.spatial4j.geo3d.GeoBBoxFactory;
import org.apache.lucene.spatial.spatial4j.geo3d.GeoPoint;
import org.apache.lucene.spatial.spatial4j.geo3d.GeoShape;
import org.apache.lucene.spatial.spatial4j.geo3d.Membership;
import org.apache.lucene.spatial.spatial4j.geo3d.Plane;
import org.apache.lucene.spatial.spatial4j.geo3d.SidedPlane;
import org.apache.lucene.spatial.spatial4j.geo3d.Vector;

public class GeoWideLongitudeSlice
extends GeoBBoxBase {
    public final double leftLon;
    public final double rightLon;
    public final SidedPlane leftPlane;
    public final SidedPlane rightPlane;
    public static final GeoPoint[] planePoints = new GeoPoint[]{NORTH_POLE, SOUTH_POLE};
    public final GeoPoint centerPoint;
    public static final GeoPoint[] edgePoints = new GeoPoint[]{NORTH_POLE};

    public GeoWideLongitudeSlice(double leftLon, double rightLon) {
        if (leftLon < -Math.PI || leftLon > Math.PI) {
            throw new IllegalArgumentException("Left longitude out of range");
        }
        if (rightLon < -Math.PI || rightLon > Math.PI) {
            throw new IllegalArgumentException("Right longitude out of range");
        }
        double extent = rightLon - leftLon;
        if (extent < 0.0) {
            extent += Math.PI * 2;
        }
        if (extent < Math.PI) {
            throw new IllegalArgumentException("Width of rectangle too small");
        }
        this.leftLon = leftLon;
        this.rightLon = rightLon;
        double sinLeftLon = Math.sin(leftLon);
        double cosLeftLon = Math.cos(leftLon);
        double sinRightLon = Math.sin(rightLon);
        double cosRightLon = Math.cos(rightLon);
        while (leftLon > rightLon) {
            rightLon += Math.PI * 2;
        }
        double middleLon = (leftLon + rightLon) * 0.5;
        this.centerPoint = new GeoPoint(0.0, middleLon);
        this.leftPlane = new SidedPlane((Vector)this.centerPoint, cosLeftLon, sinLeftLon);
        this.rightPlane = new SidedPlane((Vector)this.centerPoint, cosRightLon, sinRightLon);
    }

    @Override
    public GeoBBox expand(double angle) {
        double currentLonSpan = this.rightLon - this.leftLon;
        if (currentLonSpan < 0.0) {
            currentLonSpan += Math.PI * 2;
        }
        double newLeftLon = this.leftLon - angle;
        double newRightLon = this.rightLon + angle;
        if (currentLonSpan + 2.0 * angle >= Math.PI * 2) {
            newLeftLon = -Math.PI;
            newRightLon = Math.PI;
        }
        return GeoBBoxFactory.makeGeoBBox(1.5707963267948966, -1.5707963267948966, newLeftLon, newRightLon);
    }

    @Override
    public boolean isWithin(Vector point) {
        return this.leftPlane.isWithin(point) || this.rightPlane.isWithin(point);
    }

    @Override
    public boolean isWithin(double x, double y, double z) {
        return this.leftPlane.isWithin(x, y, z) || this.rightPlane.isWithin(x, y, z);
    }

    @Override
    public double getRadius() {
        double extent = this.rightLon - this.leftLon;
        if (extent < 0.0) {
            extent += Math.PI * 2;
        }
        return Math.max(1.5707963267948966, extent * 0.5);
    }

    @Override
    public GeoPoint getCenter() {
        return this.centerPoint;
    }

    @Override
    public GeoPoint[] getEdgePoints() {
        return edgePoints;
    }

    @Override
    public boolean intersects(Plane p, GeoPoint[] notablePoints, Membership ... bounds) {
        return p.intersects(this.leftPlane, notablePoints, planePoints, bounds, new Membership[0]) || p.intersects(this.rightPlane, notablePoints, planePoints, bounds, new Membership[0]);
    }

    @Override
    public Bounds getBounds(Bounds bounds) {
        if (bounds == null) {
            bounds = new Bounds();
        }
        bounds.noTopLatitudeBound().noBottomLatitudeBound();
        bounds.addLongitudeSlice(this.leftLon, this.rightLon);
        return bounds;
    }

    @Override
    public int getRelationship(GeoShape path2) {
        int insideRectangle = this.isShapeInsideBBox(path2);
        if (insideRectangle == 1) {
            return 2;
        }
        boolean insideShape = path2.isWithin(NORTH_POLE);
        if (insideRectangle == 0 && insideShape) {
            return 2;
        }
        if (path2.intersects(this.leftPlane, planePoints, new Membership[0]) || path2.intersects(this.rightPlane, planePoints, new Membership[0])) {
            return 2;
        }
        if (insideRectangle == 0) {
            return 1;
        }
        if (insideShape) {
            return 0;
        }
        return 3;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof GeoWideLongitudeSlice)) {
            return false;
        }
        GeoWideLongitudeSlice other = (GeoWideLongitudeSlice)o;
        return other.leftLon == this.leftLon && other.rightLon == this.rightLon;
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.leftLon);
        int result = (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.rightLon);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public String toString() {
        return "GeoWideLongitudeSlice: {leftlon=" + this.leftLon + "(" + this.leftLon * 180.0 / Math.PI + "), rightlon=" + this.rightLon + "(" + this.rightLon * 180.0 / Math.PI + ")}";
    }
}

