/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.util.Objects;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.FilteredDocIdSet;
import org.apache.lucene.util.Bits;

public final class BitsFilteredDocIdSet
extends FilteredDocIdSet {
    private final Bits acceptDocs;

    public static DocIdSet wrap(DocIdSet set2, Bits acceptDocs) {
        return set2 == null || acceptDocs == null ? set2 : new BitsFilteredDocIdSet(set2, acceptDocs);
    }

    public BitsFilteredDocIdSet(DocIdSet innerSet, Bits acceptDocs) {
        super(innerSet);
        this.acceptDocs = Objects.requireNonNull(acceptDocs, "Bits must not be null");
    }

    @Override
    protected boolean match(int docid) {
        return this.acceptDocs.get(docid);
    }
}

