/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.function.valuesource;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.docvalues.LongDocValues;
import org.apache.lucene.queries.function.valuesource.FieldCacheSource;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.mutable.MutableValue;
import org.apache.lucene.util.mutable.MutableValueLong;

public class LongFieldSource
extends FieldCacheSource {
    public LongFieldSource(String field) {
        super(field);
    }

    @Override
    public String description() {
        return "long(" + this.field + ')';
    }

    public long externalToLong(String extVal) {
        return Long.parseLong(extVal);
    }

    public Object longToObject(long val2) {
        return val2;
    }

    public String longToString(long val2) {
        return this.longToObject(val2).toString();
    }

    @Override
    public FunctionValues getValues(Map context, LeafReaderContext readerContext) throws IOException {
        final NumericDocValues arr = DocValues.getNumeric(readerContext.reader(), this.field);
        final Bits valid = DocValues.getDocsWithField(readerContext.reader(), this.field);
        return new LongDocValues(this){

            @Override
            public long longVal(int doc2) {
                return arr.get(doc2);
            }

            @Override
            public boolean exists(int doc2) {
                return arr.get(doc2) != 0L || valid.get(doc2);
            }

            @Override
            public Object objectVal(int doc2) {
                return valid.get(doc2) ? LongFieldSource.this.longToObject(arr.get(doc2)) : null;
            }

            @Override
            public String strVal(int doc2) {
                return valid.get(doc2) ? LongFieldSource.this.longToString(arr.get(doc2)) : null;
            }

            @Override
            protected long externalToLong(String extVal) {
                return LongFieldSource.this.externalToLong(extVal);
            }

            @Override
            public FunctionValues.ValueFiller getValueFiller() {
                return new FunctionValues.ValueFiller(){
                    private final MutableValueLong mval;
                    {
                        this.mval = LongFieldSource.this.newMutableValueLong();
                    }

                    @Override
                    public MutableValue getValue() {
                        return this.mval;
                    }

                    @Override
                    public void fillValue(int doc2) {
                        this.mval.value = arr.get(doc2);
                        this.mval.exists = this.mval.value != 0L || valid.get(doc2);
                    }
                };
            }
        };
    }

    protected MutableValueLong newMutableValueLong() {
        return new MutableValueLong();
    }

    @Override
    public boolean equals(Object o) {
        if (o.getClass() != this.getClass()) {
            return false;
        }
        LongFieldSource other = (LongFieldSource)o;
        return super.equals(other);
    }

    @Override
    public int hashCode() {
        int h = this.getClass().hashCode();
        return h += super.hashCode();
    }
}

