/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.PrefixCodedTerms;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.index.TermState;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BitDocIdSet;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.ToStringUtils;

public class TermsQuery
extends Query
implements Accountable {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(TermsQuery.class);
    static final int BOOLEAN_REWRITE_TERM_COUNT_THRESHOLD = 16;
    private final PrefixCodedTerms termData;
    private final int termDataHashCode;

    private static Term[] toTermArray(String field, List<BytesRef> termBytes) {
        Term[] array2 = new Term[termBytes.size()];
        int i = 0;
        for (BytesRef t : termBytes) {
            array2[i++] = new Term(field, t);
        }
        return array2;
    }

    public TermsQuery(List<Term> terms) {
        Comparable[] sortedTerms = terms.toArray(new Term[terms.size()]);
        ArrayUtil.timSort((Comparable[])sortedTerms);
        PrefixCodedTerms.Builder builder = new PrefixCodedTerms.Builder();
        Comparable previous = null;
        for (Comparable term : sortedTerms) {
            if (!((Term)term).equals(previous)) {
                builder.add((Term)term);
            }
            previous = term;
        }
        this.termData = builder.finish();
        this.termDataHashCode = this.termData.hashCode();
    }

    public TermsQuery(String field, List<BytesRef> terms) {
        this(TermsQuery.toTermArray(field, terms));
    }

    public TermsQuery(String field, BytesRef ... terms) {
        this(field, Arrays.asList(terms));
    }

    public TermsQuery(Term ... terms) {
        this(Arrays.asList(terms));
    }

    @Override
    public Query rewrite(IndexReader reader2) throws IOException {
        int threshold = Math.min(16, BooleanQuery.getMaxClauseCount());
        if (this.termData.size() <= (long)threshold) {
            BooleanQuery bq = new BooleanQuery();
            PrefixCodedTerms.TermIterator iterator = this.termData.iterator();
            BytesRef term = iterator.next();
            while (term != null) {
                bq.add(new TermQuery(new Term(iterator.field(), BytesRef.deepCopyOf(term))), BooleanClause.Occur.SHOULD);
                term = iterator.next();
            }
            assert ((long)bq.clauses().size() == this.termData.size());
            ConstantScoreQuery csq = new ConstantScoreQuery(bq);
            csq.setBoost(this.getBoost());
            return csq;
        }
        return super.rewrite(reader2);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        TermsQuery that = (TermsQuery)obj;
        return this.termDataHashCode == that.termDataHashCode && this.termData.equals(that.termData);
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + this.termDataHashCode;
    }

    @Override
    public String toString(String defaultField) {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        PrefixCodedTerms.TermIterator iterator = this.termData.iterator();
        BytesRef term = iterator.next();
        while (term != null) {
            if (!first) {
                builder.append(' ');
            }
            first = false;
            builder.append(iterator.field()).append(':');
            builder.append(term.utf8ToString());
            term = iterator.next();
        }
        builder.append(ToStringUtils.boost(this.getBoost()));
        return builder.toString();
    }

    @Override
    public long ramBytesUsed() {
        return BASE_RAM_BYTES_USED + this.termData.ramBytesUsed();
    }

    @Override
    public Collection<Accountable> getChildResources() {
        return Collections.emptyList();
    }

    @Override
    public Weight createWeight(final IndexSearcher searcher, final boolean needsScores) throws IOException {
        return new ConstantScoreWeight(this){

            @Override
            public void extractTerms(Set<Term> terms) {
            }

            private WeightOrBitSet rewrite(LeafReaderContext context, Bits acceptDocs) throws IOException {
                LeafReader reader2 = context.reader();
                int threshold = Math.min(16, BooleanQuery.getMaxClauseCount());
                assert (TermsQuery.this.termData.size() > (long)threshold) : "Query should have been rewritten";
                ArrayList<TermAndState> matchingTerms = new ArrayList<TermAndState>(threshold);
                BitDocIdSet.Builder builder = null;
                Fields fields = reader2.fields();
                String lastField = null;
                Terms terms = null;
                TermsEnum termsEnum = null;
                PostingsEnum docs = null;
                PrefixCodedTerms.TermIterator iterator = TermsQuery.this.termData.iterator();
                BytesRef term = iterator.next();
                while (term != null) {
                    String field = iterator.field();
                    if (field != lastField) {
                        terms = fields.terms(field);
                        termsEnum = terms == null ? null : terms.iterator();
                        lastField = field;
                    }
                    if (termsEnum != null && termsEnum.seekExact(term)) {
                        if (matchingTerms == null) {
                            docs = termsEnum.postings(acceptDocs, docs, 0);
                            builder.or(docs);
                        } else if (matchingTerms.size() < threshold) {
                            matchingTerms.add(new TermAndState(field, termsEnum));
                        } else {
                            assert (matchingTerms.size() == threshold);
                            builder = new BitDocIdSet.Builder(reader2.maxDoc());
                            docs = termsEnum.postings(acceptDocs, docs, 0);
                            builder.or(docs);
                            for (TermAndState t : matchingTerms) {
                                t.termsEnum.seekExact(t.term, t.state);
                                docs = t.termsEnum.postings(acceptDocs, docs, 0);
                                builder.or(docs);
                            }
                            matchingTerms = null;
                        }
                    }
                    term = iterator.next();
                }
                if (matchingTerms != null) {
                    assert (builder == null);
                    BooleanQuery bq = new BooleanQuery();
                    for (TermAndState t : matchingTerms) {
                        TermContext termContext = new TermContext(searcher.getTopReaderContext());
                        termContext.register(t.state, context.ord, t.docFreq, t.totalTermFreq);
                        bq.add(new TermQuery(new Term(t.field, t.term), termContext), BooleanClause.Occur.SHOULD);
                    }
                    ConstantScoreQuery q = new ConstantScoreQuery(bq);
                    q.setBoost(this.score());
                    return new WeightOrBitSet(searcher.rewrite(q).createWeight(searcher, needsScores));
                }
                assert (builder != null);
                return new WeightOrBitSet(builder.build());
            }

            private Scorer scorer(BitDocIdSet set2) {
                if (set2 == null) {
                    return null;
                }
                DocIdSetIterator disi = set2.iterator();
                if (disi == null) {
                    return null;
                }
                return new ConstantScoreScorer((Weight)this, this.score(), disi);
            }

            @Override
            public BulkScorer bulkScorer(LeafReaderContext context, Bits acceptDocs) throws IOException {
                WeightOrBitSet weightOrBitSet = this.rewrite(context, acceptDocs);
                if (weightOrBitSet.weight != null) {
                    return weightOrBitSet.weight.bulkScorer(context, acceptDocs);
                }
                Scorer scorer = this.scorer(weightOrBitSet.bitset);
                if (scorer == null) {
                    return null;
                }
                return new Weight.DefaultBulkScorer(scorer);
            }

            @Override
            public Scorer scorer(LeafReaderContext context, Bits acceptDocs) throws IOException {
                WeightOrBitSet weightOrBitSet = this.rewrite(context, acceptDocs);
                if (weightOrBitSet.weight != null) {
                    return weightOrBitSet.weight.scorer(context, acceptDocs);
                }
                return this.scorer(weightOrBitSet.bitset);
            }
        };
    }

    private static class WeightOrBitSet {
        final Weight weight;
        final BitDocIdSet bitset;

        WeightOrBitSet(Weight weight) {
            this.weight = Objects.requireNonNull(weight);
            this.bitset = null;
        }

        WeightOrBitSet(BitDocIdSet bitset) {
            this.bitset = bitset;
            this.weight = null;
        }
    }

    private static class TermAndState {
        final String field;
        final TermsEnum termsEnum;
        final BytesRef term;
        final TermState state;
        final int docFreq;
        final long totalTermFreq;

        TermAndState(String field, TermsEnum termsEnum) throws IOException {
            this.field = field;
            this.termsEnum = termsEnum;
            this.term = BytesRef.deepCopyOf(termsEnum.term());
            this.state = termsEnum.termState();
            this.docFreq = termsEnum.docFreq();
            this.totalTermFreq = termsEnum.totalTermFreq();
        }
    }
}

