/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.util.Bits;

final class SingletonSortedNumericDocValues
extends SortedNumericDocValues {
    private final NumericDocValues in;
    private final Bits docsWithField;
    private long value;
    private int count;

    public SingletonSortedNumericDocValues(NumericDocValues in, Bits docsWithField) {
        this.in = in;
        this.docsWithField = docsWithField instanceof Bits.MatchAllBits ? null : docsWithField;
    }

    public NumericDocValues getNumericDocValues() {
        return this.in;
    }

    public Bits getDocsWithField() {
        return this.docsWithField;
    }

    @Override
    public void setDocument(int doc2) {
        this.value = this.in.get(doc2);
        this.count = this.docsWithField != null && this.value == 0L && !this.docsWithField.get(doc2) ? 0 : 1;
    }

    @Override
    public long valueAt(int index2) {
        return this.value;
    }

    @Override
    public int count() {
        return this.count;
    }
}

