/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsonldjava.utils;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.jsonldjava.utils.JarCacheStorage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.protocol.RequestAcceptEncoding;
import org.apache.http.client.protocol.ResponseContentEncoding;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.cache.BasicHttpCacheStorage;
import org.apache.http.impl.client.cache.CacheConfig;
import org.apache.http.impl.client.cache.CachingHttpClientBuilder;

public class JsonUtils {
    public static final String ACCEPT_HEADER = "application/ld+json, application/json;q=0.9, application/javascript;q=0.5, text/javascript;q=0.5, text/plain;q=0.2, */*;q=0.1";
    private static final ObjectMapper JSON_MAPPER = new ObjectMapper();
    private static final JsonFactory JSON_FACTORY = new JsonFactory(JSON_MAPPER);
    private static volatile CloseableHttpClient DEFAULT_HTTP_CLIENT;

    public static Object fromInputStream(InputStream input) throws IOException {
        return JsonUtils.fromInputStream(input, "UTF-8");
    }

    public static Object fromInputStream(InputStream input, String enc) throws IOException {
        return JsonUtils.fromReader(new BufferedReader(new InputStreamReader(input, enc)));
    }

    public static Object fromReader(Reader reader2) throws IOException {
        JsonToken t;
        Object rval;
        JsonParser jp = JSON_FACTORY.createParser(reader2);
        JsonToken initialToken = jp.nextToken();
        if (initialToken == JsonToken.START_ARRAY) {
            rval = jp.readValueAs(List.class);
        } else if (initialToken == JsonToken.START_OBJECT) {
            rval = jp.readValueAs(Map.class);
        } else if (initialToken == JsonToken.VALUE_STRING) {
            rval = jp.readValueAs(String.class);
        } else if (initialToken == JsonToken.VALUE_FALSE || initialToken == JsonToken.VALUE_TRUE) {
            rval = jp.readValueAs(Boolean.class);
        } else if (initialToken == JsonToken.VALUE_NUMBER_FLOAT || initialToken == JsonToken.VALUE_NUMBER_INT) {
            rval = jp.readValueAs(Number.class);
        } else if (initialToken == JsonToken.VALUE_NULL) {
            rval = null;
        } else {
            throw new JsonParseException("document doesn't start with a valid json element : " + (Object)((Object)initialToken), jp.getCurrentLocation());
        }
        try {
            t = jp.nextToken();
        }
        catch (JsonParseException ex) {
            throw new JsonParseException("Document contains more content after json-ld element - (possible mismatched {}?)", jp.getCurrentLocation());
        }
        if (t != null) {
            throw new JsonParseException("Document contains possible json content after the json-ld element - (possible mismatched {}?)", jp.getCurrentLocation());
        }
        return rval;
    }

    public static Object fromString(String jsonString) throws JsonParseException, IOException {
        return JsonUtils.fromReader(new StringReader(jsonString));
    }

    @Deprecated
    public static Object fromURL(URL url) throws JsonParseException, IOException {
        return JsonUtils.fromURL(url, JsonUtils.getDefaultHttpClient());
    }

    public static String toPrettyString(Object jsonObject) throws JsonGenerationException, IOException {
        StringWriter sw = new StringWriter();
        JsonUtils.writePrettyPrint(sw, jsonObject);
        return sw.toString();
    }

    public static String toString(Object jsonObject) throws JsonGenerationException, IOException {
        StringWriter sw = new StringWriter();
        JsonUtils.write(sw, jsonObject);
        return sw.toString();
    }

    public static void write(Writer writer2, Object jsonObject) throws JsonGenerationException, IOException {
        JsonGenerator jw = JSON_FACTORY.createGenerator(writer2);
        jw.writeObject(jsonObject);
    }

    public static void writePrettyPrint(Writer writer2, Object jsonObject) throws JsonGenerationException, IOException {
        JsonGenerator jw = JSON_FACTORY.createGenerator(writer2);
        jw.useDefaultPrettyPrinter();
        jw.writeObject(jsonObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputStream openStreamForURL(URL url, CloseableHttpClient httpClient) throws IOException {
        String protocol = url.getProtocol();
        if (!protocol.equalsIgnoreCase("http") && !protocol.equalsIgnoreCase("https")) {
            return url.openStream();
        }
        HttpGet request = new HttpGet(url.toExternalForm());
        request.addHeader("Accept", ACCEPT_HEADER);
        CloseableHttpResponse response = httpClient.execute(request);
        try {
            int status = response.getStatusLine().getStatusCode();
            if (status != 200 && status != 203) {
                throw new IOException("Can't retrieve " + url + ", status code: " + status);
            }
            InputStream inputStream = response.getEntity().getContent();
            return inputStream;
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object fromURL(URL url, CloseableHttpClient httpClient) throws JsonParseException, IOException {
        InputStream in = JsonUtils.openStreamForURL(url, httpClient);
        try {
            Object object = JsonUtils.fromInputStream(in);
            return object;
        }
        finally {
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CloseableHttpClient getDefaultHttpClient() {
        CloseableHttpClient result = DEFAULT_HTTP_CLIENT;
        if (result != null) return result;
        Class<JsonUtils> clazz = JsonUtils.class;
        synchronized (JsonUtils.class) {
            result = DEFAULT_HTTP_CLIENT;
            if (result != null) return result;
            DEFAULT_HTTP_CLIENT = JsonUtils.createDefaultHttpClient();
            return DEFAULT_HTTP_CLIENT;
        }
    }

    private static CloseableHttpClient createDefaultHttpClient() {
        CacheConfig cacheConfig = CacheConfig.custom().setMaxCacheEntries(1000).setMaxObjectSize(131072L).build();
        CloseableHttpClient result = CachingHttpClientBuilder.create().setCacheConfig(cacheConfig).setHttpCacheStorage(new JarCacheStorage(null, cacheConfig, new BasicHttpCacheStorage(cacheConfig))).addInterceptorFirst(new RequestAcceptEncoding()).addInterceptorFirst(new ResponseContentEncoding()).useSystemProperties().build();
        return result;
    }

    static {
        JSON_FACTORY.disable(JsonGenerator.Feature.AUTO_CLOSE_TARGET);
        JSON_FACTORY.disable(JsonFactory.Feature.INTERN_FIELD_NAMES);
        JSON_FACTORY.disable(JsonFactory.Feature.CANONICALIZE_FIELD_NAMES);
    }
}

