/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.memory;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.util.Arrays;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.eclipse.rdf4j.common.io.IOUtil;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Namespace;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.util.Literals;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.base.SailDataset;
import org.eclipse.rdf4j.sail.base.SailSink;
import org.eclipse.rdf4j.sail.memory.model.MemIRI;
import org.eclipse.rdf4j.sail.memory.model.MemResource;
import org.eclipse.rdf4j.sail.memory.model.MemValue;

class FileIO {
    private static final byte[] MAGIC_NUMBER = new byte[]{66, 77, 83, 70};
    private static final int BMSF_VERSION = 2;
    public static final int NAMESPACE_MARKER = 1;
    public static final int EXPL_TRIPLE_MARKER = 2;
    public static final int EXPL_QUAD_MARKER = 3;
    public static final int INF_TRIPLE_MARKER = 4;
    public static final int INF_QUAD_MARKER = 5;
    public static final int URI_MARKER = 6;
    public static final int BNODE_MARKER = 7;
    public static final int PLAIN_LITERAL_MARKER = 8;
    public static final int LANG_LITERAL_MARKER = 9;
    public static final int DATATYPE_LITERAL_MARKER = 10;
    public static final int EOF_MARKER = 127;
    private final ValueFactory vf;
    private final CharsetEncoder charsetEncoder = Charset.forName("UTF-8").newEncoder();
    private final CharsetDecoder charsetDecoder = Charset.forName("UTF-8").newDecoder();
    private int formatVersion;

    public FileIO(ValueFactory vf) {
        this.vf = vf;
    }

    public synchronized void write(SailDataset explicit, SailDataset inferred, File syncFile, File dataFile) throws IOException, SailException {
        this.write(explicit, inferred, syncFile);
        boolean renamed = syncFile.renameTo(dataFile);
        if (!renamed && syncFile.exists() && dataFile.exists()) {
            dataFile.delete();
            renamed = syncFile.renameTo(dataFile);
        }
        if (!renamed) {
            String path2 = syncFile.getAbsolutePath();
            String name2 = dataFile.getName();
            throw new IOException("Could not rename " + path2 + " to " + name2);
        }
    }

    private void write(SailDataset explicit, SailDataset inferred, File dataFile) throws IOException, SailException {
        try (FileOutputStream out = new FileOutputStream(dataFile);){
            ((OutputStream)out).write(MAGIC_NUMBER);
            ((OutputStream)out).write(2);
            out.flush();
            try (DataOutputStream dataOut = new DataOutputStream(new GZIPOutputStream(out));){
                this.writeNamespaces(explicit, dataOut);
                this.writeStatements(explicit, inferred, dataOut);
                dataOut.writeByte(127);
            }
        }
    }

    public synchronized void read(File dataFile, SailSink explicit, SailSink inferred) throws IOException, SailException {
        try (FileInputStream in = new FileInputStream(dataFile);){
            byte[] magicNumber = IOUtil.readBytes((InputStream)in, MAGIC_NUMBER.length);
            if (!Arrays.equals(magicNumber, MAGIC_NUMBER)) {
                throw new IOException("File is not a binary MemoryStore file");
            }
            this.formatVersion = ((InputStream)in).read();
            if (this.formatVersion > 2 || this.formatVersion < 1) {
                throw new IOException("Incompatible format version: " + this.formatVersion);
            }
            try (DataInputStream dataIn = new DataInputStream(new GZIPInputStream(in));){
                byte recordTypeMarker;
                block25: while ((recordTypeMarker = dataIn.readByte()) != 127) {
                    switch (recordTypeMarker) {
                        case 1: {
                            this.readNamespace(dataIn, explicit);
                            continue block25;
                        }
                        case 2: {
                            this.readStatement(false, true, dataIn, explicit, inferred);
                            continue block25;
                        }
                        case 3: {
                            this.readStatement(true, true, dataIn, explicit, inferred);
                            continue block25;
                        }
                        case 4: {
                            this.readStatement(false, false, dataIn, explicit, inferred);
                            continue block25;
                        }
                        case 5: {
                            this.readStatement(true, false, dataIn, explicit, inferred);
                            continue block25;
                        }
                    }
                    throw new IOException("Invalid record type marker: " + recordTypeMarker);
                }
            }
        }
    }

    private void writeNamespaces(SailDataset store, DataOutputStream dataOut) throws IOException, SailException {
        try (CloseableIteration<? extends Namespace, SailException> iter = store.getNamespaces();){
            while (iter.hasNext()) {
                Namespace ns2 = (Namespace)iter.next();
                dataOut.writeByte(1);
                this.writeString(ns2.getPrefix(), dataOut);
                this.writeString(ns2.getName(), dataOut);
            }
        }
    }

    private void readNamespace(DataInputStream dataIn, SailSink store) throws IOException, SailException {
        String prefix = this.readString(dataIn);
        String name2 = this.readString(dataIn);
        if (this.formatVersion <= 1) {
            dataIn.readBoolean();
        }
        store.setNamespace(prefix, name2);
    }

    private void writeStatements(SailDataset explicit, SailDataset inferred, DataOutputStream dataOut) throws IOException, SailException {
        this.writeStatement(explicit.getStatements(null, null, null, new Resource[0]), 2, 3, dataOut);
        this.writeStatement(inferred.getStatements(null, null, null, new Resource[0]), 4, 5, dataOut);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeStatement(CloseableIteration<? extends Statement, SailException> stIter, int tripleMarker, int quadMarker, DataOutputStream dataOut) throws IOException, SailException {
        try {
            while (stIter.hasNext()) {
                Statement st = (Statement)stIter.next();
                Resource context = st.getContext();
                if (context == null) {
                    dataOut.writeByte(tripleMarker);
                } else {
                    dataOut.writeByte(quadMarker);
                }
                this.writeValue(st.getSubject(), dataOut);
                this.writeValue(st.getPredicate(), dataOut);
                this.writeValue(st.getObject(), dataOut);
                if (context == null) continue;
                this.writeValue(context, dataOut);
            }
        }
        finally {
            stIter.close();
        }
    }

    private void readStatement(boolean hasContext, boolean isExplicit, DataInputStream dataIn, SailSink explicit, SailSink inferred) throws IOException, ClassCastException, SailException {
        MemResource memSubj = (MemResource)this.readValue(dataIn);
        MemIRI memPred = (MemIRI)this.readValue(dataIn);
        MemValue memObj = (MemValue)this.readValue(dataIn);
        MemResource memContext = null;
        if (hasContext) {
            memContext = (MemResource)this.readValue(dataIn);
        }
        if (isExplicit) {
            explicit.approve(memSubj, memPred, memObj, memContext);
        } else {
            inferred.approve(memSubj, memPred, memObj, memContext);
        }
    }

    private void writeValue(Value value, DataOutputStream dataOut) throws IOException {
        if (value instanceof IRI) {
            dataOut.writeByte(6);
            this.writeString(((IRI)value).toString(), dataOut);
        } else if (value instanceof BNode) {
            dataOut.writeByte(7);
            this.writeString(((BNode)value).getID(), dataOut);
        } else if (value instanceof Literal) {
            Literal lit = (Literal)value;
            String label = lit.getLabel();
            IRI datatype = lit.getDatatype();
            if (Literals.isLanguageLiteral(lit)) {
                dataOut.writeByte(9);
                this.writeString(label, dataOut);
                this.writeString(lit.getLanguage().get(), dataOut);
            } else {
                dataOut.writeByte(10);
                this.writeString(label, dataOut);
                this.writeValue(datatype, dataOut);
            }
        } else {
            throw new IllegalArgumentException("unexpected value type: " + value.getClass());
        }
    }

    private Value readValue(DataInputStream dataIn) throws IOException, ClassCastException {
        byte valueTypeMarker = dataIn.readByte();
        if (valueTypeMarker == 6) {
            String uriString = this.readString(dataIn);
            return this.vf.createIRI(uriString);
        }
        if (valueTypeMarker == 7) {
            String bnodeID = this.readString(dataIn);
            return this.vf.createBNode(bnodeID);
        }
        if (valueTypeMarker == 8) {
            String label = this.readString(dataIn);
            return this.vf.createLiteral(label);
        }
        if (valueTypeMarker == 9) {
            String label = this.readString(dataIn);
            String language = this.readString(dataIn);
            return this.vf.createLiteral(label, language);
        }
        if (valueTypeMarker == 10) {
            String label = this.readString(dataIn);
            IRI datatype = (IRI)this.readValue(dataIn);
            return this.vf.createLiteral(label, datatype);
        }
        throw new IOException("Invalid value type marker: " + valueTypeMarker);
    }

    private void writeString(String s, DataOutputStream dataOut) throws IOException {
        ByteBuffer byteBuf = this.charsetEncoder.encode(CharBuffer.wrap(s));
        dataOut.writeInt(byteBuf.remaining());
        dataOut.write(byteBuf.array(), 0, byteBuf.remaining());
    }

    private String readString(DataInputStream dataIn) throws IOException {
        if (this.formatVersion == 1) {
            return this.readStringV1(dataIn);
        }
        return this.readStringV2(dataIn);
    }

    private String readStringV1(DataInputStream dataIn) throws IOException {
        return dataIn.readUTF();
    }

    private String readStringV2(DataInputStream dataIn) throws IOException {
        int stringLength = dataIn.readInt();
        byte[] encodedString = IOUtil.readBytes((InputStream)dataIn, stringLength);
        if (encodedString.length != stringLength) {
            throw new EOFException("Attempted to read " + stringLength + " bytes but no more than " + encodedString.length + " were available");
        }
        ByteBuffer byteBuf = ByteBuffer.wrap(encodedString);
        CharBuffer charBuf = this.charsetDecoder.decode(byteBuf);
        return charBuf.toString();
    }
}

