/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.lucene.config;

import java.util.Properties;
import java.util.Set;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.util.Models;
import org.eclipse.rdf4j.sail.config.AbstractDelegatingSailImplConfig;
import org.eclipse.rdf4j.sail.config.SailConfigException;
import org.eclipse.rdf4j.sail.config.SailImplConfig;
import org.eclipse.rdf4j.sail.lucene.config.LuceneSailConfigSchema;

public abstract class AbstractLuceneSailConfig
extends AbstractDelegatingSailImplConfig {
    private String indexDir;
    private Properties parameters = new Properties();

    protected AbstractLuceneSailConfig(String type2) {
        super(type2);
    }

    protected AbstractLuceneSailConfig(String type2, SailImplConfig delegate) {
        super(type2, delegate);
    }

    protected AbstractLuceneSailConfig(String type2, String luceneDir) {
        super(type2);
        this.setIndexDir(luceneDir);
    }

    protected AbstractLuceneSailConfig(String type2, String luceneDir, SailImplConfig delegate) {
        super(type2, delegate);
        this.setIndexDir(luceneDir);
    }

    public String getIndexDir() {
        return this.indexDir;
    }

    public void setIndexDir(String luceneDir) {
        this.indexDir = luceneDir;
    }

    public String getParameter(String key2) {
        return this.parameters.getProperty(key2);
    }

    public void setParameter(String key2, String value) {
        this.parameters.setProperty(key2, value);
    }

    public Set<String> getParameterNames() {
        return this.parameters.stringPropertyNames();
    }

    @Override
    public Resource export(Model m) {
        Resource implNode = super.export(m);
        SimpleValueFactory vf = SimpleValueFactory.getInstance();
        if (this.indexDir != null) {
            m.add(implNode, LuceneSailConfigSchema.INDEX_DIR, (Value)SimpleValueFactory.getInstance().createLiteral(this.indexDir), new Resource[0]);
        }
        for (String key2 : this.getParameterNames()) {
            m.add(implNode, vf.createIRI("http://www.openrdf.org/config/sail/lucene#", key2), (Value)vf.createLiteral(this.getParameter(key2)), new Resource[0]);
        }
        return implNode;
    }

    @Override
    public void parse(Model graph, Resource implNode) throws SailConfigException {
        super.parse(graph, implNode);
        Literal indexDirLit = Models.objectLiteral(graph.filter(implNode, LuceneSailConfigSchema.INDEX_DIR, null, new Resource[0])).orElseThrow(() -> new SailConfigException("no value found for " + LuceneSailConfigSchema.INDEX_DIR));
        this.setIndexDir(indexDirLit.getLabel());
        for (Statement stmt : graph.filter(implNode, null, null, new Resource[0])) {
            if (!stmt.getPredicate().getNamespace().equals("http://www.openrdf.org/config/sail/lucene#") || !(stmt.getObject() instanceof Literal)) continue;
            String key2 = stmt.getPredicate().getLocalName();
            this.setParameter(key2, stmt.getObject().stringValue());
        }
    }
}

