/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.rio.trig;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.turtle.TurtleWriter;

public class TriGWriter
extends TurtleWriter {
    private boolean inActiveContext;
    private Resource currentContext;

    public TriGWriter(OutputStream out) {
        super(out);
    }

    public TriGWriter(Writer writer2) {
        super(writer2);
    }

    @Override
    public RDFFormat getRDFFormat() {
        return RDFFormat.TRIG;
    }

    @Override
    public void startRDF() throws RDFHandlerException {
        super.startRDF();
        this.inActiveContext = false;
        this.currentContext = null;
    }

    @Override
    public void endRDF() throws RDFHandlerException {
        super.endRDF();
        try {
            this.closeActiveContext();
            this.writer.flush();
        }
        catch (IOException e2) {
            throw new RDFHandlerException(e2);
        }
    }

    @Override
    public void handleStatement(Statement st) throws RDFHandlerException {
        if (!this.writingStarted) {
            throw new RuntimeException("Document writing has not yet been started");
        }
        if (this.prettyPrintModel != null) {
            this.prettyPrintModel.add(st);
        } else {
            this.handleStatementInternal(st, false, false, false);
        }
    }

    @Override
    protected void handleStatementInternal(Statement st, boolean endRDFCalled, boolean canShortenSubject, boolean canShortenObject) {
        if (this.prettyPrintModel != null && !endRDFCalled) {
            this.prettyPrintModel.add(st);
            return;
        }
        try {
            Resource context = st.getContext();
            if (this.inActiveContext && !TriGWriter.contextsEquals(context, this.currentContext)) {
                this.closePreviousStatement();
                this.closeActiveContext();
            }
            if (!this.inActiveContext) {
                this.writer.writeEOL();
                if (context != null) {
                    boolean canShortenContext = false;
                    if (context instanceof BNode && this.prettyPrintModel != null && !this.prettyPrintModel.contains(context, null, null, new Resource[0]) && !this.prettyPrintModel.contains(null, null, (Value)context, new Resource[0])) {
                        canShortenContext = true;
                    }
                    this.writeResource(context, canShortenContext);
                    this.writer.write(" ");
                }
                this.writer.write("{");
                this.writer.increaseIndentation();
                this.currentContext = context;
                this.inActiveContext = true;
            }
        }
        catch (IOException e2) {
            throw new RDFHandlerException(e2);
        }
        super.handleStatementInternal(st, true, canShortenSubject, canShortenObject);
    }

    @Override
    protected void writeCommentLine(String line) throws IOException {
        super.writeCommentLine(line);
    }

    @Override
    protected void writeNamespace(String prefix, String name2) throws IOException {
        if (this.currentContext == null || this.currentContext instanceof BNode) {
            // empty if block
        }
        this.closeActiveContext();
        super.writeNamespace(prefix, name2);
    }

    protected void closeActiveContext() throws IOException {
        if (this.inActiveContext) {
            this.writer.decreaseIndentation();
            this.writer.write("}");
            this.writer.writeEOL();
            this.inActiveContext = false;
            this.currentContext = null;
        }
    }

    private static final boolean contextsEquals(Resource context1, Resource context2) {
        if (context1 == null) {
            return context2 == null;
        }
        return context1.equals(context2);
    }
}

