/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.impl;

import java.util.Collection;
import java.util.UUID;
import org.eclipse.rdf4j.query.algebra.ArbitraryLengthPath;
import org.eclipse.rdf4j.query.algebra.BinaryTupleOperator;
import org.eclipse.rdf4j.query.algebra.BindingSetAssignment;
import org.eclipse.rdf4j.query.algebra.EmptySet;
import org.eclipse.rdf4j.query.algebra.Join;
import org.eclipse.rdf4j.query.algebra.LeftJoin;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.Service;
import org.eclipse.rdf4j.query.algebra.SingletonSet;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.UnaryTupleOperator;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.algebra.ZeroLengthPath;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.ExternalSet;
import org.eclipse.rdf4j.query.algebra.helpers.AbstractQueryModelVisitor;

public class EvaluationStatistics {
    protected CardinalityCalculator cc;

    public synchronized double getCardinality(TupleExpr expr) {
        if (this.cc == null) {
            this.cc = this.createCardinalityCalculator();
        }
        expr.visit(this.cc);
        return this.cc.getCardinality();
    }

    protected CardinalityCalculator createCardinalityCalculator() {
        return new CardinalityCalculator();
    }

    private static class ServiceNodeAnalyzer
    extends AbstractQueryModelVisitor<RuntimeException> {
        private int count = 0;

        private ServiceNodeAnalyzer() {
        }

        public int getStatementCount() {
            return this.count;
        }

        @Override
        public void meet(StatementPattern node2) throws RuntimeException {
            ++this.count;
        }
    }

    protected static class CardinalityCalculator
    extends AbstractQueryModelVisitor<RuntimeException> {
        private static double VAR_CARDINALITY = 10.0;
        private static double UNBOUND_SERVICE_CARDINALITY = 100000.0;
        protected double cardinality;

        protected CardinalityCalculator() {
        }

        public double getCardinality() {
            return this.cardinality;
        }

        @Override
        public void meet(EmptySet node2) {
            this.cardinality = 0.0;
        }

        @Override
        public void meet(SingletonSet node2) {
            this.cardinality = 1.0;
        }

        @Override
        public void meet(BindingSetAssignment node2) {
            this.cardinality = 1.0;
        }

        @Override
        public void meet(ZeroLengthPath node2) {
            Var subjVar = node2.getSubjectVar();
            Var objVar = node2.getObjectVar();
            this.cardinality = subjVar != null && subjVar.hasValue() || objVar != null && objVar.hasValue() ? 1.0 : this.getSubjectCardinality(subjVar) * this.getObjectCardinality(objVar) * this.getContextCardinality(node2.getContextVar());
        }

        @Override
        public void meet(ArbitraryLengthPath node2) {
            Var pathVar = new Var("_anon_" + UUID.randomUUID().toString().replaceAll("-", "_"));
            pathVar.setAnonymous(true);
            this.cardinality = 2.0 * this.getCardinality(new StatementPattern(node2.getSubjectVar(), pathVar, node2.getObjectVar(), node2.getContextVar()));
        }

        @Override
        public void meet(Service node2) {
            if (!node2.getServiceRef().hasValue()) {
                this.cardinality = UNBOUND_SERVICE_CARDINALITY;
            } else {
                ServiceNodeAnalyzer serviceAnalyzer = new ServiceNodeAnalyzer();
                node2.visitChildren(serviceAnalyzer);
                int count2 = serviceAnalyzer.getStatementCount();
                this.cardinality = count2 == 1 && node2.getServiceVars().size() > 1 ? (double)(100 + node2.getServiceVars().size()) : 1.0 + (double)node2.getServiceVars().size() * 0.1;
            }
        }

        @Override
        public void meet(StatementPattern sp) {
            this.cardinality = this.getCardinality(sp);
        }

        protected double getCardinality(StatementPattern sp) {
            return this.getSubjectCardinality(sp) * this.getPredicateCardinality(sp) * this.getObjectCardinality(sp) * this.getContextCardinality(sp);
        }

        protected double getSubjectCardinality(StatementPattern sp) {
            return this.getSubjectCardinality(sp.getSubjectVar());
        }

        protected double getSubjectCardinality(Var var) {
            return this.getCardinality(VAR_CARDINALITY, var);
        }

        protected double getPredicateCardinality(StatementPattern sp) {
            return this.getPredicateCardinality(sp.getPredicateVar());
        }

        protected double getPredicateCardinality(Var var) {
            return this.getCardinality(VAR_CARDINALITY, var);
        }

        protected double getObjectCardinality(StatementPattern sp) {
            return this.getObjectCardinality(sp.getObjectVar());
        }

        protected double getObjectCardinality(Var var) {
            return this.getCardinality(VAR_CARDINALITY, var);
        }

        protected double getContextCardinality(StatementPattern sp) {
            return this.getContextCardinality(sp.getContextVar());
        }

        protected double getContextCardinality(Var var) {
            return this.getCardinality(VAR_CARDINALITY, var);
        }

        protected double getCardinality(double varCardinality, Var var) {
            return var == null || var.hasValue() ? 1.0 : varCardinality;
        }

        protected double getCardinality(double varCardinality, Collection<Var> vars) {
            int constantVarCount = this.countConstantVars(vars);
            double unboundVarFactor = vars.size() - constantVarCount;
            return Math.pow(varCardinality, unboundVarFactor);
        }

        protected int countConstantVars(Iterable<Var> vars) {
            int constantVarCount = 0;
            for (Var var : vars) {
                if (!var.hasValue()) continue;
                ++constantVarCount;
            }
            return constantVarCount;
        }

        @Override
        public void meet(Join node2) {
            node2.getLeftArg().visit(this);
            double leftArgCost = this.cardinality;
            node2.getRightArg().visit(this);
            this.cardinality *= leftArgCost;
        }

        @Override
        public void meet(LeftJoin node2) {
            node2.getLeftArg().visit(this);
            double leftArgCost = this.cardinality;
            node2.getRightArg().visit(this);
            this.cardinality *= leftArgCost;
        }

        @Override
        protected void meetBinaryTupleOperator(BinaryTupleOperator node2) {
            node2.getLeftArg().visit(this);
            double leftArgCost = this.cardinality;
            node2.getRightArg().visit(this);
            this.cardinality += leftArgCost;
        }

        @Override
        protected void meetUnaryTupleOperator(UnaryTupleOperator node2) {
            node2.getArg().visit(this);
        }

        @Override
        protected void meetNode(QueryModelNode node2) {
            if (!(node2 instanceof ExternalSet)) {
                throw new IllegalArgumentException("Unhandled node type: " + node2.getClass());
            }
            this.meetExternalSet((ExternalSet)node2);
        }

        protected void meetExternalSet(ExternalSet node2) {
            this.cardinality = node2.cardinality();
        }
    }
}

