/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.function.datetime;

import javax.xml.datatype.XMLGregorianCalendar;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.datatypes.XMLDatatypeUtil;
import org.eclipse.rdf4j.model.vocabulary.FN;
import org.eclipse.rdf4j.model.vocabulary.XMLSchema;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.function.Function;

public class Minutes
implements Function {
    @Override
    public String getURI() {
        return FN.MINUTES_FROM_DATETIME.toString();
    }

    @Override
    public Literal evaluate(ValueFactory valueFactory, Value ... args) throws ValueExprEvaluationException {
        if (args.length != 1) {
            throw new ValueExprEvaluationException("MINUTES requires 1 argument, got " + args.length);
        }
        Value argValue = args[0];
        if (argValue instanceof Literal) {
            Literal literal = (Literal)argValue;
            IRI datatype = literal.getDatatype();
            if (datatype != null && XMLDatatypeUtil.isCalendarDatatype(datatype)) {
                try {
                    XMLGregorianCalendar calValue = literal.calendarValue();
                    int minutes = calValue.getMinute();
                    if (Integer.MIN_VALUE != minutes) {
                        return valueFactory.createLiteral(String.valueOf(minutes), XMLSchema.INTEGER);
                    }
                    throw new ValueExprEvaluationException("can not determine minutes from value: " + argValue);
                }
                catch (IllegalArgumentException e2) {
                    throw new ValueExprEvaluationException("illegal calendar value: " + argValue);
                }
            }
            throw new ValueExprEvaluationException("unexpected input value for function: " + argValue);
        }
        throw new ValueExprEvaluationException("unexpected input value for function: " + args[0]);
    }
}

