/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.common.xml;

import javax.xml.parsers.SAXParserFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class XMLReaderFactory {
    public static final String XERCES_SAXPARSER = "org.apache.xerces.parsers.SAXParser";

    public static XMLReader createXMLReader() throws SAXException {
        Logger logger = LoggerFactory.getLogger(XMLReader.class);
        XMLReader reader2 = null;
        String xmlReaderName = System.getProperty("org.xml.sax.driver");
        if (xmlReaderName != null) {
            try {
                reader2 = XMLReaderFactory._createXMLReader(xmlReaderName);
            }
            catch (ClassNotFoundException e2) {
                logger.warn("Class " + xmlReaderName + " not found");
            }
            catch (ClassCastException e3) {
                logger.warn(xmlReaderName + " is not a valid XMLReader.");
            }
            catch (Exception e4) {
                logger.warn("could not create instance of " + xmlReaderName);
            }
            logger.debug("XMLReader initialized using system property: " + xmlReaderName);
        }
        if (reader2 == null) {
            try {
                SAXParserFactory factory = SAXParserFactory.newInstance();
                factory.setNamespaceAware(true);
                reader2 = factory.newSAXParser().getXMLReader();
            }
            catch (NoClassDefFoundError e5) {
                logger.warn("javax.xml.parsers.SAXParserFactory not available");
            }
            catch (Exception e6) {
                logger.warn("Failed to initialize XMLReader through JAXP");
            }
            logger.debug("XMLReader initialized using JAXP: " + reader2);
        }
        if (reader2 == null) {
            try {
                reader2 = XMLReaderFactory._createXMLReader(XERCES_SAXPARSER);
            }
            catch (ClassNotFoundException e7) {
                String message = "Class org.apache.xerces.parsers.SAXParser not found";
                logger.error(message);
                throw new SAXException(message);
            }
            catch (ClassCastException e8) {
                String message = "org.apache.xerces.parsers.SAXParser is not a valid XMLReader.";
                logger.error(message);
                throw new SAXException(message);
            }
            catch (Exception e9) {
                String message = "Could not create instance of org.apache.xerces.parsers.SAXParser";
                logger.error(message);
                throw new SAXException(message);
            }
            logger.debug("XMLReader initialized using default Xerces SAX parser org.apache.xerces.parsers.SAXParser");
        }
        return reader2;
    }

    public static XMLReader createXMLReader(String name2) throws SAXException {
        Logger logger = LoggerFactory.getLogger(XMLReader.class);
        XMLReader reader2 = null;
        try {
            reader2 = XMLReaderFactory._createXMLReader(name2);
        }
        catch (ClassNotFoundException e2) {
            logger.error("Class " + name2 + " not found");
            throw new SAXException(e2);
        }
        catch (ClassCastException e3) {
            logger.error(name2 + " is not a valid XMLReader.");
            throw new SAXException(e3);
        }
        catch (Exception e4) {
            logger.error("Could not create instance of " + name2);
            throw new SAXException(e4);
        }
        return reader2;
    }

    protected static XMLReader _createXMLReader(String name2) throws ClassNotFoundException, ClassCastException, InstantiationException, IllegalAccessException {
        return (XMLReader)Class.forName(name2).newInstance();
    }
}

