/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.OverlappingFileLockException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.FSLockFactory;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.LockObtainFailedException;
import org.apache.lucene.util.IOUtils;

public final class NativeFSLockFactory
extends FSLockFactory {
    public static final NativeFSLockFactory INSTANCE = new NativeFSLockFactory();

    private NativeFSLockFactory() {
    }

    @Override
    protected Lock makeFSLock(FSDirectory dir2, String lockName) {
        return new NativeFSLock(dir2.getDirectory(), lockName);
    }

    static final class NativeFSLock
    extends Lock {
        private final Path path;
        private final Path lockDir;
        private static final Set<String> LOCK_HELD = Collections.synchronizedSet(new HashSet());
        private FileChannel channel;
        private Path realPath;

        public NativeFSLock(Path lockDir, String lockFileName) {
            this.lockDir = lockDir;
            this.path = lockDir.resolve(lockFileName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public synchronized boolean obtain() throws IOException {
            if (this.channel != null) {
                assert (this.channel.isOpen());
                if ($assertionsDisabled) throw new LockObtainFailedException("this lock instance was already obtained");
                if (this.realPath != null) throw new LockObtainFailedException("this lock instance was already obtained");
                throw new AssertionError();
            }
            Files.createDirectories(this.lockDir, new FileAttribute[0]);
            try {
                Files.createFile(this.path, new FileAttribute[0]);
            }
            catch (IOException ignore) {
                // empty catch block
            }
            this.realPath = this.path.toRealPath(new LinkOption[0]);
            boolean obtained = false;
            if (!LOCK_HELD.add(this.realPath.toString())) return obtained;
            FileChannel ch = null;
            try {
                ch = FileChannel.open(this.realPath, StandardOpenOption.CREATE, StandardOpenOption.WRITE);
                try {
                    if (ch.tryLock() != null) {
                        this.channel = ch;
                        return true;
                    }
                }
                catch (IOException | OverlappingFileLockException e2) {
                    this.failureReason = e2;
                }
                if (obtained) return obtained;
            }
            catch (Throwable throwable) {
                if (obtained) throw throwable;
                IOUtils.closeWhileHandlingException(ch);
                NativeFSLock.clearLockHeld(this.realPath);
                throw throwable;
            }
            IOUtils.closeWhileHandlingException(ch);
            NativeFSLock.clearLockHeld(this.realPath);
            return obtained;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void close() throws IOException {
            if (this.channel != null) {
                try {
                    IOUtils.close(this.channel);
                }
                finally {
                    this.channel = null;
                    NativeFSLock.clearLockHeld(this.realPath);
                }
            }
        }

        private static final void clearLockHeld(Path path2) {
            boolean remove2 = LOCK_HELD.remove(path2.toString());
            assert (remove2) : "Lock was cleared but never marked as held";
        }

        @Override
        public synchronized boolean isLocked() {
            if (this.channel != null) {
                return true;
            }
            if (Files.notExists(this.path, new LinkOption[0])) {
                return false;
            }
            try {
                boolean obtained = this.obtain();
                if (obtained) {
                    this.close();
                }
                return !obtained;
            }
            catch (IOException ioe) {
                return false;
            }
        }

        public String toString() {
            return "NativeFSLock@" + this.path;
        }
    }
}

