/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spans;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import org.apache.lucene.search.spans.FilterSpans;
import org.apache.lucene.search.spans.SpanNearQuery;
import org.apache.lucene.search.spans.SpanPositionCheckQuery;
import org.apache.lucene.search.spans.Spans;
import org.apache.lucene.util.ToStringUtils;

public class SpanNearPayloadCheckQuery
extends SpanPositionCheckQuery {
    protected final Collection<byte[]> payloadToMatch;

    public SpanNearPayloadCheckQuery(SpanNearQuery match, Collection<byte[]> payloadToMatch) {
        super(match);
        this.payloadToMatch = Objects.requireNonNull(payloadToMatch);
    }

    @Override
    protected FilterSpans.AcceptStatus acceptPosition(Spans spans) throws IOException {
        boolean result = spans.isPayloadAvailable();
        if (result) {
            Collection<byte[]> candidate = spans.getPayload();
            if (candidate.size() == this.payloadToMatch.size()) {
                int matches = 0;
                block0: for (byte[] candBytes : candidate) {
                    for (byte[] payBytes : this.payloadToMatch) {
                        if (!Arrays.equals(candBytes, payBytes)) continue;
                        ++matches;
                        continue block0;
                    }
                }
                if (matches == this.payloadToMatch.size()) {
                    return FilterSpans.AcceptStatus.YES;
                }
                return FilterSpans.AcceptStatus.NO;
            }
            return FilterSpans.AcceptStatus.NO;
        }
        return FilterSpans.AcceptStatus.NO;
    }

    @Override
    public String toString(String field) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("spanPayCheck(");
        buffer.append(this.match.toString(field));
        buffer.append(", payloadRef: ");
        for (byte[] bytes2 : this.payloadToMatch) {
            ToStringUtils.byteArray(buffer, bytes2);
            buffer.append(';');
        }
        buffer.append(")");
        buffer.append(ToStringUtils.boost(this.getBoost()));
        return buffer.toString();
    }

    @Override
    public SpanNearPayloadCheckQuery clone() {
        SpanNearPayloadCheckQuery result = new SpanNearPayloadCheckQuery((SpanNearQuery)this.match.clone(), this.payloadToMatch);
        result.setBoost(this.getBoost());
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        SpanNearPayloadCheckQuery other = (SpanNearPayloadCheckQuery)o;
        return this.payloadToMatch.equals(other.payloadToMatch);
    }

    @Override
    public int hashCode() {
        int h = super.hashCode();
        h = h * 15 ^ this.payloadToMatch.hashCode();
        return h;
    }
}

