/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.index.TermState;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TermAutomatonScorer;
import org.apache.lucene.search.TermStatistics;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.Operations;
import org.apache.lucene.util.automaton.Transition;

public class TermAutomatonQuery
extends Query {
    private final String field;
    private final Automaton.Builder builder;
    Automaton det;
    private final Map<BytesRef, Integer> termToID = new HashMap<BytesRef, Integer>();
    private final Map<Integer, BytesRef> idToTerm = new HashMap<Integer, BytesRef>();
    private int anyTermID = -1;

    public TermAutomatonQuery(String field) {
        this.field = field;
        this.builder = new Automaton.Builder();
    }

    public int createState() {
        return this.builder.createState();
    }

    public void setAccept(int state, boolean accept) {
        this.builder.setAccept(state, accept);
    }

    public void addTransition(int source2, int dest, String term) {
        this.addTransition(source2, dest, new BytesRef(term));
    }

    public void addTransition(int source2, int dest, BytesRef term) {
        if (term == null) {
            throw new NullPointerException("term should not be null");
        }
        this.builder.addTransition(source2, dest, this.getTermID(term));
    }

    public void addAnyTransition(int source2, int dest) {
        this.builder.addTransition(source2, dest, this.getTermID(null));
    }

    public void finish() {
        this.finish(10000);
    }

    public void finish(int maxDeterminizedStates) {
        Automaton automaton = this.builder.finish();
        Transition t = new Transition();
        if (this.anyTermID != -1) {
            int i;
            int count2 = automaton.initTransition(0, t);
            for (int i2 = 0; i2 < count2; ++i2) {
                automaton.getNextTransition(t);
                if (this.anyTermID < t.min || this.anyTermID > t.max) continue;
                throw new IllegalStateException("automaton cannot lead with an ANY transition");
            }
            int numStates = automaton.getNumStates();
            for (int i3 = 0; i3 < numStates; ++i3) {
                count2 = automaton.initTransition(i3, t);
                for (int j = 0; j < count2; ++j) {
                    automaton.getNextTransition(t);
                    if (!automaton.isAccept(t.dest) || this.anyTermID < t.min || this.anyTermID > t.max) continue;
                    throw new IllegalStateException("automaton cannot end with an ANY transition");
                }
            }
            int termCount = this.termToID.size();
            Automaton newAutomaton = new Automaton();
            for (i = 0; i < numStates; ++i) {
                newAutomaton.createState();
                newAutomaton.setAccept(i, automaton.isAccept(i));
            }
            for (i = 0; i < numStates; ++i) {
                count2 = automaton.initTransition(i, t);
                for (int j = 0; j < count2; ++j) {
                    int max2;
                    int min2;
                    automaton.getNextTransition(t);
                    if (t.min <= this.anyTermID && this.anyTermID <= t.max) {
                        min2 = 0;
                        max2 = termCount - 1;
                    } else {
                        min2 = t.min;
                        max2 = t.max;
                    }
                    newAutomaton.addTransition(t.source, t.dest, min2, max2);
                }
            }
            newAutomaton.finishState();
            automaton = newAutomaton;
        }
        this.det = Operations.removeDeadStates(Operations.determinize(automaton, maxDeterminizedStates));
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        IndexReaderContext context = searcher.getTopReaderContext();
        HashMap<Integer, TermContext> termStates = new HashMap<Integer, TermContext>();
        for (Map.Entry<BytesRef, Integer> ent : this.termToID.entrySet()) {
            if (ent.getKey() == null) continue;
            termStates.put(ent.getValue(), TermContext.build(context, new Term(this.field, ent.getKey())));
        }
        return new TermAutomatonWeight(this.det, searcher, termStates);
    }

    @Override
    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        sb.append("TermAutomatonQuery(field=");
        sb.append(this.field);
        if (this.det != null) {
            sb.append(" numStates=");
            sb.append(this.det.getNumStates());
        }
        sb.append(')');
        return sb.toString();
    }

    private int getTermID(BytesRef term) {
        Integer id = this.termToID.get(term);
        if (id == null) {
            id = this.termToID.size();
            if (term != null) {
                term = BytesRef.deepCopyOf(term);
            }
            this.termToID.put(term, id);
            this.idToTerm.put(id, term);
            if (term == null) {
                this.anyTermID = id;
            }
        }
        return id;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof TermAutomatonQuery)) {
            return false;
        }
        TermAutomatonQuery other = (TermAutomatonQuery)o;
        if (this.det == null) {
            throw new IllegalStateException("please call finish first");
        }
        if (other.det == null) {
            throw new IllegalStateException("please call other.finish first");
        }
        return super.equals(o) && this.termToID.equals(other.termToID) && Operations.sameLanguage(this.det, other.det);
    }

    @Override
    public int hashCode() {
        if (this.det == null) {
            throw new IllegalStateException("please call finish first");
        }
        return super.hashCode() ^ this.termToID.hashCode() + this.det.toDot().hashCode();
    }

    public String toDot() {
        StringBuilder b = new StringBuilder();
        b.append("digraph Automaton {\n");
        b.append("  rankdir = LR\n");
        int numStates = this.det.getNumStates();
        if (numStates > 0) {
            b.append("  initial [shape=plaintext,label=\"0\"]\n");
            b.append("  initial -> 0\n");
        }
        Transition t = new Transition();
        for (int state = 0; state < numStates; ++state) {
            b.append("  ");
            b.append(state);
            if (this.det.isAccept(state)) {
                b.append(" [shape=doublecircle,label=\"" + state + "\"]\n");
            } else {
                b.append(" [shape=circle,label=\"" + state + "\"]\n");
            }
            int numTransitions = this.det.initTransition(state, t);
            for (int i = 0; i < numTransitions; ++i) {
                this.det.getNextTransition(t);
                assert (t.max >= t.min);
                for (int j = t.min; j <= t.max; ++j) {
                    b.append("  ");
                    b.append(state);
                    b.append(" -> ");
                    b.append(t.dest);
                    b.append(" [label=\"");
                    if (j == this.anyTermID) {
                        b.append('*');
                    } else {
                        b.append(this.idToTerm.get(j).utf8ToString());
                    }
                    b.append("\"]\n");
                }
            }
        }
        b.append('}');
        return b.toString();
    }

    final class TermAutomatonWeight
    extends Weight {
        private final IndexSearcher searcher;
        final Automaton automaton;
        private final Map<Integer, TermContext> termStates;
        private final Similarity.SimWeight stats;
        private final Similarity similarity;

        public TermAutomatonWeight(Automaton automaton, IndexSearcher searcher, Map<Integer, TermContext> termStates) throws IOException {
            super(TermAutomatonQuery.this);
            this.automaton = automaton;
            this.searcher = searcher;
            this.termStates = termStates;
            this.similarity = searcher.getSimilarity(true);
            ArrayList<TermStatistics> allTermStats = new ArrayList<TermStatistics>();
            for (Map.Entry ent : TermAutomatonQuery.this.idToTerm.entrySet()) {
                Integer termID = (Integer)ent.getKey();
                if (ent.getValue() == null) continue;
                allTermStats.add(searcher.termStatistics(new Term(TermAutomatonQuery.this.field, (BytesRef)ent.getValue()), termStates.get(termID)));
            }
            this.stats = this.similarity.computeWeight(TermAutomatonQuery.this.getBoost(), searcher.collectionStatistics(TermAutomatonQuery.this.field), allTermStats.toArray(new TermStatistics[allTermStats.size()]));
        }

        @Override
        public void extractTerms(Set<Term> terms) {
            for (BytesRef text : TermAutomatonQuery.this.termToID.keySet()) {
                if (text == null) continue;
                terms.add(new Term(TermAutomatonQuery.this.field, text));
            }
        }

        public String toString() {
            return "weight(" + TermAutomatonQuery.this + ")";
        }

        @Override
        public float getValueForNormalization() {
            return this.stats.getValueForNormalization();
        }

        @Override
        public void normalize(float queryNorm, float topLevelBoost) {
            this.stats.normalize(queryNorm, topLevelBoost);
        }

        @Override
        public Scorer scorer(LeafReaderContext context, Bits acceptDocs) throws IOException {
            EnumAndScorer[] enums = new EnumAndScorer[TermAutomatonQuery.this.idToTerm.size()];
            for (Map.Entry<Integer, TermContext> ent : this.termStates.entrySet()) {
                TermContext termContext = ent.getValue();
                assert (termContext.topReaderContext == ReaderUtil.getTopLevelContext(context)) : "The top-reader used to create Weight (" + termContext.topReaderContext + ") is not the same as the current reader's top-reader (" + ReaderUtil.getTopLevelContext(context);
                BytesRef term = (BytesRef)TermAutomatonQuery.this.idToTerm.get(ent.getKey());
                TermState state = termContext.get(context.ord);
                if (state == null) continue;
                TermsEnum termsEnum = context.reader().terms(TermAutomatonQuery.this.field).iterator();
                termsEnum.seekExact(term, state);
                enums[ent.getKey().intValue()] = new EnumAndScorer(ent.getKey(), termsEnum.postings(acceptDocs, null, 24));
            }
            return new TermAutomatonScorer(this, enums, TermAutomatonQuery.this.anyTermID, TermAutomatonQuery.this.idToTerm, this.similarity.simScorer(this.stats, context));
        }

        @Override
        public Explanation explain(LeafReaderContext context, int doc2) throws IOException {
            return null;
        }
    }

    static class EnumAndScorer {
        public final int termID;
        public final PostingsEnum posEnum;
        public int posLeft;
        public int pos;

        public EnumAndScorer(int termID, PostingsEnum posEnum) {
            this.termID = termID;
            this.posEnum = posEnum;
        }
    }
}

