/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.function.valuesource;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.docvalues.FloatDocValues;
import org.apache.lucene.queries.function.valuesource.QueryValueSource;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.mutable.MutableValue;
import org.apache.lucene.util.mutable.MutableValueFloat;

class QueryDocValues
extends FloatDocValues {
    final LeafReaderContext readerContext;
    final Bits acceptDocs;
    final Weight weight;
    final float defVal;
    final Map fcontext;
    final Query q;
    Scorer scorer;
    int scorerDoc;
    boolean noMatches = false;
    int lastDocRequested = Integer.MAX_VALUE;

    public QueryDocValues(QueryValueSource vs, LeafReaderContext readerContext, Map fcontext) throws IOException {
        super(vs);
        Weight w;
        this.readerContext = readerContext;
        this.acceptDocs = readerContext.reader().getLiveDocs();
        this.defVal = vs.defVal;
        this.q = vs.q;
        this.fcontext = fcontext;
        Weight weight = w = fcontext == null ? null : (Weight)fcontext.get(vs);
        if (w == null) {
            IndexSearcher weightSearcher;
            if (fcontext == null) {
                weightSearcher = new IndexSearcher(ReaderUtil.getTopLevelContext(readerContext));
            } else {
                weightSearcher = (IndexSearcher)fcontext.get("searcher");
                if (weightSearcher == null) {
                    weightSearcher = new IndexSearcher(ReaderUtil.getTopLevelContext(readerContext));
                }
            }
            vs.createWeight(fcontext, weightSearcher);
            w = (Weight)fcontext.get(vs);
        }
        this.weight = w;
    }

    @Override
    public float floatVal(int doc2) {
        try {
            if (doc2 < this.lastDocRequested) {
                if (this.noMatches) {
                    return this.defVal;
                }
                this.scorer = this.weight.scorer(this.readerContext, this.acceptDocs);
                if (this.scorer == null) {
                    this.noMatches = true;
                    return this.defVal;
                }
                this.scorerDoc = -1;
            }
            this.lastDocRequested = doc2;
            if (this.scorerDoc < doc2) {
                this.scorerDoc = this.scorer.advance(doc2);
            }
            if (this.scorerDoc > doc2) {
                return this.defVal;
            }
            return this.scorer.score();
        }
        catch (IOException e2) {
            throw new RuntimeException("caught exception in QueryDocVals(" + this.q + ") doc=" + doc2, e2);
        }
    }

    @Override
    public boolean exists(int doc2) {
        try {
            if (doc2 < this.lastDocRequested) {
                if (this.noMatches) {
                    return false;
                }
                this.scorer = this.weight.scorer(this.readerContext, this.acceptDocs);
                this.scorerDoc = -1;
                if (this.scorer == null) {
                    this.noMatches = true;
                    return false;
                }
            }
            this.lastDocRequested = doc2;
            if (this.scorerDoc < doc2) {
                this.scorerDoc = this.scorer.advance(doc2);
            }
            return this.scorerDoc <= doc2;
        }
        catch (IOException e2) {
            throw new RuntimeException("caught exception in QueryDocVals(" + this.q + ") doc=" + doc2, e2);
        }
    }

    @Override
    public Object objectVal(int doc2) {
        try {
            return this.exists(doc2) ? Float.valueOf(this.scorer.score()) : null;
        }
        catch (IOException e2) {
            throw new RuntimeException("caught exception in QueryDocVals(" + this.q + ") doc=" + doc2, e2);
        }
    }

    @Override
    public FunctionValues.ValueFiller getValueFiller() {
        return new FunctionValues.ValueFiller(){
            private final MutableValueFloat mval = new MutableValueFloat();

            @Override
            public MutableValue getValue() {
                return this.mval;
            }

            @Override
            public void fillValue(int doc2) {
                try {
                    if (QueryDocValues.this.noMatches) {
                        this.mval.value = QueryDocValues.this.defVal;
                        this.mval.exists = false;
                        return;
                    }
                    QueryDocValues.this.scorer = QueryDocValues.this.weight.scorer(QueryDocValues.this.readerContext, QueryDocValues.this.acceptDocs);
                    QueryDocValues.this.scorerDoc = -1;
                    if (QueryDocValues.this.scorer == null) {
                        QueryDocValues.this.noMatches = true;
                        this.mval.value = QueryDocValues.this.defVal;
                        this.mval.exists = false;
                        return;
                    }
                    QueryDocValues.this.lastDocRequested = doc2;
                    if (QueryDocValues.this.scorerDoc < doc2) {
                        QueryDocValues.this.scorerDoc = QueryDocValues.this.scorer.advance(doc2);
                    }
                    if (QueryDocValues.this.scorerDoc > doc2) {
                        this.mval.value = QueryDocValues.this.defVal;
                        this.mval.exists = false;
                        return;
                    }
                    this.mval.value = QueryDocValues.this.scorer.score();
                    this.mval.exists = true;
                }
                catch (IOException e2) {
                    throw new RuntimeException("caught exception in QueryDocVals(" + QueryDocValues.this.q + ") doc=" + doc2, e2);
                }
            }
        };
    }

    @Override
    public String toString(int doc2) {
        return "query(" + this.q + ",def=" + this.defVal + ")=" + this.floatVal(doc2);
    }
}

