/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.function.valuesource;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.docvalues.FloatDocValues;
import org.apache.lucene.search.IndexSearcher;

public class LinearFloatFunction
extends ValueSource {
    protected final ValueSource source;
    protected final float slope;
    protected final float intercept;

    public LinearFloatFunction(ValueSource source2, float slope, float intercept) {
        this.source = source2;
        this.slope = slope;
        this.intercept = intercept;
    }

    @Override
    public String description() {
        return this.slope + "*float(" + this.source.description() + ")+" + this.intercept;
    }

    @Override
    public FunctionValues getValues(Map context, LeafReaderContext readerContext) throws IOException {
        final FunctionValues vals2 = this.source.getValues(context, readerContext);
        return new FloatDocValues(this){

            @Override
            public float floatVal(int doc2) {
                return vals2.floatVal(doc2) * LinearFloatFunction.this.slope + LinearFloatFunction.this.intercept;
            }

            @Override
            public boolean exists(int doc2) {
                return vals2.exists(doc2);
            }

            @Override
            public String toString(int doc2) {
                return LinearFloatFunction.this.slope + "*float(" + vals2.toString(doc2) + ")+" + LinearFloatFunction.this.intercept;
            }
        };
    }

    @Override
    public void createWeight(Map context, IndexSearcher searcher) throws IOException {
        this.source.createWeight(context, searcher);
    }

    @Override
    public int hashCode() {
        int h = Float.floatToIntBits(this.slope);
        h = h >>> 2 | h << 30;
        h += Float.floatToIntBits(this.intercept);
        h ^= h << 14 | h >>> 19;
        return h + this.source.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (LinearFloatFunction.class != o.getClass()) {
            return false;
        }
        LinearFloatFunction other = (LinearFloatFunction)o;
        return this.slope == other.slope && this.intercept == other.intercept && this.source.equals(other.source);
    }
}

